/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.ui.reset;

import java.io.File;
import java.util.Collections;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.libs.git.GitClient;
import org.netbeans.libs.git.GitException;
import org.netbeans.libs.git.progress.NotificationListener;
import org.netbeans.modules.git.Git;
import org.netbeans.modules.git.client.GitClient;
import org.netbeans.modules.git.client.GitClientExceptionHandler;
import org.netbeans.modules.git.client.GitProgressSupport;
import org.netbeans.modules.git.ui.actions.GitAction;
import org.netbeans.modules.git.ui.actions.SingleRepositoryAction;
import org.netbeans.modules.git.ui.reset.Reset;
import org.netbeans.modules.git.utils.GitUtils;
import org.netbeans.modules.versioning.spi.VCSContext;
import org.openide.util.NbBundle;

public class ResetAction
extends SingleRepositoryAction {
    private static final Logger LOG = Logger.getLogger(ResetAction.class.getName());

    @Override
    protected void performAction(final File repository, File[] roots, VCSContext context) {
        final Reset reset = new Reset(repository, roots);
        if (reset.show() && (reset.getType() != GitClient.ResetType.SOFT || !reset.getRevision().equals("HEAD"))) {
            GitProgressSupport supp = new GitProgressSupport(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                protected void perform() {
                    block6: {
                        try {
                            final GitClient client = this.getClient();
                            if (reset.getType() == GitClient.ResetType.HARD) {
                                client.addNotificationListener((NotificationListener)new GitProgressSupport.DefaultFileListener(new File[]{repository}));
                            }
                            client.addNotificationListener((NotificationListener)new GitProgressSupport.DefaultFileListener(new File[]{repository}));
                            LOG.log(Level.FINE, "Reset head, revision: {0}", reset.getRevision());
                            if (reset.getType() == GitClient.ResetType.HARD) {
                                GitUtils.runWithoutIndexing(new Callable<Void>(){

                                    @Override
                                    public Void call() throws Exception {
                                        client.reset(reset.getRevision(), reset.getType(), this.getProgressMonitor());
                                        return null;
                                    }
                                }, repository);
                                break block6;
                            }
                            client.reset(reset.getRevision(), reset.getType(), this.getProgressMonitor());
                        }
                        catch (GitException ex) {
                            try {
                                GitClientExceptionHandler.notifyException((Exception)((Object)ex), true);
                            }
                            catch (Throwable throwable) {
                                this.setDisplayName(NbBundle.getMessage(GitAction.class, (String)"LBL_Progress.RefreshingStatuses"));
                                Git.getInstance().getFileStatusCache().refreshAllRoots(Collections.singletonMap(this.getRepositoryRoot(), Git.getInstance().getSeenRoots(repository)));
                                GitUtils.headChanged(repository);
                                throw throwable;
                            }
                            this.setDisplayName(NbBundle.getMessage(GitAction.class, (String)"LBL_Progress.RefreshingStatuses"));
                            Git.getInstance().getFileStatusCache().refreshAllRoots(Collections.singletonMap(this.getRepositoryRoot(), Git.getInstance().getSeenRoots(repository)));
                            GitUtils.headChanged(repository);
                        }
                    }
                    this.setDisplayName(NbBundle.getMessage(GitAction.class, (String)"LBL_Progress.RefreshingStatuses"));
                    Git.getInstance().getFileStatusCache().refreshAllRoots(Collections.singletonMap(this.getRepositoryRoot(), Git.getInstance().getSeenRoots(repository)));
                    GitUtils.headChanged(repository);
                }
            };
            supp.start(Git.getInstance().getRequestProcessor(repository), repository, NbBundle.getMessage(ResetAction.class, (String)"LBL_Reset.progressName"));
        }
    }
}

