/*
 * Decompiled with CFR 0.152.
 */
package org.whattf.datatype;

import org.relaxng.datatype.DatatypeException;
import org.whattf.datatype.AbstractDatatype;
import org.whattf.datatype.data.CharsetData;

public class Charset
extends AbstractDatatype {
    public static final Charset THE_INSTANCE = new Charset();

    @Override
    public void checkValid(CharSequence literal) throws DatatypeException {
        if (literal.length() == 0) {
            throw this.newDatatypeException("The empty string is not a valid character encoding name.");
        }
        for (int i = 0; i < literal.length(); ++i) {
            char c = literal.charAt(i);
            if (c >= '0' && c <= '9' || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '-' || c == '!' || c == '#' || c == '$' || c == '%' || c == '&' || c == '\'' || c == '+' || c == '_' || c == '`' || c == '{' || c == '}' || c == '~' || c == '^') continue;
            throw this.newDatatypeException("Value contained ", c, ", which is not a valid character in an encoding name.");
        }
        String encodingName = literal.toString();
        if ("replacement".equals(encodingName = Charset.toAsciiLowerCase(encodingName)) || !CharsetData.isPreferred(encodingName)) {
            String preferred = CharsetData.preferredForLabel(encodingName);
            if (preferred == null || "replacement".equals(preferred)) {
                throw this.newDatatypeException("\u201c" + encodingName + "\u201d is not a valid character encoding name.");
            }
            throw this.newDatatypeException("\u201c" + encodingName + "\u201d is not a preferred encoding name." + " The preferred label for this encoding is \u201c" + preferred + "\u201d.");
        }
    }

    @Override
    public String getName() {
        return "encoding name";
    }
}

