/*
 * Decompiled with CFR 0.152.
 */
package org.whattf.datatype;

import org.relaxng.datatype.DatatypeException;
import org.whattf.datatype.AbstractDatatype;

public class SimpleColor
extends AbstractDatatype {
    public static final SimpleColor THE_INSTANCE = new SimpleColor();

    private SimpleColor() {
    }

    @Override
    public void checkValid(CharSequence literal) throws DatatypeException {
        if (literal.length() != 7) {
            throw this.newDatatypeException("Incorrect length for color string.");
        }
        char c = literal.charAt(0);
        if (c != '#') {
            throw this.newDatatypeException(0, "Color starts with incorrect character ", c, ". Expected the number sign.");
        }
        for (int i = 1; i < 7; ++i) {
            c = literal.charAt(i);
            if (c >= '0' && c <= '9' || c >= 'A' && c <= 'F' || c >= 'a' && c <= 'f') continue;
            throw this.newDatatypeException(0, "", c, " is not a valid hexadecimal digit.");
        }
    }

    @Override
    public String getName() {
        return "simple color";
    }
}

