/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.karma.run;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.gsf.testrunner.api.Status;
import org.netbeans.modules.gsf.testrunner.api.TestSession;
import org.netbeans.modules.gsf.testrunner.api.TestSuite;
import org.netbeans.modules.gsf.testrunner.api.Testcase;
import org.netbeans.modules.gsf.testrunner.api.Trouble;
import org.netbeans.modules.gsf.testrunner.ui.api.Manager;
import org.netbeans.modules.gsf.testrunner.ui.api.TestRunnerNodeFactory;
import org.netbeans.modules.javascript.karma.run.Bundle;
import org.netbeans.modules.javascript.karma.run.JumpToCallStackAction;
import org.netbeans.modules.javascript.karma.run.KarmaRunInfo;
import org.netbeans.modules.javascript.karma.run.KarmaTestRunnerNodeFactory;
import org.netbeans.modules.javascript.karma.util.StringUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Pair;

public final class TestRunner {
    static final Logger LOGGER = Logger.getLogger(TestRunner.class.getName());
    public static final String NB_LINE = "$NB$netbeans ";
    private static final String NEW_LINE_REGEX = "\\s*\\\\n\\s*";
    private static final String UNCAUGHT_ERROR_PREFIX = "Uncaught Error: ";
    private static final String BROWSER_START = "$NB$netbeans browserStart";
    private static final String BROWSER_END = "$NB$netbeans browserEnd";
    private static final String BROWSER_ERROR = "$NB$netbeans browserError";
    private static final String SUITE_START = "$NB$netbeans suiteStart";
    private static final String SUITE_END = "$NB$netbeans suiteEnd";
    private static final String TEST = "$NB$netbeans test";
    private static final String TEST_PASS = "$NB$netbeans testPass";
    private static final String TEST_IGNORE = "$NB$netbeans testIgnore";
    private static final String TEST_FAILURE = "$NB$netbeans testFailure";
    private static final String NB_VALUE_REGEX = "\\$NB\\$(.*)\\$NB\\$";
    private static final String NAME_REGEX = "name=\\$NB\\$(.*)\\$NB\\$";
    private static final String BROWSER_REGEX = "browser=\\$NB\\$(.*)\\$NB\\$";
    private static final String DURATION_REGEX = "duration=\\$NB\\$(.*)\\$NB\\$";
    private static final String DETAILS_REGEX = "details=\\$NB\\$(.*)\\$NB\\$";
    private static final String ERROR_REGEX = "error=\\$NB\\$(.*)\\$NB\\$";
    private static final Pattern NAME_PATTERN = Pattern.compile("name=\\$NB\\$(.*)\\$NB\\$");
    private static final Pattern BROWSER_NAME_PATTERN = Pattern.compile("browser=\\$NB\\$(.*)\\$NB\\$ name=\\$NB\\$(.*)\\$NB\\$");
    private static final Pattern BROWSER_ERROR_PATTERN = Pattern.compile("browser=\\$NB\\$(.*)\\$NB\\$ error=\\$NB\\$(.*)\\$NB\\$");
    private static final Pattern NAME_DURATION_PATTERN = Pattern.compile("name=\\$NB\\$(.*)\\$NB\\$ duration=\\$NB\\$(.*)\\$NB\\$");
    private static final Pattern NAME_DETAILS_DURATION_PATTERN = Pattern.compile("name=\\$NB\\$(.*)\\$NB\\$ details=\\$NB\\$(.*)\\$NB\\$ duration=\\$NB\\$(.*)\\$NB\\$");
    private static final Pattern STACK_TRACE_FILE_LINE_PATTERN = Pattern.compile("http://[^/]+/(?:base|absolute)(?<FILE>[^?\\s]*)(?:\\?[^:]*)?");
    private final KarmaRunInfo karmaRunInfo;
    private final AtomicLong browserCount = new AtomicLong();
    private final Map<String, List<String>> browserErrors = new HashMap<String, List<String>>();
    private TestSession testSession;
    private TestSuite testSuite;
    private long testSuiteRuntime = 0L;
    private boolean hasTests = false;
    private final ArrayList<String> logMessages = new ArrayList();

    public TestRunner(KarmaRunInfo karmaRunInfo) {
        assert (karmaRunInfo != null);
        this.karmaRunInfo = karmaRunInfo;
    }

    public void process(String line) {
        LOGGER.finest(line);
        if (line.startsWith(TEST)) {
            this.testFinished(line);
        } else if (line.startsWith(SUITE_START)) {
            this.suiteStarted(line);
        } else if (line.startsWith(SUITE_END)) {
            this.suiteFinished(line);
        } else if (line.startsWith(BROWSER_START)) {
            if (this.browserCount.incrementAndGet() == 1L) {
                this.sessionStarted(line);
            }
        } else if (line.startsWith(BROWSER_END)) {
            if (this.browserCount.decrementAndGet() == 0L) {
                this.sessionFinished(line);
            }
        } else if (line.startsWith(BROWSER_ERROR)) {
            this.browserError(line);
        } else {
            LOGGER.log(Level.FINE, "Unexpected line: {0}", line);
            assert (false) : line;
        }
    }

    public void logMessageToTestResultsWindowOutputView(String line) {
        if (this.testSession == null) {
            this.logMessages.add(line);
            return;
        }
        if (!this.logMessages.isEmpty()) {
            for (String log : this.logMessages) {
                this.getManager().displayOutput(this.testSession, log, false);
            }
            this.logMessages.clear();
        }
        this.getManager().displayOutput(this.testSession, line, false);
    }

    private Manager getManager() {
        return Manager.getInstance();
    }

    private String getOutputTitle() {
        StringBuilder sb = new StringBuilder(30);
        sb.append(ProjectUtils.getInformation((Project)this.karmaRunInfo.getProject()).getDisplayName());
        String testFile = this.karmaRunInfo.getTestFile();
        if (testFile != null) {
            sb.append(":");
            sb.append(new File(testFile).getName());
        }
        return Bundle.TestRunner_runner_title(sb.toString());
    }

    private void initTestSession() {
        if (this.testSession != null) {
            return;
        }
        Manager.getInstance().setNodeFactory((TestRunnerNodeFactory)new KarmaTestRunnerNodeFactory(new CallStackCallback(this.karmaRunInfo.getProject())));
        this.testSession = new TestSession(this.getOutputTitle(), this.karmaRunInfo.getProject(), TestSession.SessionType.TEST);
        this.testSession.setRerunHandler(this.karmaRunInfo.getRerunHandler());
        this.getManager().testStarted(this.testSession);
    }

    private void sessionStarted(String line) {
        this.initTestSession();
    }

    private void sessionFinished(String line) {
        assert (this.testSession != null);
        if (this.testSuite != null) {
            this.suiteFinished(null);
        }
        if (!this.browserErrors.isEmpty()) {
            this.processErrors();
            this.getManager().displayOutput(this.testSession, Bundle.TestRunner_tests_error(), true);
            this.getManager().displayOutput(this.testSession, Bundle.TestRunner_output_verify(), true);
        } else if (!this.hasTests) {
            this.getManager().displayOutput(this.testSession, Bundle.TestRunner_tests_none(), true);
            this.getManager().displayOutput(this.testSession, Bundle.TestRunner_output_verify(), true);
        } else {
            this.getManager().displayOutput(this.testSession, Bundle.TestRunner_output_view(), false);
        }
        this.getManager().sessionFinished(this.testSession);
        this.testSession = null;
        this.hasTests = false;
        this.browserErrors.clear();
    }

    private void browserError(String line) {
        String error;
        String browser;
        this.initTestSession();
        Matcher matcher = BROWSER_ERROR_PATTERN.matcher(line);
        if (matcher.find()) {
            String[] errorLines;
            browser = matcher.group(1);
            this.getManager().displayOutput(this.testSession, Bundle.TestRunner_browser_error(browser), true);
            error = matcher.group(2);
            if (error.startsWith("\"") && (error = error.substring(1)).endsWith("\"")) {
                error = error.substring(0, error.length() - 1);
            }
            for (String errorLine : errorLines = error.split(NEW_LINE_REGEX)) {
                this.getManager().displayOutput(this.testSession, errorLine, true);
            }
        } else {
            LOGGER.log(Level.FINE, "Unexpected browser error line: {0}", line);
            this.getManager().displayOutput(this.testSession, line, true);
            browser = Bundle.TestRunner_browser_unknown();
            error = line;
            assert (this.assertLine(line));
        }
        this.getManager().displayOutput(this.testSession, "", false);
        List<String> errors = this.browserErrors.get(browser);
        if (errors == null) {
            errors = new ArrayList<String>();
            this.browserErrors.put(browser, errors);
        }
        errors.add(error);
    }

    private boolean assertLine(String line) {
        assert (false) : line;
        return true;
    }

    private void processErrors() {
        if (!this.karmaRunInfo.isFailOnBrowserError()) {
            return;
        }
        for (Map.Entry<String, List<String>> entry : this.browserErrors.entrySet()) {
            TestSuite errorTestSuite = new TestSuite(Bundle.TestRunner_error_suite(entry.getKey()));
            this.testSession.addSuite(errorTestSuite);
            this.getManager().displaySuiteRunning(this.testSession, errorTestSuite.getName());
            for (String info : entry.getValue()) {
                String[] details = TestRunner.processDetails(info);
                String name = details[0];
                if (name.startsWith(UNCAUGHT_ERROR_PREFIX) && !StringUtils.hasText(name = name.substring(UNCAUGHT_ERROR_PREFIX.length()).trim())) {
                    name = details[0];
                }
                Trouble trouble = new Trouble(true);
                if (details.length > 1) {
                    String[] stackTrace = new String[details.length - 1];
                    System.arraycopy(details, 1, stackTrace, 0, stackTrace.length);
                    trouble.setStackTrace(stackTrace);
                }
                this.addTestCase(name, Status.ERROR, 0L, trouble);
            }
            this.getManager().displayReport(this.testSession, this.testSession.getReport(0L), true);
        }
    }

    private void suiteStarted(String line) {
        assert (this.testSession != null);
        if (this.testSuite != null) {
            this.suiteFinished(null);
        }
        assert (this.testSuite == null);
        assert (this.testSuiteRuntime == 0L);
        String name = line;
        Matcher matcher = BROWSER_NAME_PATTERN.matcher(line);
        if (matcher.find()) {
            name = Bundle.TestRunner_suite_name(matcher.group(1), matcher.group(2));
        } else {
            LOGGER.log(Level.FINE, "Unexpected suite line: {0}", line);
            assert (false) : line;
        }
        if (!StringUtils.hasText(name)) {
            name = Bundle.TestRunner_noName();
        }
        this.testSuite = new TestSuite(name);
        this.testSession.addSuite(this.testSuite);
        this.getManager().displaySuiteRunning(this.testSession, this.testSuite.getName());
    }

    private void suiteFinished(@NullAllowed String line) {
        assert (this.testSession != null);
        if (this.testSuite == null) {
            return;
        }
        this.getManager().displayReport(this.testSession, this.testSession.getReport(this.testSuiteRuntime), true);
        this.testSuite = null;
        this.testSuiteRuntime = 0L;
    }

    private void testFinished(String line) {
        assert (this.testSession != null);
        this.hasTests = true;
        if (line.startsWith(TEST_PASS)) {
            this.testPass(line);
        } else if (line.startsWith(TEST_FAILURE)) {
            this.testFailure(line);
        } else if (line.startsWith(TEST_IGNORE)) {
            this.testIgnore(line);
        } else {
            LOGGER.log(Level.FINE, "Unexpected test line: {0}", line);
            assert (false) : line;
        }
    }

    private void testPass(String line) {
        Matcher matcher = NAME_DURATION_PATTERN.matcher(line);
        if (matcher.find()) {
            String name = matcher.group(1);
            if (!StringUtils.hasText(name)) {
                name = Bundle.TestRunner_noName();
            }
            long runtime = Long.parseLong(matcher.group(2));
            this.addTestCase(name, Status.PASSED, runtime);
        } else {
            LOGGER.log(Level.FINE, "Unexpected test PASS line: {0}", line);
            assert (false) : line;
        }
    }

    private void testFailure(String line) {
        Matcher matcher = NAME_DETAILS_DURATION_PATTERN.matcher(line);
        if (matcher.find()) {
            String name = matcher.group(1);
            if (!StringUtils.hasText(name)) {
                name = Bundle.TestRunner_noName();
            }
            Trouble trouble = new Trouble(false);
            trouble.setStackTrace(TestRunner.processDetails(matcher.group(2)));
            long runtime = Long.parseLong(matcher.group(3));
            this.addTestCase(name, Status.FAILED, runtime, trouble);
        } else {
            LOGGER.log(Level.FINE, "Unexpected test FAILURE line: {0}", line);
            assert (false) : line;
        }
    }

    static String[] processDetails(String details) {
        if (details.startsWith("[\"")) {
            details = details.substring(2);
        }
        if (details.endsWith("\"]")) {
            details = details.substring(0, details.length() - 2);
        }
        return STACK_TRACE_FILE_LINE_PATTERN.matcher(details).replaceAll("${FILE}").split(NEW_LINE_REGEX);
    }

    private void testIgnore(String line) {
        Matcher matcher = NAME_PATTERN.matcher(line);
        if (matcher.find()) {
            String name = matcher.group(1);
            if (!StringUtils.hasText(name)) {
                name = Bundle.TestRunner_noName();
            }
            this.addTestCase(name, Status.IGNORED);
        } else {
            LOGGER.log(Level.FINE, "Unexpected test IGNORE line: {0}", line);
            assert (false) : line;
        }
    }

    private void addTestCase(String name, Status status) {
        this.addTestCase(name, status, 0L);
    }

    private void addTestCase(String name, Status status, long runtime) {
        this.addTestCase(name, status, runtime, null);
    }

    private void addTestCase(String name, Status status, long runtime, Trouble trouble) {
        Testcase testCase = new Testcase(name, "Karma", this.testSession);
        testCase.setStatus(status);
        this.testSuiteRuntime += runtime;
        testCase.setTimeMillis(runtime);
        if (trouble != null) {
            testCase.setTrouble(trouble);
        }
        this.testSession.addTestCase(testCase);
    }

    private static final class CallStackCallback
    implements JumpToCallStackAction.Callback {
        private static final Pattern FILE_LINE_PATTERN = Pattern.compile("/(?<FILE>[^:]+):(?<LINE>\\d+)");
        private final File projectDir;

        public CallStackCallback(Project project) {
            assert (project != null);
            this.projectDir = FileUtil.toFile((FileObject)project.getProjectDirectory());
        }

        @Override
        public Pair<File, Integer> parseLocation(String callStack) {
            Matcher matcher = FILE_LINE_PATTERN.matcher(callStack);
            if (matcher.find()) {
                File file;
                File path = new File(matcher.group("FILE").replace('/', File.separatorChar));
                if (path.isAbsolute()) {
                    file = path;
                } else {
                    file = new File(this.projectDir, path.getPath());
                    if (!file.isFile()) {
                        return null;
                    }
                }
                return Pair.of((Object)file, (Object)Integer.parseInt(matcher.group("LINE")));
            }
            return null;
        }
    }
}

