/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.transport.tcp.encoding;

import com.sun.istack.NotNull;
import com.sun.istack.Nullable;
import com.sun.xml.fastinfoset.stax.StAXDocumentParser;
import com.sun.xml.fastinfoset.stax.StAXDocumentSerializer;
import com.sun.xml.fastinfoset.vocab.ParserVocabulary;
import com.sun.xml.fastinfoset.vocab.SerializerVocabulary;
import com.sun.xml.stream.buffer.XMLStreamBuffer;
import com.sun.xml.ws.api.SOAPVersion;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.pipe.Codec;
import com.sun.xml.ws.api.pipe.Codecs;
import com.sun.xml.ws.api.pipe.ContentType;
import com.sun.xml.ws.api.pipe.StreamSOAPCodec;
import com.sun.xml.ws.encoding.ContentTypeImpl;
import com.sun.xml.ws.message.stream.StreamHeader;
import com.sun.xml.ws.transport.tcp.encoding.WSTCPFastInfosetStreamReaderRecyclable;
import com.sun.xml.ws.transport.tcp.encoding.WSTCPFastInfosetStreamSOAP11Codec;
import com.sun.xml.ws.transport.tcp.encoding.WSTCPFastInfosetStreamSOAP12Codec;
import com.sun.xml.ws.transport.tcp.encoding.configurator.WSTCPCodecConfigurator;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.ws.WebServiceException;

public abstract class WSTCPFastInfosetStreamCodec
implements Codec {
    private StAXDocumentParser _statefulParser;
    private StAXDocumentSerializer _serializer;
    private final StreamSOAPCodec _soapCodec;
    private final boolean _retainState;
    protected final ContentType _defaultContentType;
    private final WSTCPFastInfosetStreamReaderRecyclable.RecycleAwareListener _readerRecycleListener;

    WSTCPFastInfosetStreamCodec(@Nullable StreamSOAPCodec soapCodec, @NotNull SOAPVersion soapVersion, @NotNull WSTCPFastInfosetStreamReaderRecyclable.RecycleAwareListener readerRecycleListener, boolean retainState, String mimeType) {
        this._soapCodec = soapCodec != null ? soapCodec : Codecs.createSOAPEnvelopeXmlCodec(soapVersion);
        this._readerRecycleListener = readerRecycleListener;
        this._retainState = retainState;
        this._defaultContentType = new ContentTypeImpl(mimeType);
    }

    WSTCPFastInfosetStreamCodec(WSTCPFastInfosetStreamCodec that) {
        this._soapCodec = (StreamSOAPCodec)that._soapCodec.copy();
        this._readerRecycleListener = that._readerRecycleListener;
        this._retainState = that._retainState;
        this._defaultContentType = that._defaultContentType;
    }

    public String getMimeType() {
        return this._defaultContentType.getContentType();
    }

    public ContentType getStaticContentType(Packet packet) {
        return this.getContentType(packet.soapAction);
    }

    public ContentType encode(Packet packet, OutputStream out) {
        if (packet.getMessage() != null) {
            XMLStreamWriter writer = this.getXMLStreamWriter(out);
            try {
                packet.getMessage().writeTo(writer);
                writer.flush();
            }
            catch (XMLStreamException e) {
                throw new WebServiceException((Throwable)e);
            }
        }
        return this.getContentType(packet.soapAction);
    }

    public ContentType encode(Packet packet, WritableByteChannel buffer) {
        throw new UnsupportedOperationException();
    }

    public void decode(InputStream in, String contentType, Packet response) throws IOException {
        response.setMessage(this._soapCodec.decode(this.getXMLStreamReader(in)));
    }

    public void decode(ReadableByteChannel in, String contentType, Packet response) {
        throw new UnsupportedOperationException();
    }

    protected abstract StreamHeader createHeader(XMLStreamReader var1, XMLStreamBuffer var2);

    protected abstract ContentType getContentType(String var1);

    private XMLStreamWriter getXMLStreamWriter(OutputStream out) {
        if (this._serializer != null) {
            this._serializer.setOutputStream(out);
            return this._serializer;
        }
        WSTCPCodecConfigurator configurator = WSTCPCodecConfigurator.INSTANCE;
        StAXDocumentSerializer serializer = configurator.getDocumentSerializerFactory().newInstance();
        serializer.setOutputStream(out);
        if (this._retainState) {
            SerializerVocabulary vocabulary = configurator.getSerializerVocabularyFactory().newInstance();
            serializer.setVocabulary(vocabulary);
            serializer.setMinAttributeValueSize(configurator.getMinAttributeValueSize());
            serializer.setMaxAttributeValueSize(configurator.getMaxAttributeValueSize());
            serializer.setMinCharacterContentChunkSize(configurator.getMinCharacterContentChunkSize());
            serializer.setMaxCharacterContentChunkSize(configurator.getMaxCharacterContentChunkSize());
            serializer.setAttributeValueMapMemoryLimit(configurator.getAttributeValueMapMemoryLimit());
            serializer.setCharacterContentChunkMapMemoryLimit(configurator.getCharacterContentChunkMapMemoryLimit());
        }
        this._serializer = serializer;
        return serializer;
    }

    private XMLStreamReader getXMLStreamReader(InputStream in) {
        if (this._statefulParser != null) {
            this._statefulParser.setInputStream(in);
            return this._statefulParser;
        }
        WSTCPCodecConfigurator configurator = WSTCPCodecConfigurator.INSTANCE;
        StAXDocumentParser parser = configurator.getDocumentParserFactory().newInstance();
        parser.setInputStream(in);
        if (parser instanceof WSTCPFastInfosetStreamReaderRecyclable) {
            ((WSTCPFastInfosetStreamReaderRecyclable)parser).setListener(this._readerRecycleListener);
        }
        parser.setStringInterning(true);
        if (this._retainState) {
            ParserVocabulary vocabulary = configurator.getParserVocabularyFactory().newInstance();
            parser.setVocabulary(vocabulary);
        }
        this._statefulParser = parser;
        return this._statefulParser;
    }

    public static WSTCPFastInfosetStreamCodec create(StreamSOAPCodec soapCodec, SOAPVersion version, WSTCPFastInfosetStreamReaderRecyclable.RecycleAwareListener readerRecycleListener, boolean retainState) {
        if (version == null) {
            throw new IllegalArgumentException();
        }
        switch (version) {
            case SOAP_11: {
                return new WSTCPFastInfosetStreamSOAP11Codec(soapCodec, readerRecycleListener, retainState);
            }
            case SOAP_12: {
                return new WSTCPFastInfosetStreamSOAP12Codec(soapCodec, readerRecycleListener, retainState);
            }
        }
        throw new AssertionError();
    }
}

