/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.glassfish.common.nodes.actions;

import java.util.concurrent.Future;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.glassfish.common.nodes.actions.DisableModulesCookie;
import org.netbeans.modules.glassfish.common.nodes.actions.RefreshModulesCookie;
import org.netbeans.modules.glassfish.spi.ServerUtilities;
import org.netbeans.modules.glassfish.tooling.admin.ResultString;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.NodeAction;

public class DisableModulesAction
extends NodeAction {
    protected void performAction(Node[] nodes) {
        if (nodes == null || nodes.length < 1) {
            return;
        }
        RequestProcessor enabler = new RequestProcessor("gf-disable-module");
        for (Node node : nodes) {
            DisableModulesCookie uCookie = (DisableModulesCookie)node.getCookie(DisableModulesCookie.class);
            if (uCookie == null) continue;
            final Future<ResultString> result = uCookie.disableModule();
            final Node pNode = node.getParentNode().getParentNode();
            final Node fnode = node;
            enabler.post(new Runnable(){

                @Override
                public void run() {
                    try {
                        result.get(15000L, ServerUtilities.ACTION_TIMEOUT_UNIT);
                    }
                    catch (TimeoutException ex) {
                        Logger.getLogger("glassfish").log(Level.WARNING, "Disable action timed out for " + fnode.getDisplayName());
                    }
                    catch (InterruptedException ie) {
                    }
                    catch (Exception ex) {
                        Logger.getLogger("glassfish").log(Level.INFO, ex.getLocalizedMessage(), ex);
                    }
                    if (pNode != null) {
                        Node[] nodes;
                        for (Node node : nodes = pNode.getChildren().getNodes()) {
                            RefreshModulesCookie cookie = (RefreshModulesCookie)node.getCookie(RefreshModulesCookie.class);
                            if (cookie == null) continue;
                            cookie.refresh(null, fnode.getDisplayName());
                        }
                    }
                }
            });
        }
    }

    protected boolean enable(Node[] nodes) {
        for (Node node : nodes) {
            DisableModulesCookie cookie = (DisableModulesCookie)node.getCookie(DisableModulesCookie.class);
            if (cookie != null && !cookie.isRunning()) continue;
            return false;
        }
        return true;
    }

    public String getName() {
        return NbBundle.getMessage(DisableModulesAction.class, (String)"LBL_DisableAction");
    }

    protected boolean asynchronous() {
        return false;
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }
}

