/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.viewmodel;

import java.beans.PropertyEditor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.swing.table.TableCellEditor;
import org.netbeans.spi.viewmodel.ColumnModel;
import org.openide.awt.Actions;
import org.openide.awt.Mnemonics;
import org.openide.nodes.PropertySupport;

public class Column
extends PropertySupport.ReadWrite {
    public static final String PROP_ORDER_NUMBER = "OrderNumberOutline";
    private PropertyEditor propertyEditor;
    private ColumnModel columnModel;

    Column(ColumnModel columnModel) {
        super(columnModel.getID(), columnModel.getType() == null ? String.class : columnModel.getType(), Actions.cutAmpersand((String)columnModel.getDisplayName()), columnModel.getShortDescription());
        Character mnemonic;
        this.columnModel = columnModel;
        this.setValue("SortableColumn", columnModel.isSortable());
        if (columnModel.getType() == null) {
            this.setValue("TreeColumnTTV", Boolean.TRUE);
        }
        if (Mnemonics.findMnemonicAmpersand((String)columnModel.getDisplayName()) >= 0) {
            this.setValue("ColumnDisplayNameWithMnemonicTTV", columnModel.getDisplayName());
        }
        if ((mnemonic = columnModel.getDisplayedMnemonic()) != null) {
            this.setValue("ColumnMnemonicCharTTV", mnemonic);
        }
        this.propertyEditor = columnModel.getPropertyEditor();
    }

    int getColumnWidth() {
        return this.columnModel.getColumnWidth();
    }

    void setColumnWidth(int width) {
        this.columnModel.setColumnWidth(width);
    }

    int getOrderNumber() {
        Object o = this.getValue("OrderNumberTTV");
        if (o == null) {
            return -1;
        }
        return (Integer)o;
    }

    int getModelOrderNumber() {
        return this.columnModel.getCurrentOrderNumber();
    }

    boolean isDefault() {
        return this.columnModel.getType() == null;
    }

    public boolean isHidden() {
        return !this.columnModel.isVisible();
    }

    public void setHidden(boolean hidden) {
        this.columnModel.setVisible(!hidden);
    }

    public Object getValue() {
        return null;
    }

    public void setValue(Object obj) {
    }

    public Object getValue(String propertyName) {
        if (PROP_ORDER_NUMBER.equals(propertyName)) {
            int index = this.columnModel.getCurrentOrderNumber();
            return new Integer(index);
        }
        if ("InvisibleInTreeTableView".equals(propertyName)) {
            return !this.columnModel.isVisible();
        }
        if ("SortableColumn".equals(propertyName)) {
            return this.columnModel.isSortable();
        }
        if ("DescendingOrderTTV".equals(propertyName)) {
            return this.columnModel.isSortedDescending();
        }
        return super.getValue(propertyName);
    }

    public void setValue(String propertyName, Object newValue) {
        if (PROP_ORDER_NUMBER.equals(propertyName)) {
            int index = (Integer)newValue;
            this.columnModel.setCurrentOrderNumber(index);
        } else if ("DescendingOrderTTV".equals(propertyName)) {
            this.columnModel.setSortedDescending((Boolean)newValue);
        } else {
            super.setValue(propertyName, newValue);
        }
    }

    boolean isSorted() {
        return this.columnModel.isSorted();
    }

    boolean isSortedDescending() {
        return this.columnModel.isSortedDescending();
    }

    void setSorted(boolean sorted) {
        this.columnModel.setSorted(sorted);
    }

    void setSortedDescending(boolean descending) {
        this.columnModel.setSortedDescending(descending);
    }

    public PropertyEditor getPropertyEditor() {
        return this.propertyEditor;
    }

    TableCellEditor getTableCellEditor() {
        try {
            Method method = this.columnModel.getClass().getMethod("getTableCellEditor", new Class[0]);
            if (!TableCellEditor.class.isAssignableFrom(method.getReturnType())) {
                return null;
            }
            return (TableCellEditor)method.invoke((Object)this.columnModel, new Object[0]);
        }
        catch (IllegalAccessException ex) {
        }
        catch (IllegalArgumentException ex) {
        }
        catch (InvocationTargetException ex) {
        }
        catch (NoSuchMethodException ex) {
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return null;
    }

    public String toString() {
        return super.toString() + " with ColumnModel " + this.columnModel;
    }
}

