/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.viewmodel;

import java.awt.datatransfer.Transferable;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.viewmodel.DefaultTreeExpansionManager;
import org.netbeans.modules.viewmodel.ExceptionNode;
import org.netbeans.modules.viewmodel.HyperColumnModel;
import org.netbeans.modules.viewmodel.HyperCompoundModel;
import org.netbeans.modules.viewmodel.TreeModelNode;
import org.netbeans.modules.viewmodel.TreeModelRoot;
import org.netbeans.spi.viewmodel.AsynchronousModelFilter;
import org.netbeans.spi.viewmodel.ColumnModel;
import org.netbeans.spi.viewmodel.Models;
import org.netbeans.spi.viewmodel.TreeModelFilter;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.datatransfer.PasteType;

public class TreeModelHyperNode
extends TreeModelNode {
    private HyperCompoundModel model;

    public TreeModelHyperNode(HyperCompoundModel model, TreeModelRoot treeModelRoot, Object object) {
        super(model.getMain(), model.getColumns(), null, TreeModelHyperNode.createChildren(model, treeModelRoot, object), treeModelRoot, object);
        this.model = model;
    }

    private static Children createChildren(HyperCompoundModel model, TreeModelRoot treeModelRoot, Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        return new HyperModelChildren(model, treeModelRoot, object);
    }

    @Override
    protected void refreshTheChildren(Set<Models.CompoundModel> models, TreeModelNode.TreeModelChildren.RefreshingInfo refreshInfo) {
        Children ch = this.getChildren();
        if (ch instanceof TreeModelNode.TreeModelChildren) {
            HyperModelChildren hch;
            HyperModelChildren hyperModelChildren = hch = (HyperModelChildren)ch;
            hyperModelChildren.getClass();
            hch.refreshChildren(hyperModelChildren.new HyperModelChildren.HyperRefreshingInfo(refreshInfo, models));
        } else {
            this.setChildren((Children)new HyperModelChildren(this.model, this.treeModelRoot, this.object));
        }
    }

    @Override
    public PasteType getDropType(Transferable t, int action, int index) {
        Models.CompoundModel cm2;
        int[] modelIndexPtr;
        int index1;
        if (index < 0) {
            PasteType p;
            Models.CompoundModel mm = this.model.getMain();
            try {
                p = mm.getDropType(this.object, t, action, index);
            }
            catch (UnknownTypeException e) {
                p = null;
            }
            if (p == null) {
                for (Models.CompoundModel m : this.model.getModels()) {
                    if (m == mm) continue;
                    try {
                        p = m.getDropType(this.object, t, action, index);
                        if (p == null) continue;
                        break;
                    }
                    catch (UnknownTypeException ex) {
                        // empty catch block
                    }
                }
            }
            return p;
        }
        PasteType p = null;
        HyperModelChildren hch = (HyperModelChildren)this.getChildren();
        Models.CompoundModel cm1 = hch.getRootModelByIndex(index1 = index > 0 ? index - 1 : index, modelIndexPtr = new int[]{-1});
        if (cm1 != null) {
            try {
                if (index1 < index) {
                    modelIndexPtr[0] = modelIndexPtr[0] + 1;
                }
                p = cm1.getDropType(this.object, t, action, modelIndexPtr[0]);
            }
            catch (UnknownTypeException e) {
                // empty catch block
            }
        }
        if (p == null && index1 < index && (cm2 = hch.getRootModelByIndex(index, modelIndexPtr)) != null && cm2 != cm1) {
            try {
                p = cm2.getDropType(this.object, t, action, modelIndexPtr[0]);
            }
            catch (UnknownTypeException e) {
                // empty catch block
            }
        }
        return p;
    }

    private static final class HyperModelChildren
    extends TreeModelNode.TreeModelChildren {
        private HyperCompoundModel model;
        private final Map<Object, Models.CompoundModel> rootModelsByChildren = new HashMap<Object, Models.CompoundModel>();
        private final Map<Models.CompoundModel, Object[]> rootChildrenByModels = new HashMap<Models.CompoundModel, Object[]>();
        private final int[] rootModelIndexes;

        public HyperModelChildren(HyperCompoundModel model, TreeModelRoot treeModelRoot, Object object) {
            super(null, model.getColumns(), treeModelRoot, object);
            this.model = model;
            this.rootModelIndexes = new int[model.getModels().length + 1];
        }

        @Override
        protected Executor getModelAsynchronous() {
            Executor exec = null;
            for (Models.CompoundModel m : this.model.getModels()) {
                try {
                    Executor e = m.asynchronous(AsynchronousModelFilter.CALL.CHILDREN, this.object);
                    if (exec == null) {
                        exec = e;
                        continue;
                    }
                    if (e == AsynchronousModelFilter.CURRENT_THREAD) continue;
                    exec = e;
                }
                catch (UnknownTypeException ex) {
                    Exceptions.printStackTrace((Throwable)Exceptions.attachMessage((Throwable)ex, (String)("model = " + this.model + ", object = " + this.object)));
                }
            }
            if (exec == null) {
                exec = AsynchronousModelFilter.CURRENT_THREAD;
            }
            return exec;
        }

        Models.CompoundModel getRootModelByIndex(int index, int[] modelIndexPtr) {
            for (int i = 1; i < this.rootModelIndexes.length; ++i) {
                if (this.rootModelIndexes[i] <= index) continue;
                modelIndexPtr[0] = index - this.rootModelIndexes[i - 1];
                return this.model.getModels()[i - 1];
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected Object[] getModelChildren(TreeModelNode.TreeModelChildren.RefreshingInfo refreshInfo) throws UnknownTypeException {
            if (refreshInfo instanceof HyperRefreshingInfo) {
                HyperRefreshingInfo hri = (HyperRefreshingInfo)refreshInfo;
                for (Models.CompoundModel m : hri.getRefreshedModels()) {
                    this.cleanCachedChildren(m);
                }
            }
            Object[] ch = null;
            TreeModelFilter tf = this.model.getTreeFilter();
            int i = 0;
            int totalCount = 0;
            for (Models.CompoundModel m : this.model.getModels()) {
                Object[] mch;
                Map<Models.CompoundModel, Object[]> map = this.rootChildrenByModels;
                synchronized (map) {
                    mch = this.rootChildrenByModels.get(m);
                }
                if (mch == null) {
                    int count2;
                    if (tf != null) {
                        count2 = tf.getChildrenCount(m, this.object);
                        mch = tf.getChildren(m, this.object, 0, count2);
                        if (mch == null) {
                            Logger.getLogger(TreeModelNode.class.getName()).log(Level.CONFIG, "Model: " + tf + "\nreturned null children for parent '" + this.object + "'");
                            mch = new Object[]{};
                        }
                    } else {
                        count2 = m.getChildrenCount(this.object);
                        mch = m.getChildren(this.object, 0, count2);
                        if (mch == null) {
                            Logger.getLogger(TreeModelNode.class.getName()).log(Level.CONFIG, "Model: " + m + "\nreturned null children for parent '" + this.object + "'");
                            mch = new Object[]{};
                        }
                    }
                    Map<Object, Models.CompoundModel> count2 = this.rootModelsByChildren;
                    synchronized (count2) {
                        for (Object o : mch) {
                            this.rootModelsByChildren.put(o, m);
                        }
                    }
                    count2 = this.rootChildrenByModels;
                    synchronized (count2) {
                        this.rootChildrenByModels.put(m, mch);
                    }
                }
                this.rootModelIndexes[i++] = totalCount;
                totalCount += mch.length;
                if (ch == null) {
                    ch = mch;
                    continue;
                }
                int chl = ch.length;
                Object[] nch = new Object[chl + mch.length];
                System.arraycopy(ch, 0, nch, 0, chl);
                System.arraycopy(mch, 0, nch, chl, mch.length);
                ch = nch;
            }
            this.rootModelIndexes[i] = totalCount;
            return ch;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void cleanCachedChildren(Models.CompoundModel model) {
            Object[] children;
            Map<Object, Object> map = this.rootChildrenByModels;
            synchronized (map) {
                children = this.rootChildrenByModels.remove(model);
            }
            if (children != null) {
                map = this.rootModelsByChildren;
                synchronized (map) {
                    for (Object ch : children) {
                        this.rootModelsByChildren.remove(ch);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void expandIfSetToExpanded(Object child) {
            Models.CompoundModel model;
            Map<Object, Models.CompoundModel> map = this.rootModelsByChildren;
            synchronized (map) {
                model = this.rootModelsByChildren.get(child);
            }
            if (model == null) {
                return;
            }
            try {
                Models.TreeFeatures treeTable;
                DefaultTreeExpansionManager.get(model).setChildrenToActOn(this.getTreeDepth());
                if (model.isExpanded(child) && (treeTable = this.treeModelRoot.getTreeFeatures()) != null && treeTable.isExpanded(this.object)) {
                    treeTable.expandNode(child);
                }
            }
            catch (UnknownTypeException unknownTypeException) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Node[] createNodes(Object object) {
            Models.CompoundModel m;
            if (object == WAIT_KEY) {
                return super.createNodes(object);
            }
            if (object instanceof Exception) {
                return new Node[]{new ExceptionNode((Exception)object)};
            }
            Map<Object, Models.CompoundModel> map = this.rootModelsByChildren;
            synchronized (map) {
                m = this.rootModelsByChildren.get(object);
            }
            if (m == null) {
                return new Node[0];
            }
            TreeModelNode tmn = new TreeModelNode(m, HyperModelChildren.createHyperColumns(this.model.getColumns(), m.getColumns()), this.treeModelRoot, object);
            this.objectToNode.put(object, new WeakReference<TreeModelNode>(tmn));
            return new Node[]{tmn};
        }

        private static ColumnModel[] createHyperColumns(ColumnModel[] mainColumns, ColumnModel[] columns) {
            int n = Math.min(mainColumns.length, columns.length);
            ColumnModel[] hColumns = new ColumnModel[n];
            for (int i = 0; i < n; ++i) {
                hColumns[i] = new HyperColumnModel(mainColumns[i], columns[i]);
            }
            return hColumns;
        }

        public class HyperRefreshingInfo
        extends TreeModelNode.TreeModelChildren.RefreshingInfo {
            private Set<Models.CompoundModel> models;

            public HyperRefreshingInfo(TreeModelNode.TreeModelChildren.RefreshingInfo ri, Set<Models.CompoundModel> models) {
                super(ri.refreshSubNodes);
                this.models = models;
            }

            @Override
            public TreeModelNode.TreeModelChildren.RefreshingInfo mergeWith(TreeModelNode.TreeModelChildren.RefreshingInfo rinfo) {
                if (rinfo instanceof HyperRefreshingInfo) {
                    try {
                        this.models.addAll(((HyperRefreshingInfo)rinfo).models);
                    }
                    catch (UnsupportedOperationException uoex) {
                        this.models = new HashSet<Models.CompoundModel>(this.models);
                        this.models.addAll(((HyperRefreshingInfo)rinfo).models);
                    }
                }
                this.refreshSubNodes = this.refreshSubNodes || rinfo.refreshSubNodes;
                return this;
            }

            public Set<Models.CompoundModel> getRefreshedModels() {
                return this.models;
            }

            @Override
            public boolean isRefreshSubNodes(Object child) {
                return super.isRefreshSubNodes(child) && this.models.contains(HyperModelChildren.this.rootModelsByChildren.get(child));
            }
        }
    }
}

