/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.xdm;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.BadLocationException;
import javax.swing.undo.CompoundEdit;
import javax.swing.undo.UndoableEditSupport;
import javax.xml.namespace.QName;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.xml.lexer.XMLTokenId;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.xml.xam.ModelSource;
import org.netbeans.modules.xml.xam.dom.ElementIdentity;
import org.netbeans.modules.xml.xdm.XDMModelUndoableEdit;
import org.netbeans.modules.xml.xdm.diff.Add;
import org.netbeans.modules.xml.xdm.diff.Change;
import org.netbeans.modules.xml.xdm.diff.DefaultElementIdentity;
import org.netbeans.modules.xml.xdm.diff.Delete;
import org.netbeans.modules.xml.xdm.diff.DiffFinder;
import org.netbeans.modules.xml.xdm.diff.Difference;
import org.netbeans.modules.xml.xdm.diff.MergeDiff;
import org.netbeans.modules.xml.xdm.diff.NodeIdDiffFinder;
import org.netbeans.modules.xml.xdm.diff.NodeInfo;
import org.netbeans.modules.xml.xdm.diff.SyncPreparation;
import org.netbeans.modules.xml.xdm.diff.XDMTreeDiff;
import org.netbeans.modules.xml.xdm.nodes.Attribute;
import org.netbeans.modules.xml.xdm.nodes.Document;
import org.netbeans.modules.xml.xdm.nodes.Element;
import org.netbeans.modules.xml.xdm.nodes.Node;
import org.netbeans.modules.xml.xdm.nodes.NodeImpl;
import org.netbeans.modules.xml.xdm.nodes.Text;
import org.netbeans.modules.xml.xdm.nodes.Token;
import org.netbeans.modules.xml.xdm.nodes.XMLSyntaxParser;
import org.netbeans.modules.xml.xdm.visitor.FindVisitor;
import org.netbeans.modules.xml.xdm.visitor.FlushVisitor;
import org.netbeans.modules.xml.xdm.visitor.NamespaceRefactorVisitor;
import org.netbeans.modules.xml.xdm.visitor.PathFromRootVisitor;
import org.netbeans.modules.xml.xdm.visitor.Utils;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;

public class XDMModel {
    private SyncPreparation preparation = null;
    private XMLSyntaxParser parser;
    private Document currentDocument;
    private PropertyChangeSupport pcs;
    private ModelSource source;
    private Status status;
    private boolean pretty = false;
    private UndoableEditSupport ues;
    private boolean fireUndoEvents = true;
    public static final String PROP_MODIFIED = "modified";
    public static final String PROP_DELETED = "deleted";
    public static final String PROP_ADDED = "added";
    public static final String DEFAULT_INDENT = "    ";
    private int nodeCount = 0;
    private ElementIdentity eID;
    private String currentIndent = "";
    private boolean indentInitialized = false;
    private Map<QName, List<QName>> qnameValuedAttributesByElementMap;

    public XDMModel(ModelSource ms) {
        this.source = ms;
        this.ues = new UndoableEditSupport(this);
        this.pcs = new PropertyChangeSupport(this);
        this.parser = new XMLSyntaxParser();
        this.setStatus(Status.UNPARSED);
        ElementIdentity eID = this.createElementIdentity();
        this.setElementIdentity(eID);
    }

    public String getIndentation() {
        return this.currentIndent;
    }

    public void setIndentation(String indent) {
        this.currentIndent = indent;
        this.indentInitialized = true;
    }

    private void setDefaultIndentation() {
        this.currentIndent = DEFAULT_INDENT;
    }

    private ElementIdentity createElementIdentity() {
        DefaultElementIdentity eID = new DefaultElementIdentity();
        eID.addIdentifier("id");
        eID.addIdentifier("name");
        eID.addIdentifier("ref");
        return eID;
    }

    public synchronized void flush() {
        this.flushDocument(this.getDocument());
    }

    public synchronized void sync() throws IOException {
        if (this.preparation == null) {
            this.prepareSync();
        }
        this.finishSync();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void prepareSync() {
        BaseDocument baseDoc = this.getSwingDocument();
        if (baseDoc == null) {
            IOException ioe = new IOException("Base document not accessible");
            this.preparation = new SyncPreparation(ioe);
            return;
        }
        Status oldStat = this.getStatus();
        try {
            this.setStatus(Status.PARSING);
            baseDoc.putProperty(Language.class, (Object)XMLTokenId.language());
            Document newDoc = this.parser.parse(baseDoc);
            Document oldDoc = this.getCurrentDocument();
            if (oldDoc == null) {
                this.preparation = new SyncPreparation(newDoc);
            } else {
                newDoc.assignNodeIdRecursively();
                XDMTreeDiff treeDiff = new XDMTreeDiff(this.eID);
                List<Difference> preparedDiffs = treeDiff.performDiff(this, newDoc);
                this.preparation = new SyncPreparation(oldDoc, preparedDiffs);
            }
        }
        catch (BadLocationException ble) {
            this.preparation = new SyncPreparation(ble);
        }
        catch (IllegalArgumentException iae) {
            this.preparation = new SyncPreparation(iae);
        }
        catch (IOException ioe) {
            this.preparation = new SyncPreparation(ioe);
        }
        finally {
            this.setStatus(oldStat);
        }
    }

    private void finishSync() throws IOException {
        if (this.preparation == null) {
            return;
        }
        if (this.preparation.hasErrors()) {
            IOException error = this.preparation.getError();
            this.preparation = null;
            this.setStatus(Status.BROKEN);
            throw error;
        }
        Status savedStatus = this.getStatus();
        this.setStatus(Status.PARSING);
        Document oldDoc = this.getCurrentDocument();
        try {
            if (this.preparation.getNewDocument() != null) {
                Document newDoc = this.preparation.getNewDocument();
                newDoc.addedToTree(this);
                this.setDocument(newDoc);
            } else {
                assert (this.preparation.getOldDocument() != null) : "Invalid preparation oldDoc is null";
                if (oldDoc != this.preparation.getOldDocument()) {
                    this.setStatus(savedStatus);
                    return;
                }
                List<Difference> diffs = this.preparation.getDifferences();
                if (diffs != null && diffs.size() != 0) {
                    this.mergeDiff(diffs);
                    this.fireDiffEvents(diffs);
                    if (this.getCurrentDocument() != oldDoc) {
                        this.fireUndoableEditEvent(this.getCurrentDocument(), oldDoc);
                    }
                }
            }
            this.setStatus(Status.STABLE);
        }
        catch (IllegalArgumentException iae) {
            if (this.getStatus() != Status.STABLE) {
                IOException ioe = new IOException();
                ioe.initCause(iae);
                throw ioe;
            }
            if (iae.getCause() instanceof IOException) {
                this.setStatus(Status.BROKEN);
                throw (IOException)iae.getCause();
            }
            throw iae;
        }
        finally {
            if (this.getStatus() != Status.STABLE) {
                this.setStatus(Status.BROKEN);
                this.setDocument(oldDoc);
            }
            this.preparation = null;
        }
    }

    public void mergeDiff(List<Difference> diffs) {
        this.setStatus(Status.PARSING);
        new MergeDiff().merge(this, diffs);
        this.setStatus(Status.STABLE);
    }

    private void fireDiffEvents(List<Difference> deList) {
        for (Difference de : deList) {
            NodeInfo.NodeType nodeType = de.getNodeType();
            if (de instanceof Add) {
                NodeInfo newNodeInfo = ((Add)de).getNewNodeInfo();
                assert (newNodeInfo != null);
                this.pcs.firePropertyChange(PROP_ADDED, null, newNodeInfo);
                continue;
            }
            if (de instanceof Delete) {
                NodeInfo OldNodeInfo = ((Delete)de).getOldNodeInfo();
                assert (OldNodeInfo != null);
                this.pcs.firePropertyChange(PROP_DELETED, OldNodeInfo, null);
                continue;
            }
            if (!(de instanceof Change)) continue;
            NodeInfo oldNodeInfo = ((Change)de).getOldNodeInfo();
            assert (oldNodeInfo != null);
            NodeInfo newNodeInfo = ((Change)de).getNewNodeInfo();
            assert (newNodeInfo != null);
            if (((Change)de).isPositionChanged()) {
                this.pcs.firePropertyChange(PROP_DELETED, oldNodeInfo, null);
                this.pcs.firePropertyChange(PROP_ADDED, null, newNodeInfo);
                continue;
            }
            if (de.getNodeType() == NodeInfo.NodeType.TEXT) {
                this.pcs.firePropertyChange(PROP_MODIFIED, oldNodeInfo, newNodeInfo);
                continue;
            }
            if (de.getNodeType() != NodeInfo.NodeType.ELEMENT) continue;
            ArrayList<Node> path1 = new ArrayList<Node>(oldNodeInfo.getOriginalAncestors());
            path1.add(0, oldNodeInfo.getNode());
            ArrayList<Node> path2 = new ArrayList<Node>(newNodeInfo.getNewAncestors());
            path2.add(0, newNodeInfo.getNode());
            List<Change.AttributeDiff> attrChanges = ((Change)de).getAttrChanges();
            for (Change.AttributeDiff attrDiff : attrChanges) {
                Attribute oldAttr = attrDiff.getOldAttribute();
                Attribute newAttr = attrDiff.getNewAttribute();
                if (attrDiff instanceof Change.AttributeAdd) {
                    assert (newAttr != null);
                    this.pcs.firePropertyChange(PROP_ADDED, null, new NodeInfo(newAttr, -1, path1, path2));
                    continue;
                }
                if (attrDiff instanceof Change.AttributeDelete) {
                    assert (oldAttr != null);
                    this.pcs.firePropertyChange(PROP_DELETED, new NodeInfo(oldAttr, -1, path1, path2), null);
                    continue;
                }
                if (!(attrDiff instanceof Change.AttributeChange)) continue;
                assert (oldAttr != null);
                assert (newAttr != null);
                NodeInfo old = new NodeInfo(oldAttr, -1, path1, path2);
                NodeInfo now = new NodeInfo(newAttr, -1, path1, path2);
                this.pcs.firePropertyChange(PROP_MODIFIED, old, now);
            }
        }
    }

    private List<Node> getPathToRoot(Node node, Document root) {
        PathFromRootVisitor pathVisitor = new PathFromRootVisitor();
        List<Node> path = pathVisitor.findPath(root, node);
        if (path == null || path.isEmpty()) {
            throw new IllegalArgumentException("old node must be in the tree");
        }
        return path;
    }

    private static String classifyMutationType(Node oldNode, Node newNode) {
        if (newNode == null && oldNode == null || newNode != null && oldNode != null) {
            return PROP_MODIFIED;
        }
        if (newNode != null) {
            return PROP_ADDED;
        }
        return PROP_DELETED;
    }

    private List<Node> mutate(Node parent, Node oldNode, Node newNode, Updater updater) {
        return this.mutate(parent, oldNode, newNode, updater, null);
    }

    private List<Node> mutate(Node parent, Node oldNode, Node newNode, Updater updater, MutationType type) {
        Node newParent;
        List<Node> ancestors;
        this.checkStableOrParsingState();
        if (newNode != null) {
            this.checkNodeInTree(newNode);
        }
        Document currentDocument = this.getDocument();
        if (parent == null) {
            assert (oldNode != null);
            ancestors = this.getPathToRoot(oldNode, currentDocument);
            oldNode = ancestors.remove(0);
        } else if (oldNode != null) {
            assert (parent.getIndexOfChild(oldNode) > -1);
            ancestors = this.getPathToRoot(oldNode, currentDocument);
            assert (oldNode.getId() == ancestors.get(0).getId());
            oldNode = ancestors.remove(0);
            assert (parent.getId() == ancestors.get(0).getId());
        } else {
            ancestors = this.getPathToRoot(parent, currentDocument);
        }
        Node oldParent = ancestors.remove(0);
        if (type == null) {
            if (oldNode instanceof Attribute || newNode instanceof Attribute || oldNode == null && newNode == null) {
                type = MutationType.ATTRIBUTE;
            } else if (ancestors.size() == 1) {
                assert (oldParent instanceof Element);
                type = MutationType.BOTH;
            } else {
                type = MutationType.CHILDREN;
            }
        }
        switch (type) {
            case ATTRIBUTE: {
                newParent = oldParent.clone(true, true, false);
                break;
            }
            case CHILDREN: {
                newParent = oldParent.clone(true, false, true);
                break;
            }
            default: {
                newParent = oldParent.clone(true, true, true);
            }
        }
        if (oldNode != null && oldNode.getNodeType() != 3 && newNode == null) {
            this.undoPrettyPrint(newParent, oldNode, oldParent);
        }
        updater.update(newParent, oldNode, newNode);
        if (oldNode == null && newNode != null && newNode.getNodeType() != 3) {
            this.doPrettyPrint(newParent, newNode, oldParent);
        }
        List<Node> newAncestors = this.updateAncestors(ancestors, newParent, oldParent);
        if (this.getStatus() != Status.PARSING && newNode instanceof Element) {
            this.consolidateNamespaces(newAncestors, newParent, (Element)newNode);
        }
        Document d = (Document)(!newAncestors.isEmpty() ? newAncestors.get(newAncestors.size() - 1) : newParent);
        d.addedToTree(this);
        this.setDocument(d);
        ancestors.add(0, oldParent);
        newAncestors.add(0, newParent);
        if (this.getStatus() != Status.PARSING) {
            this.fireUndoableEditEvent(d, currentDocument);
            String mutationType = XDMModel.classifyMutationType(oldNode, newNode);
            NodeInfo newNodeInfo = new NodeInfo(newNode, -1, ancestors, newAncestors);
            this.pcs.firePropertyChange(mutationType, null, newNodeInfo);
        }
        return newAncestors;
    }

    private void consolidateNamespaces(List<Node> ancestors, Node parent, Element newNode) {
        if (parent instanceof Document) {
            return;
        }
        assert (ancestors.size() > 0);
        Element root = (Element)(ancestors.size() == 1 ? parent : ancestors.get(ancestors.size() - 2));
        ArrayList<Node> parentAndAncestors = new ArrayList<Node>(ancestors);
        parentAndAncestors.add(0, parent);
        this.consolidateAttributePrefix(parentAndAncestors, newNode);
        NamedNodeMap nnm = newNode.getAttributes();
        for (int i = 0; i < nnm.getLength(); ++i) {
            if (!(nnm.item(i) instanceof Attribute)) continue;
            Attribute attr = (Attribute)nnm.item(i);
            this.consolidateNamespace(root, parentAndAncestors, newNode, attr);
        }
        String parentPrefix = parent.getPrefix();
        String parentNS = NodeImpl.lookupNamespace(parent, ancestors);
        if (parentNS != null && !parentNS.equals("")) {
            new NamespaceRefactorVisitor(this).refactor(newNode, parentNS, parentPrefix, parentAndAncestors);
        }
    }

    private void consolidateAttributePrefix(List<Node> parentAndAncestors, Element newNode) {
        NamedNodeMap nnm = newNode.getAttributes();
        for (int i = 0; i < nnm.getLength(); ++i) {
            String namespace;
            Attribute attr;
            String prefix;
            if (!(nnm.item(i) instanceof Attribute) || (prefix = (attr = (Attribute)nnm.item(i)).getPrefix()) == null || attr.isXmlnsAttribute() || (namespace = newNode.lookupNamespaceURI(prefix)) == null || (prefix = NodeImpl.lookupPrefix(namespace, parentAndAncestors)) == null) continue;
            attr.setPrefix(prefix);
        }
    }

    private void consolidateNamespace(Element root, List<Node> parentAndAncestors, Element newNode, Attribute attr) {
        if (attr.isXmlnsAttribute()) {
            String prefix = attr.getLocalName();
            if ("xmlns".equals(prefix)) {
                prefix = "";
            }
            String namespace = attr.getValue();
            assert (namespace != null);
            Node parent = parentAndAncestors.get(0);
            String parentNS = NodeImpl.lookupNamespace(parent, parentAndAncestors);
            String existingNS = NodeImpl.lookupNamespace(prefix, parentAndAncestors);
            String existingPrefix = NodeImpl.lookupPrefix(namespace, parentAndAncestors);
            if (existingNS == null && existingPrefix == null) {
                newNode.removeAttributeNode(attr);
                root.appendAttribute(attr);
            } else if (namespace.equals(existingNS) && prefix.equals(existingPrefix)) {
                assert (prefix.equals(existingPrefix)) : "prefix='" + prefix + "' existingPrefix='" + existingPrefix + "'";
                newNode.removeAttributeNode(attr);
            } else if (existingPrefix != null && !namespace.equals(parentNS)) {
                new NamespaceRefactorVisitor(this).refactor(newNode, namespace, existingPrefix, parentAndAncestors);
            }
        }
    }

    public synchronized List<Node> modify(Node oldValue, Node newValue) {
        if (oldValue.getId() != newValue.getId()) {
            throw new IllegalArgumentException("newValue must be a clone of oldValue");
        }
        if (oldValue instanceof Document) {
            assert (newValue instanceof Document);
            Document oldDoc = (Document)oldValue;
            Document newDoc = (Document)newValue;
            newDoc.addedToTree(this);
            this.setDocument(newDoc);
            if (this.getStatus() != Status.PARSING) {
                this.fireUndoableEditEvent(oldDoc, this.currentDocument);
                String mutationType = XDMModel.classifyMutationType(oldDoc, newDoc);
                ArrayList<Node> ancestors = new ArrayList<Node>();
                NodeInfo oldNodeInfo = new NodeInfo(oldDoc, -1, ancestors, ancestors);
                NodeInfo newNodeInfo = new NodeInfo(newDoc, -1, ancestors, ancestors);
                this.pcs.firePropertyChange(mutationType, oldNodeInfo, newNodeInfo);
            }
            return new ArrayList<Node>();
        }
        Updater modifier = new Updater(){

            @Override
            public void update(Node newParent, Node oldNode, Node newNode) {
                if (oldNode instanceof Attribute) {
                    ((Element)newParent).replaceAttribute((Attribute)newNode, (Attribute)oldNode);
                } else {
                    newParent.replaceChild(newNode, oldNode);
                }
            }
        };
        return this.mutate(null, oldValue, newValue, modifier);
    }

    public synchronized List<Node> add(Node parent, Node node, final int offset) {
        if (offset < 0) {
            throw new IndexOutOfBoundsException();
        }
        Updater adder = new Updater(){

            @Override
            public void update(Node newParent, Node oldNode, Node newNode) {
                if (newParent instanceof Element && newNode instanceof Attribute) {
                    Element newElement = (Element)newParent;
                    if (offset > newElement.getAttributes().getLength()) {
                        throw new IndexOutOfBoundsException();
                    }
                    newElement.addAttribute((Attribute)newNode, offset);
                } else {
                    if (offset > newParent.getChildNodes().getLength()) {
                        throw new IndexOutOfBoundsException();
                    }
                    if (offset < newParent.getChildNodes().getLength()) {
                        Node refChild = (Node)newParent.getChildNodes().item(offset);
                        newParent.insertBefore(newNode, refChild);
                    } else {
                        newParent.appendChild(newNode);
                    }
                }
            }
        };
        return this.mutate(parent, null, node, adder);
    }

    public synchronized List<Node> insertBefore(Node parent, Node node, Node refChild) {
        final Node ref = refChild;
        Updater updater = new Updater(){

            @Override
            public void update(Node newParent, Node oldNode, Node newNode) {
                newParent.insertBefore(newNode, ref);
            }
        };
        return this.mutate(parent, null, node, updater);
    }

    public synchronized List<Node> append(Node parent, Node node) {
        Updater appender = new Updater(){

            @Override
            public void update(Node parent, Node oldNode, Node newNode) {
                parent.appendChild(newNode);
            }
        };
        return this.mutate(parent, null, node, appender);
    }

    public synchronized List<Node> delete(Node n) {
        Updater remover = new Updater(){

            @Override
            public void update(Node newParent, Node oldNode, Node newNode) {
                newParent.removeChild(oldNode);
            }
        };
        return this.mutate(null, n, null, remover);
    }

    public synchronized List<Node> reorder(Node parent, Node n, final int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException("index=" + index);
        }
        Updater u = new Updater(){

            @Override
            public void update(Node newParent, Node oldNode, Node newNode) {
                if (newParent instanceof Element && newNode instanceof Attribute) {
                    Element parent = (Element)newParent;
                    int i = index;
                    if (index > parent.getAttributes().getLength()) {
                        i = parent.getAttributes().getLength();
                    }
                    parent.reorderAttribute((Attribute)oldNode, i);
                } else {
                    int i = index;
                    if (index > newParent.getChildNodes().getLength()) {
                        i = newParent.getChildNodes().getLength();
                    }
                    ((NodeImpl)newParent).reorderChild(oldNode, i);
                }
            }
        };
        return this.mutate(parent, n, null, u);
    }

    public synchronized List<Node> reorderChildren(Node parent, final int[] permutation) {
        Updater u = new Updater(){

            @Override
            public void update(Node newParent, Node oldNode, Node newNode) {
                ((NodeImpl)newParent).reorderChildren(permutation);
            }
        };
        return this.mutate(parent, null, null, u, MutationType.CHILDREN);
    }

    public synchronized List<Node> remove(final Node parent, Node child) {
        Updater remover = new Updater(){

            @Override
            public void update(Node newParent, Node oldNode, Node newNode) {
                assert (parent.isEquivalentNode(newParent));
                newParent.removeChild(oldNode);
            }
        };
        return this.mutate(parent, child, null, remover);
    }

    public synchronized List<Node> removeChildNodes(final Node parent, final Collection<Node> toRemove) {
        Updater remover = new Updater(){

            @Override
            public void update(Node newParent, Node oldNode, Node newNode) {
                assert (parent.isEquivalentNode(newParent));
                for (Node n : toRemove) {
                    newParent.removeChild(n);
                }
            }
        };
        return this.mutate(parent, null, null, remover, MutationType.CHILDREN);
    }

    public synchronized List<Node> replaceChild(final Node parent, Node child, Node newChild) {
        Updater updater = new Updater(){

            @Override
            public void update(Node newParent, Node oldNode, Node newNode) {
                assert (newParent.isEquivalentNode(parent));
                newParent.replaceChild(newNode, oldNode);
            }
        };
        return this.mutate(null, child, newChild, updater);
    }

    public synchronized List<Node> setAttribute(Element element, final String name, final String value) {
        Updater updater = new Updater(){

            @Override
            public void update(Node newParent, Node oldNode, Node newNode) {
                ((Element)newParent).setAttribute(name, value);
            }
        };
        return this.mutate(element, null, null, updater);
    }

    public synchronized List<Node> removeAttribute(Element element, final String name) {
        Updater updater = new Updater(){

            @Override
            public void update(Node newParent, Node oldNode, Node newNode) {
                ((Element)newParent).removeAttribute(name);
            }
        };
        return this.mutate(element, null, null, updater);
    }

    public synchronized List<Node> setXmlFragmentText(Element node, final String value) throws IOException {
        CheckIOExceptionUpdater updater = new CheckIOExceptionUpdater(){
            private IOException error;

            @Override
            public void update(Node newParent, Node oldNode, Node newNode) {
                try {
                    ((Element)newParent).setXmlFragmentText(value);
                }
                catch (IOException ioe) {
                    this.error = ioe;
                }
            }

            @Override
            public IOException getError() {
                return this.error;
            }
        };
        List<Node> retPath = this.mutate(node, null, null, updater, MutationType.CHILDREN);
        if (updater.getError() != null) {
            throw updater.getError();
        }
        return retPath;
    }

    public synchronized List<Node> setTextValue(Node node, String value) {
        Node text = (Node)((Object)this.currentDocument.createTextNode(value));
        Updater updater = new Updater(){

            @Override
            public void update(Node newParent, Node oldNode, Node newNode) {
                while (newParent.hasChildNodes()) {
                    newParent.removeChild(newParent.getLastChild());
                }
                newParent.appendChild(newNode);
            }
        };
        return this.mutate(node, null, text, updater);
    }

    private List<Node> updateAncestors(List<Node> ancestors, Node modifiedNode, Node originalNode) {
        assert (ancestors != null && modifiedNode != null && originalNode != null);
        ArrayList<Node> newAncestors = new ArrayList<Node>(ancestors.size());
        Node currentModifiedNode = modifiedNode;
        Node currentOrigNode = originalNode;
        for (Node parentNode : ancestors) {
            Node newParentNode = parentNode.clone(false, true, true);
            newParentNode.replaceChild(currentModifiedNode, currentOrigNode);
            newAncestors.add(newParentNode);
            currentOrigNode = parentNode;
            currentModifiedNode = newParentNode;
        }
        return newAncestors;
    }

    public synchronized Document getDocument() {
        this.checkStableOrParsingState();
        return this.currentDocument;
    }

    public synchronized Document getCurrentDocument() {
        return this.currentDocument;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void resetDocument(Document newDoc) {
        try {
            this.fireUndoEvents = false;
            List<Difference> diffs = new NodeIdDiffFinder().findDiff(this.getCurrentDocument(), newDoc);
            List<Difference> filtered = DiffFinder.filterWhitespace(diffs);
            this.setDocument(newDoc);
            this.setStatus(Status.STABLE);
            if (filtered != null && !filtered.isEmpty()) {
                this.fireDiffEvents(filtered);
            }
        }
        finally {
            this.fireUndoEvents = true;
        }
    }

    private void flushDocument(Document newDoc) {
        CompoundEdit ce;
        block8: {
            this.checkStableState();
            UndoableEditListener uel = null;
            BaseDocument d = this.getSwingDocument();
            if (d == null) {
                return;
            }
            ce = new CompoundEdit();
            try {
                FlushVisitor flushvisitor = new FlushVisitor();
                String newXMLText = flushvisitor.flushModel(newDoc);
                uel = new UndoableEditListener(){

                    @Override
                    public void undoableEditHappened(UndoableEditEvent e) {
                        ce.addEdit(e.getEdit());
                    }
                };
                d.addUndoableEditListener(uel);
                Utils.replaceDocument((javax.swing.text.Document)d, newXMLText);
                if (uel == null) break block8;
            }
            catch (BadLocationException ble) {
                try {
                    throw new IllegalStateException("It is possible that model source file is locked", ble);
                }
                catch (Throwable throwable) {
                    if (uel != null) {
                        d.removeUndoableEditListener(uel);
                    }
                    ce.end();
                    for (UndoableEditListener l : this.ues.getUndoableEditListeners()) {
                        l.undoableEditHappened(new UndoableEditEvent(this, ce));
                    }
                    throw throwable;
                }
            }
            d.removeUndoableEditListener(uel);
        }
        ce.end();
        for (UndoableEditListener l : this.ues.getUndoableEditListeners()) {
            l.undoableEditHappened(new UndoableEditEvent(this, ce));
        }
    }

    public synchronized String getCurrentDocumentText() {
        return new FlushVisitor().flushModel(this.getCurrentDocument());
    }

    private BaseDocument getSwingDocument() {
        BaseDocument bd = (BaseDocument)this.source.getLookup().lookup(BaseDocument.class);
        return bd;
    }

    public synchronized void setDocument(Document newDoc) {
        this.currentDocument = newDoc;
    }

    public synchronized Status getStatus() {
        return this.status;
    }

    public synchronized void addUndoableEditListener(UndoableEditListener l) {
        this.ues.addUndoableEditListener(l);
    }

    public synchronized void removeUndoableEditListener(UndoableEditListener l) {
        this.ues.addUndoableEditListener(l);
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener pcl) {
        this.pcs.addPropertyChangeListener(pcl);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener pcl) {
        this.pcs.removePropertyChangeListener(pcl);
    }

    private synchronized Node findNode(int id) {
        FindVisitor fv = new FindVisitor();
        return fv.find(this.getDocument(), id);
    }

    private void fireUndoableEditEvent(Document newDoc, Document oldDoc) {
        if (this.fireUndoEvents) {
            assert (newDoc != oldDoc);
            XDMModelUndoableEdit ee = new XDMModelUndoableEdit(oldDoc, newDoc, this);
            UndoableEditEvent ue = new UndoableEditEvent(this, ee);
            for (UndoableEditListener l : this.ues.getUndoableEditListeners()) {
                l.undoableEditHappened(ue);
            }
        }
    }

    private void checkNodeInTree(Node n) {
        if (n.isInTree()) {
            throw new IllegalArgumentException("newValue must not have been added to model");
        }
    }

    private void checkStableState() {
        if (this.getStatus() != Status.STABLE) {
            throw new IllegalStateException("flush can only be called from STABLE STATE");
        }
    }

    private void checkStableOrParsingState() {
        if (this.getStatus() != Status.STABLE && this.getStatus() != Status.PARSING) {
            throw new IllegalStateException("The model is not initialized or is broken.");
        }
    }

    private void setStatus(Status s) {
        this.status = s;
    }

    public int getNextNodeId() {
        int nodeId = this.nodeCount++;
        return nodeId;
    }

    private boolean isPretty() {
        return this.pretty;
    }

    public void setPretty(boolean print) {
        this.pretty = print;
    }

    private void doPrettyPrint(Node newParent, Node newNode, Node oldParent) {
        if (this.getStatus() != Status.PARSING && this.isPretty()) {
            if (this.isSimpleContent(newParent)) {
                return;
            }
            if (!this.indentInitialized) {
                this.initializeIndent(oldParent);
            }
            String parentIndent = this.calculateNodeIndent(oldParent);
            if (!this.isPretty(newParent, newNode)) {
                int index;
                int offset = 1;
                if (oldParent.getChildNodes().getLength() == 0) {
                    newParent.insertBefore(this.createPrettyText(parentIndent + this.getIndentation()), newNode);
                    ++offset;
                }
                if ((index = ((NodeImpl)newParent).getIndexOfChild(newNode)) > 0) {
                    Node oldText = (Node)newParent.getChildNodes().item(index - 1);
                    if (this.checkPrettyText(oldText)) {
                        Text newText = this.createPrettyText(parentIndent + this.getIndentation());
                        newParent.replaceChild(newText, oldText);
                    } else {
                        newParent.insertBefore(this.createPrettyText(parentIndent + this.getIndentation()), newNode);
                        ++offset;
                    }
                }
                Node ref = null;
                if (index + offset < newParent.getChildNodes().getLength()) {
                    ref = (Node)newParent.getChildNodes().item(index + offset);
                }
                if (ref != null) {
                    if (!this.checkPrettyText(ref)) {
                        newParent.insertBefore(this.createPrettyText(parentIndent + this.getIndentation()), ref);
                    }
                } else {
                    newParent.appendChild(this.createPrettyText(parentIndent));
                }
            }
            this.doPrettyPrintRecursive(newNode, parentIndent, newParent);
        }
    }

    private void initializeIndent(Node n) {
        String parentIndent = this.calculateNodeIndent(n);
        List<Node> pathToRoot = new PathFromRootVisitor().findPath(this.getDocument(), n);
        if (parentIndent.length() > 0 && pathToRoot.size() - 2 > 0) {
            double step = Math.floor((double)parentIndent.length() / (double)(pathToRoot.size() - 2));
            StringBuffer sb = new StringBuffer();
            int i = 0;
            while ((double)i < step) {
                sb.append(" ");
                ++i;
            }
            String indentString = sb.toString();
            if (indentString.length() > 0) {
                this.setIndentation(indentString);
            } else {
                this.setDefaultIndentation();
            }
        } else {
            this.setDefaultIndentation();
        }
    }

    private String calculateNodeIndent(Node n) {
        String wsValue;
        int ndx;
        Node txt;
        int index;
        String indent = "";
        Node parent = (Node)n.getParentNode();
        if (parent != null && (index = parent.getIndexOfChild(n)) > 0 && this.checkPrettyText(txt = (Node)parent.getChildNodes().item(index - 1)) && (ndx = (wsValue = ((NodeImpl)txt).getTokens().get(0).getValue()).lastIndexOf("\n")) != -1 && ndx + 1 < wsValue.length()) {
            indent = wsValue.substring(ndx + 1);
        }
        return indent;
    }

    private void doPrettyPrintRecursive(Node n, String indent, Node parent) {
        if (this.getStatus() != Status.PARSING && this.isPretty()) {
            if (this.isSimpleContent(n)) {
                return;
            }
            if (n instanceof Element && this.isPretty(n)) {
                this.fixPrettyForCopiedNode(n, indent, parent);
            } else {
                int i;
                ArrayList<Node> childList = new ArrayList<Node>();
                ArrayList<Node> visitList = new ArrayList<Node>();
                NodeList childs = n.getChildNodes();
                for (int i2 = 0; i2 < childs.getLength(); ++i2) {
                    childList.add((Node)childs.item(i2));
                    if (!(childs.item(i2) instanceof Element)) continue;
                    visitList.add((Node)childs.item(i2));
                }
                String parentIndent = indent + this.getIndentation();
                if (childList.size() > 0) {
                    n.appendChild(this.createPrettyText(parentIndent));
                }
                String childIndent = parentIndent + this.getIndentation();
                for (i = childList.size() - 1; i >= 0; --i) {
                    Node ref = (Node)childList.get(i);
                    Text postText = this.createPrettyText(childIndent);
                    n.insertBefore(postText, ref);
                }
                childList.clear();
                for (i = 0; i < visitList.size(); ++i) {
                    this.doPrettyPrintRecursive((Node)visitList.get(i), parentIndent, n);
                }
                visitList.clear();
            }
        }
    }

    private void fixPrettyForCopiedNode(Node n, String indent, Node parent) {
        int i;
        NodeList childs = n.getChildNodes();
        if (childs.getLength() == 0) {
            return;
        }
        Text nlastChild = (Text)childs.item(childs.getLength() - 1);
        String lc = nlastChild.getTokens().get(0).getValue();
        NodeImpl pfirstChild = (NodeImpl)parent.getChildNodes().item(0);
        String fc = pfirstChild.getTokens().get(0).getValue();
        if (fc.length() == lc.length()) {
            return;
        }
        String parentIndent = indent + this.getIndentation();
        String childIndent = parentIndent + this.getIndentation();
        ArrayList<Node> childList = new ArrayList<Node>();
        for (i = 0; i < childs.getLength(); ++i) {
            childList.add((Node)childs.item(i));
        }
        for (i = 0; i < childList.size(); ++i) {
            Node txt = (Node)n.getChildNodes().item(i);
            if (!this.checkPrettyText(txt)) continue;
            String newIndent = childIndent + this.getIndentation();
            if (i == 0) {
                newIndent = childIndent;
            } else if (i == childList.size() - 1) {
                newIndent = parentIndent;
            }
            n.replaceChild(this.createPrettyText(newIndent), txt);
        }
        for (i = 0; i < childList.size(); ++i) {
            this.fixPrettyForCopiedNode((Node)n.getChildNodes().item(i), childIndent, n);
        }
        childList.clear();
    }

    private Text createPrettyText(String indent) {
        String textChars = "\n" + indent;
        Text txt = (Text)this.getDocument().createTextNode(textChars);
        return txt;
    }

    private void undoPrettyPrint(Node newParent, Node oldNode, Node oldParent) {
        if (this.getStatus() != Status.PARSING && this.isPretty()) {
            Node txtAfter;
            String parentIndent = this.calculateNodeIndent(oldParent);
            int piLength = parentIndent != null ? parentIndent.length() : 0;
            int index = ((NodeImpl)oldParent).getIndexOfChild(oldNode);
            Node txtBefore = null;
            if (index > 0 && this.checkPrettyText(txtBefore = (Node)oldParent.getChildNodes().item(index - 1)) && piLength <= this.getLength((Text)txtBefore)) {
                newParent.removeChild(txtBefore);
            }
            if (newParent.getChildNodes().getLength() == 2 && index + 1 < oldParent.getChildNodes().getLength() && this.checkPrettyText(txtAfter = (Node)oldParent.getChildNodes().item(index + 1)) && piLength <= this.getLength((Text)txtAfter)) {
                newParent.removeChild(txtAfter);
            }
        }
    }

    private int getLength(Text n) {
        int len = 0;
        for (Token token : n.getTokens()) {
            len += token.getValue().length();
        }
        return len;
    }

    private boolean checkPrettyText(Node txt) {
        return txt instanceof Text && ((NodeImpl)txt).getTokens().size() == 1 && this.isWhitespaceOnly(((NodeImpl)txt).getTokens().get(0).getValue());
    }

    private boolean isPossibleWhiteSpace(String text) {
        return text.length() > 0 && Character.isWhitespace(text.charAt(0)) && Character.isWhitespace(text.charAt(text.length() - 1));
    }

    private boolean isWhitespaceOnly(String tn) {
        return this.isPossibleWhiteSpace(tn) && tn.trim().length() == 0;
    }

    public ElementIdentity getElementIdentity() {
        return this.eID;
    }

    public void setElementIdentity(ElementIdentity eID) {
        this.eID = eID;
    }

    private boolean isSimpleContent(Node newParent) {
        NodeList childs = newParent.getChildNodes();
        for (int i = 0; i < childs.getLength(); ++i) {
            if (childs.item(i) instanceof Text) continue;
            return false;
        }
        return true;
    }

    private boolean isPretty(Node newParent) {
        return this.isPretty(newParent, null);
    }

    private boolean isPretty(Node newParent, Node newNode) {
        boolean parentPretty = false;
        NodeList childs = newParent.getChildNodes();
        int len = childs.getLength();
        if (len == 0) {
            parentPretty = true;
        } else if (len == 1 && childs.item(0) instanceof Text) {
            parentPretty = true;
        } else if (len > 2 && this.checkPrettyText((Node)childs.item(0)) && this.checkPrettyText((Node)childs.item(len - 1))) {
            parentPretty = true;
        }
        if (!parentPretty) {
            return false;
        }
        if (newNode != null) {
            Node preText = null;
            Node postText = null;
            int index = ((NodeImpl)newParent).getIndexOfChild(newNode);
            if (index > 0) {
                preText = (Node)newParent.getChildNodes().item(index - 1);
            }
            if (index + 1 < newParent.getChildNodes().getLength()) {
                postText = (Node)newParent.getChildNodes().item(index + 1);
            }
            return this.checkPrettyText(preText) && this.checkPrettyText(postText);
        }
        return parentPretty;
    }

    public void setQNameValuedAttributes(Map<QName, List<QName>> attrsByElement) {
        this.qnameValuedAttributesByElementMap = attrsByElement;
    }

    public Map<QName, List<QName>> getQNameValuedAttributes() {
        return this.qnameValuedAttributesByElementMap;
    }

    public static enum Status {
        BROKEN,
        STABLE,
        UNPARSED,
        PARSING;

    }

    private static interface CheckIOExceptionUpdater
    extends Updater {
        public IOException getError();
    }

    private static enum MutationType {
        CHILDREN,
        ATTRIBUTE,
        BOTH;

    }

    private static interface Updater {
        public void update(Node var1, Node var2, Node var3);
    }
}

