/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.remote.ui.clone;

import java.net.URISyntaxException;
import java.util.List;
import java.util.MissingResourceException;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import javax.swing.SwingUtilities;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.mercurial.remote.HgException;
import org.netbeans.modules.mercurial.remote.HgProgressSupport;
import org.netbeans.modules.mercurial.remote.Mercurial;
import org.netbeans.modules.mercurial.remote.OutputLogger;
import org.netbeans.modules.mercurial.remote.config.HgConfigFiles;
import org.netbeans.modules.mercurial.remote.ui.actions.ContextAction;
import org.netbeans.modules.mercurial.remote.ui.clone.Clone;
import org.netbeans.modules.mercurial.remote.ui.clone.CloneCompleted;
import org.netbeans.modules.mercurial.remote.ui.repository.HgURL;
import org.netbeans.modules.mercurial.remote.util.HgCommand;
import org.netbeans.modules.mercurial.remote.util.HgProjectUtils;
import org.netbeans.modules.mercurial.remote.util.HgUtils;
import org.netbeans.modules.mercurial.remote.versioning.util.Utils;
import org.netbeans.modules.remotefs.versioning.api.VCSFileProxySupport;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.netbeans.modules.versioning.core.spi.VCSContext;
import org.openide.filesystems.FileObject;
import org.openide.nodes.Node;
import org.openide.util.Cancellable;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class CloneAction
extends ContextAction {
    @Override
    protected boolean enable(Node[] nodes) {
        VCSContext context = HgUtils.getCurrentContext(nodes);
        return HgUtils.isFromHgRepository(context);
    }

    @Override
    protected String getBaseName(Node[] nodes) {
        VCSContext ctx = HgUtils.getCurrentContext(nodes);
        Set<VCSFileProxy> roots = HgUtils.getRepositoryRoots(ctx);
        return roots.size() == 1 ? "CTL_MenuItem_CloneLocal" : "CTL_MenuItem_CloneRepository";
    }

    @Override
    public String getName(String role, Node[] activatedNodes) {
        VCSContext ctx = HgUtils.getCurrentContext(activatedNodes);
        Set<VCSFileProxy> roots = HgUtils.getRepositoryRoots(ctx);
        String name = this.getBaseName(activatedNodes);
        return roots.size() == 1 ? NbBundle.getMessage(CloneAction.class, (String)name, (Object)roots.iterator().next().getName()) : NbBundle.getMessage(CloneAction.class, (String)name);
    }

    @Override
    protected void performContextAction(Node[] nodes) {
        final VCSContext context = HgUtils.getCurrentContext(nodes);
        final VCSFileProxy[] roots = HgUtils.getActionRoots(context);
        if (roots == null || roots.length == 0) {
            return;
        }
        HgUtils.runIfHgAvailable(roots[0], new Runnable(){

            @Override
            public void run() {
                Clone clone;
                org.netbeans.modules.versioning.util.Utils.logVCSActionEvent((String)"HG");
                VCSFileProxy root = Mercurial.getInstance().getRepositoryRoot(roots[0]);
                VCSFileProxy tmp = root.getParentFile();
                VCSFileProxy projFile = Utils.getProjectFile(context);
                String folderName = root.getName();
                Boolean projIsRepos = true;
                if (!root.equals((Object)projFile)) {
                    projIsRepos = false;
                }
                for (int i = 0; i < 10000; ++i) {
                    if (VCSFileProxy.createFileProxy((VCSFileProxy)tmp, (String)(folderName + "_clone" + i)).exists()) continue;
                    tmp = VCSFileProxy.createFileProxy((VCSFileProxy)tmp, (String)(folderName + "_clone" + i));
                    break;
                }
                if (!(clone = new Clone(root, tmp)).showDialog()) {
                    return;
                }
                CloneAction.performClone(new HgURL(root), clone.getTargetDir(), projIsRepos, projFile, true, null, null, true);
            }
        });
    }

    public static RequestProcessor.Task performClone(HgURL source, VCSFileProxy target, boolean projIsRepos, VCSFileProxy projFile, HgURL pullPath, HgURL pushPath, boolean scanForProjects) {
        return CloneAction.performClone(source, target, projIsRepos, projFile, false, pullPath, pushPath, scanForProjects);
    }

    private static RequestProcessor.Task performClone(final HgURL source, final VCSFileProxy target, final boolean projIsRepos, final VCSFileProxy projFile, final boolean isLocalClone, final HgURL pullPath, final HgURL pushPath, final boolean scanForProjects) {
        RequestProcessor rp = Mercurial.getInstance().getRequestProcessor(source);
        HgProgressSupport support = new HgProgressSupport(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void perform() {
                String projName = projFile != null ? HgProjectUtils.getProjectName(projFile) : null;
                OutputLogger logger = this.getLogger();
                try {
                    HgConfigFiles hgConfigFiles;
                    logger.outputInRed(NbBundle.getMessage(CloneAction.class, (String)"MSG_CLONE_TITLE"));
                    logger.outputInRed(NbBundle.getMessage(CloneAction.class, (String)"MSG_CLONE_TITLE_SEP"));
                    List<String> list = HgUtils.runWithoutIndexing(new Callable<List<String>>(){

                        @Override
                        public List<String> call() throws Exception {
                            return HgCommand.doClone(source, target, this.getLogger());
                        }
                    }, target);
                    if (!VCSFileProxySupport.canRead((VCSFileProxy)VCSFileProxy.createFileProxy((VCSFileProxy)HgUtils.getHgFolderForRoot(target), (String)"hgrc")) || list.contains("transaction abort!")) {
                        logger.output(list);
                        Mercurial.LOG.log(Level.WARNING, "Hg clone seems to fail: {0}", list);
                        return;
                    }
                    if (list != null && !list.isEmpty()) {
                        HgUtils.createIgnored(target);
                        logger.output(list);
                        if (projName != null) {
                            logger.outputInRed(NbBundle.getMessage(CloneAction.class, (String)"MSG_CLONE_FROM", (Object)projName, (Object)source));
                            logger.outputInRed(NbBundle.getMessage(CloneAction.class, (String)"MSG_CLONE_TO", (Object)projName, (Object)target));
                        } else {
                            logger.outputInRed(NbBundle.getMessage(CloneAction.class, (String)"MSG_EXTERNAL_CLONE_FROM", (Object)source));
                            logger.outputInRed(NbBundle.getMessage(CloneAction.class, (String)"MSG_EXTERNAL_CLONE_TO", (Object)target));
                        }
                        logger.output("");
                        if (isLocalClone) {
                            VCSFileProxy cloneProjFile;
                            Mercurial hg = Mercurial.getInstance();
                            ProjectManager projectManager = ProjectManager.getDefault();
                            VCSFileProxy normalizedCloneFolder = target.normalizeFile();
                            if (!projIsRepos) {
                                String name = projFile != null ? projFile.getPath().substring(source.getPath().length() + 1) : target.getPath();
                                cloneProjFile = VCSFileProxy.createFileProxy((VCSFileProxy)normalizedCloneFolder, (String)name);
                            } else {
                                cloneProjFile = normalizedCloneFolder;
                            }
                            this.openProject(cloneProjFile, projectManager, hg);
                        } else if (scanForProjects) {
                            CloneCompleted cc = new CloneCompleted(target);
                            if (!this.isCanceled()) {
                                cc.scanForProjects(this);
                            }
                        }
                    }
                    if ((hgConfigFiles = new HgConfigFiles(target)).getException() == null) {
                        org.netbeans.modules.versioning.util.Utils.logVCSExternalRepository((String)"HG", (String)source.toHgCommandUrlStringWithoutUserInfo());
                        this.initializeDefaultPullPushUrl(hgConfigFiles);
                    } else {
                        Mercurial.LOG.log(Level.WARNING, "{0}: Cannot set default push and pull path", this.getClass().getName());
                        Mercurial.LOG.log(Level.INFO, null, hgConfigFiles.getException());
                    }
                }
                catch (HgException.HgCommandCanceledException ex) {
                }
                catch (HgException ex) {
                    HgUtils.notifyException(ex);
                }
                finally {
                    if (!isLocalClone) {
                        logger.outputInRed(NbBundle.getMessage(CloneAction.class, (String)"MSG_CLONE_DONE"));
                        logger.output("");
                    }
                    source.clearPassword();
                    if (pullPath != null) {
                        pullPath.clearPassword();
                    }
                    if (pushPath != null) {
                        pushPath.clearPassword();
                    }
                }
            }

            private void initializeDefaultPullPushUrl(HgConfigFiles hgConfigFiles) {
                String defaultPull = hgConfigFiles.getDefaultPull(false);
                if (defaultPull == null) {
                    return;
                }
                try {
                    HgURL defaultPullURL = new HgURL(defaultPull);
                    if (pullPath == null && pushPath == null) {
                        hgConfigFiles.setProperty("default-push", defaultPull);
                    } else if (pullPath != null && pushPath == null) {
                        defaultPull = new HgURL(pullPath.toHgCommandUrlStringWithoutUserInfo(), defaultPullURL.getUserInfo(), null).toHgCommandUrlString();
                        hgConfigFiles.setProperty("default-pull", defaultPull);
                        hgConfigFiles.setProperty("default-push", defaultPull);
                    } else if (pullPath == null && pushPath != null) {
                        String defaultPush = new HgURL(pushPath.toHgCommandUrlStringWithoutUserInfo(), defaultPullURL.getUserInfo(), null).toHgCommandUrlString();
                        hgConfigFiles.setProperty("default-push", defaultPush);
                    } else if (pullPath != null && pushPath != null) {
                        defaultPull = new HgURL(pullPath.toHgCommandUrlStringWithoutUserInfo(), defaultPullURL.getUserInfo(), null).toHgCommandUrlString();
                        String defaultPush = new HgURL(pushPath.toHgCommandUrlStringWithoutUserInfo(), defaultPullURL.getUserInfo(), null).toHgCommandUrlString();
                        hgConfigFiles.setProperty("default-pull", defaultPull);
                        hgConfigFiles.setProperty("default-push", defaultPush);
                    }
                }
                catch (URISyntaxException ex) {
                    Mercurial.LOG.log(Level.INFO, null, ex);
                }
            }

            private void openProject(final VCSFileProxy clonePrjFile, final ProjectManager projectManager, final Mercurial hg) throws MissingResourceException {
                SwingUtilities.invokeLater(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        OutputLogger logger = this.getLogger();
                        try {
                            FileObject cloneProj = clonePrjFile.toFileObject();
                            Project prj = null;
                            if (clonePrjFile != null && cloneProj != null) {
                                prj = projectManager.findProject(cloneProj);
                            }
                            if (prj != null) {
                                HgProjectUtils.openProject(prj, this);
                                hg.versionedFilesChanged();
                                hg.refreshAllAnnotations();
                            } else {
                                logger.outputInRed(NbBundle.getMessage(CloneAction.class, (String)"MSG_EXTERNAL_CLONE_PRJ_NOT_FOUND_CANT_SETASMAIN"));
                            }
                        }
                        catch (Exception ex) {
                            HgUtils.notifyException(ex);
                        }
                        finally {
                            logger.outputInRed(NbBundle.getMessage(CloneAction.class, (String)"MSG_CLONE_DONE"));
                            logger.output("");
                        }
                    }
                });
            }
        };
        support.setRepositoryRoot(source);
        support.setCancellableDelegate(new Cancellable(){

            public boolean cancel() {
                return true;
            }
        });
        return support.start(rp, source, NbBundle.getMessage(CloneAction.class, (String)"LBL_Clone_Progress", (Object)source));
    }
}

