/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.remote.ui.diff;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSplitPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.netbeans.api.diff.DiffController;
import org.netbeans.api.diff.StreamSource;
import org.netbeans.modules.mercurial.remote.FileInformation;
import org.netbeans.modules.mercurial.remote.FileStatusCache;
import org.netbeans.modules.mercurial.remote.HgException;
import org.netbeans.modules.mercurial.remote.HgFileNode;
import org.netbeans.modules.mercurial.remote.HgModuleConfig;
import org.netbeans.modules.mercurial.remote.HgProgressSupport;
import org.netbeans.modules.mercurial.remote.Mercurial;
import org.netbeans.modules.mercurial.remote.MercurialAnnotator;
import org.netbeans.modules.mercurial.remote.OutputLogger;
import org.netbeans.modules.mercurial.remote.ui.add.AddAction;
import org.netbeans.modules.mercurial.remote.ui.annotate.AnnotateAction;
import org.netbeans.modules.mercurial.remote.ui.commit.CommitAction;
import org.netbeans.modules.mercurial.remote.ui.commit.ExcludeFromCommitAction;
import org.netbeans.modules.mercurial.remote.ui.diff.Bundle;
import org.netbeans.modules.mercurial.remote.ui.diff.DiffFileTable;
import org.netbeans.modules.mercurial.remote.ui.diff.DiffFileTreeImpl;
import org.netbeans.modules.mercurial.remote.ui.diff.DiffNode;
import org.netbeans.modules.mercurial.remote.ui.diff.DiffSetupSource;
import org.netbeans.modules.mercurial.remote.ui.diff.ExportDiffChangesAction;
import org.netbeans.modules.mercurial.remote.ui.diff.Setup;
import org.netbeans.modules.mercurial.remote.ui.log.HgLogMessage;
import org.netbeans.modules.mercurial.remote.ui.repository.HeadRevisionPicker;
import org.netbeans.modules.mercurial.remote.ui.status.OpenInEditorAction;
import org.netbeans.modules.mercurial.remote.ui.status.StatusAction;
import org.netbeans.modules.mercurial.remote.ui.update.RevertModificationsAction;
import org.netbeans.modules.mercurial.remote.util.HgCommand;
import org.netbeans.modules.mercurial.remote.util.HgUtils;
import org.netbeans.modules.remotefs.versioning.api.VCSFileProxySupport;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.netbeans.modules.versioning.core.spi.VCSContext;
import org.netbeans.modules.versioning.diff.AbstractDiffSetup;
import org.netbeans.modules.versioning.diff.DiffUtils;
import org.netbeans.modules.versioning.diff.EditorSaveCookie;
import org.netbeans.modules.versioning.diff.SaveBeforeClosingDiffConfirmation;
import org.netbeans.modules.versioning.diff.SaveBeforeCommitConfirmation;
import org.netbeans.modules.versioning.util.CollectionUtils;
import org.netbeans.modules.versioning.util.DelegatingUndoRedo;
import org.netbeans.modules.versioning.util.NoContentPanel;
import org.netbeans.modules.versioning.util.PlaceholderPanel;
import org.netbeans.modules.versioning.util.SystemActionBridge;
import org.netbeans.modules.versioning.util.common.FileViewComponent;
import org.openide.LifecycleManager;
import org.openide.awt.Mnemonics;
import org.openide.awt.UndoRedo;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileObject;
import org.openide.nodes.Node;
import org.openide.util.Cancellable;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.SystemAction;
import org.openide.windows.TopComponent;

public class MultiDiffPanel
extends JPanel
implements ActionListener,
DiffSetupSource,
PropertyChangeListener,
PreferenceChangeListener {
    private Setup[] setups;
    private EditorCookie[] editorCookies;
    private final DelegatingUndoRedo delegatingUndoRedo = new DelegatingUndoRedo();
    private final VCSContext context;
    private int displayStatuses;
    private final String contextName;
    private int currentType;
    private Setup currentSetup;
    private RequestProcessor.Task prepareTask;
    private DiffPrepareTask dpt;
    private AbstractAction nextAction;
    private AbstractAction prevAction;
    private RequestProcessor.Task refreshTask;
    private JComponent diffView;
    private FileViewComponent<DiffNode> activeComponent;
    private FileViewComponent<DiffNode> fileListComponent;
    private FileViewComponent<DiffNode> fileTreeComponent;
    private boolean dividerSet;
    private final PlaceholderPanel diffViewPanel;
    private JComponent infoPanelLoadingFromRepo;
    private HgProgressSupport executeStatusSupport;
    private final HgLogMessage.HgRevision revisionOriginalLeft;
    private final HgLogMessage.HgRevision revisionOriginalRight;
    private HgLogMessage.HgRevision revisionLeft;
    private HgLogMessage.HgRevision revisionRight;
    private final boolean fixedRevisions;
    private static final String REVISION_SELECT = Bundle.MSG_Revision_Select();
    private static final String REVISION_SELECT_SEP = Bundle.MSG_Revision_Select_Separator();
    private boolean displayUnversionedFiles = true;
    private RequestProcessor.Task refreshComboTask;
    private static final Logger LOG = Logger.getLogger(MultiDiffPanel.class.getName());
    private static final int VIEW_MODE_TABLE = 1;
    private static final int VIEW_MODE_TREE = 2;
    private int currentSetupDiffLengthChanged;
    private int lastDividerLoc;
    private int requestedRightLine = -1;
    private int requestedLeftLine = -1;
    private final VCSFileProxy root;
    private boolean fileComponentSetSelectedIndexContext;
    private JComboBox cmbDiffTreeFirst;
    private JComboBox cmbDiffTreeSecond;
    private JButton commitButton;
    private JToolBar controlsToolBar;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JPanel jPanel2;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JToggleButton listButton;
    private JButton nextButton;
    private JButton prevButton;
    private JButton refreshButton;
    private JSplitPane splitPane;
    private JToggleButton treeButton;
    private JPanel treeSelectionPanel;
    private ButtonGroup viewTypeGroup;

    public MultiDiffPanel(VCSContext context, int initialType, String contextName) {
        this(context, contextName, HgLogMessage.HgRevision.BASE, HgLogMessage.HgRevision.CURRENT, false);
        this.currentType = initialType;
        this.refreshStatuses();
    }

    private MultiDiffPanel(VCSContext context, String contextName, HgLogMessage.HgRevision revisionLeft, HgLogMessage.HgRevision revisionRight, boolean fixedRevisions) {
        this.context = context;
        this.root = (VCSFileProxy)context.getRootFiles().iterator().next();
        this.contextName = contextName;
        this.revisionLeft = this.revisionOriginalLeft = revisionLeft;
        this.revisionRight = this.revisionOriginalRight = revisionRight;
        this.fixedRevisions = fixedRevisions;
        this.initComponents();
        this.setAquaBackground();
        this.diffViewPanel = null;
        this.initFileComponent();
        this.initToolbarButtons();
        this.initNextPrevActions();
        this.splitPane.setDividerLocation(this.getActiveFileComponent().getPreferredHeaderHeight());
        this.initSelectionCombos();
        this.refreshComboTask = Mercurial.getInstance().getRequestProcessor().create((Runnable)new RefreshComboTask());
        this.refreshSelectionCombos();
        this.refreshComponents();
        this.refreshTask = Mercurial.getInstance().getRequestProcessor().create((Runnable)new RefreshViewTask());
    }

    public MultiDiffPanel(VCSFileProxy[] roots, HgLogMessage.HgRevision revisionLeft, HgLogMessage.HgRevision revisionRight, boolean fixedRevisions, boolean displayUnversionedFiles) {
        this(HgUtils.buildVCSContext(roots), null, revisionLeft, revisionRight, fixedRevisions);
        this.currentType = 0;
        this.displayUnversionedFiles = displayUnversionedFiles;
        this.refreshStatuses();
    }

    private void setAquaBackground() {
        if ("Aqua".equals(UIManager.getLookAndFeel().getID())) {
            Color color = UIManager.getColor("NbExplorerView.background");
            this.setBackground(color);
            this.controlsToolBar.setBackground(color);
            this.jPanel2.setBackground(color);
            this.jPanel4.setBackground(color);
            this.jPanel5.setBackground(color);
            this.treeSelectionPanel.setBackground(color);
        }
    }

    public MultiDiffPanel(VCSFileProxy file, HgLogMessage.HgRevision rev1, HgLogMessage.HgRevision rev2, boolean forceNonEditable) {
        this(file, rev1, rev2, new FileInformation(), forceNonEditable, -1);
    }

    public MultiDiffPanel(VCSFileProxy file, HgLogMessage.HgRevision rev1, HgLogMessage.HgRevision rev2, FileInformation fi, boolean forceNonEditable, int requestedRightLine) {
        this.context = null;
        this.contextName = file.getName();
        this.revisionOriginalLeft = rev1;
        this.revisionOriginalRight = rev2;
        this.fixedRevisions = true;
        this.requestedRightLine = requestedRightLine;
        this.initComponents();
        this.initSelectionCombos();
        this.setAquaBackground();
        this.diffViewPanel = new PlaceholderPanel();
        this.diffViewPanel.setComponent((Component)this.getInfoPanelLoading());
        this.replaceVerticalSplitPane((JComponent)this.diffViewPanel);
        this.initToolbarButtons();
        this.initNextPrevActions();
        AbstractDiffSetup[] localSetups = new Setup[]{new Setup(file, rev1, rev2, fi, forceNonEditable)};
        this.root = Mercurial.getInstance().getRepositoryRoot(file);
        localSetups[0].setNode(new DiffNode(localSetups[0], new HgFileNode(this.root, file)));
        this.setSetups((Setup[])localSetups, DiffUtils.setupsToEditorCookies((AbstractDiffSetup[])localSetups));
        this.setDiffIndex((Setup)localSetups[0], 0, false);
        this.dpt = new DiffPrepareTask(this.setups);
        this.prepareTask = Mercurial.getInstance().getRequestProcessor().post((Runnable)this.dpt);
    }

    final VCSFileProxy getRoot() {
        return this.root;
    }

    private void replaceVerticalSplitPane(JComponent replacement) {
        this.removeAll();
        this.splitPane = null;
        this.setLayout(new BorderLayout());
        this.controlsToolBar.setPreferredSize(new Dimension(Short.MAX_VALUE, 25));
        this.add((Component)this.controlsToolBar, "North");
        this.add((Component)replacement, "Center");
    }

    private void setSetups(Setup[] setups, EditorCookie[] editorCookies) {
        if (this.setups != null) {
            for (Setup setup : this.setups) {
                if (setup == null) continue;
                setup.getFirstSource().close();
                setup.getSecondSource().close();
            }
        }
        this.setups = setups;
        this.editorCookies = editorCookies;
    }

    void nodeSelected(DiffNode node) {
        if (this.fileComponentSetSelectedIndexContext) {
            return;
        }
        this.setDiffIndex(node == null ? null : node.getSetup(), 0, true);
    }

    UndoRedo getUndoRedo() {
        return this.delegatingUndoRedo;
    }

    private void cancelBackgroundTasks() {
        if (this.prepareTask != null) {
            this.prepareTask.cancel();
        }
        if (this.executeStatusSupport != null) {
            this.executeStatusSupport.cancel();
        }
        if (this.refreshTask != null) {
            this.refreshTask.cancel();
        }
    }

    boolean canClose() {
        if (this.setups == null) {
            return true;
        }
        SaveCookie[] saveCookies = this.getSaveCookies(true);
        return saveCookies.length == 0 || SaveBeforeClosingDiffConfirmation.allSaved((SaveCookie[])saveCookies);
    }

    public SaveCookie[] getSaveCookies(boolean ommitOpened) {
        EditorCookie[] editorCookiesCopy = this.getEditorCookiesIntern(ommitOpened);
        SaveCookie[] saveCookies = MultiDiffPanel.getSaveCookies(this.setups, editorCookiesCopy);
        return saveCookies;
    }

    public EditorCookie[] getEditorCookies(boolean ommitOpened) {
        EditorCookie[] editorCookiesCopy = this.getEditorCookiesIntern(ommitOpened);
        int count = 0;
        int length = editorCookiesCopy.length;
        Object[] editorCookiesShorten = new EditorCookie[length];
        for (int i = 0; i < length; ++i) {
            EditorCookie editorCookie = editorCookiesCopy[i];
            if (editorCookie == null) continue;
            editorCookiesShorten[count++] = editorCookie;
        }
        return (EditorCookie[])CollectionUtils.shortenArray((Object[])editorCookiesShorten, (int)count);
    }

    private EditorCookie[] getEditorCookiesIntern(boolean ommitOpened) {
        EditorCookie[] editorCookiesCopy = (EditorCookie[])CollectionUtils.copyArray((Object[])this.editorCookies);
        DiffUtils.cleanThoseUnmodified((EditorCookie[])editorCookiesCopy);
        if (ommitOpened) {
            DiffUtils.cleanThoseWithEditorPaneOpen((EditorCookie[])editorCookiesCopy);
        }
        return editorCookiesCopy;
    }

    private static SaveCookie[] getSaveCookies(Setup[] setups, EditorCookie[] editorCookies) {
        assert (setups.length == editorCookies.length);
        int length = setups.length;
        Object[] proResult = new SaveCookie[length];
        int count = 0;
        for (int i = 0; i < length; ++i) {
            FileObject fileObj;
            VCSFileProxy baseFile;
            EditorCookie editorCookie = editorCookies[i];
            if (editorCookie == null || (baseFile = setups[i].getBaseFile()) == null || (fileObj = baseFile.toFileObject()) == null) continue;
            proResult[count++] = new EditorSaveCookie(editorCookie, fileObj.getNameExt());
        }
        return (SaveCookie[])CollectionUtils.shortenArray((Object[])proResult, (int)count);
    }

    public void componentClosed() {
        this.setSetups(null, null);
        this.prevAction.setEnabled(false);
        this.nextAction.setEnabled(false);
        this.cancelBackgroundTasks();
    }

    public JPopupMenu getPopup() {
        JPopupMenu menu = null;
        if (this.isLocal()) {
            menu = new JPopupMenu();
            JMenuItem item = menu.add(new OpenInEditorAction());
            Mnemonics.setLocalizedText((AbstractButton)item, (String)item.getText());
            if (this.isLocalToBase()) {
                menu.addSeparator();
                item = menu.add((Action)new SystemActionBridge((Action)SystemAction.get(AddAction.class), NbBundle.getMessage(AddAction.class, (String)"CTL_PopupMenuItem_Add")));
                Mnemonics.setLocalizedText((AbstractButton)item, (String)item.getText());
                item = menu.add((Action)new SystemActionBridge((Action)SystemAction.get(CommitAction.class), this.actionString("CTL_PopupMenuItem_Commit")));
                Mnemonics.setLocalizedText((AbstractButton)item, (String)item.getText());
                menu.addSeparator();
                item = menu.add((Action)new SystemActionBridge((Action)SystemAction.get(AnnotateAction.class), ((AnnotateAction)SystemAction.get(AnnotateAction.class)).visible(null) ? this.actionString("CTL_PopupMenuItem_HideAnnotations") : this.actionString("CTL_PopupMenuItem_ShowAnnotations")));
                Mnemonics.setLocalizedText((AbstractButton)item, (String)item.getText());
                menu.addSeparator();
                boolean allLocallyDeleted = true;
                FileStatusCache cache = Mercurial.getInstance().getFileStatusCache();
                Set files = HgUtils.getCurrentContext(null).getRootFiles();
                for (VCSFileProxy file : files) {
                    FileInformation info = cache.getStatus(file);
                    if (info.getStatus() == 2048 || info.getStatus() == 256) continue;
                    allLocallyDeleted = false;
                }
                item = allLocallyDeleted ? menu.add((Action)new SystemActionBridge((Action)SystemAction.get(RevertModificationsAction.class), this.actionString("CTL_PopupMenuItem_RevertDelete"))) : menu.add((Action)new SystemActionBridge((Action)SystemAction.get(RevertModificationsAction.class), this.actionString("CTL_PopupMenuItem_GetClean")));
                Mnemonics.setLocalizedText((AbstractButton)item, (String)item.getText());
                item = menu.add(new AbstractAction(this.actionString("CTL_PopupMenuItem_ExportDiffChanges")){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        ((ExportDiffChangesAction)SystemAction.get(ExportDiffChangesAction.class)).performContextAction(null, true);
                    }
                });
                Mnemonics.setLocalizedText((AbstractButton)item, (String)item.getText());
                ExcludeFromCommitAction exclude = (ExcludeFromCommitAction)SystemAction.get(ExcludeFromCommitAction.class);
                String label = exclude.getActionStatus(null) == 2 ? this.actionString("CTL_PopupMenuItem_IncludeInCommit") : this.actionString("CTL_PopupMenuItem_ExcludeFromCommit");
                item = menu.add((Action)new SystemActionBridge((Action)((Object)exclude), label));
                Mnemonics.setLocalizedText((AbstractButton)item, (String)item.getText());
            }
        }
        return menu;
    }

    private String actionString(String key) {
        ResourceBundle actionsLoc = NbBundle.getBundle(MercurialAnnotator.class);
        return actionsLoc.getString(key);
    }

    public void requestActive() {
        FileViewComponent<DiffNode> comp = this.getActiveFileComponent();
        if (comp != null) {
            comp.getComponent().requestFocusInWindow();
        } else if (this.diffView != null) {
            this.diffView.requestFocusInWindow();
        }
    }

    private void initFileComponent() {
        this.fileListComponent = new DiffFileTable(this);
        this.fileTreeComponent = new DiffFileTreeImpl(this);
        int viewMode = HgModuleConfig.getDefault(this.root).getDiffViewMode(1);
        if (viewMode == 2) {
            this.treeButton.setSelected(true);
            this.setActiveComponent(this.fileTreeComponent);
        } else {
            this.listButton.setSelected(true);
            this.setActiveComponent(this.fileListComponent);
        }
        this.splitPane.setBottomComponent(this.getInfoPanelLoading());
    }

    private void initToolbarButtons() {
        if (this.context != null) {
            this.commitButton.addActionListener(this);
            this.listButton.addActionListener(this);
            this.treeButton.addActionListener(this);
            this.commitButton.setToolTipText(NbBundle.getMessage(MultiDiffPanel.class, (String)"CTL_CommitDiff_Tooltip"));
            this.commitButton.setEnabled(false);
        } else {
            this.commitButton.setVisible(false);
            this.refreshButton.setVisible(false);
            this.listButton.setVisible(false);
            this.treeButton.setVisible(false);
        }
    }

    private void initNextPrevActions() {
        this.nextAction = new AbstractAction(null, new ImageIcon(this.getClass().getResource("/org/netbeans/modules/mercurial/remote/resources/icons/diff-next.png"))){
            {
                this.putValue("ShortDescription", ResourceBundle.getBundle("org/netbeans/modules/mercurial/remote/ui/diff/Bundle").getString("CTL_DiffPanel_Next_Tooltip"));
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                MultiDiffPanel.this.onNextButton();
            }
        };
        this.prevAction = new AbstractAction(null, new ImageIcon(this.getClass().getResource("/org/netbeans/modules/mercurial/remote/resources/icons/diff-prev.png"))){
            {
                this.putValue("ShortDescription", ResourceBundle.getBundle("org/netbeans/modules/mercurial/remote/ui/diff/Bundle").getString("CTL_DiffPanel_Prev_Tooltip"));
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                MultiDiffPanel.this.onPrevButton();
            }
        };
        this.nextButton.setAction(this.nextAction);
        this.prevButton.setAction(this.prevAction);
    }

    private JComponent getInfoPanelLoading() {
        if (this.infoPanelLoadingFromRepo == null) {
            this.infoPanelLoadingFromRepo = new NoContentPanel(NbBundle.getMessage(MultiDiffPanel.class, (String)"MSG_DiffPanel_NoContent"));
        }
        return this.infoPanelLoadingFromRepo;
    }

    private void refreshComponents() {
        int currentDifferenceIndex;
        if (this.currentSetup == null) {
            this.nextAction.setEnabled(false);
            this.prevAction.setEnabled(false);
            return;
        }
        DiffController view = this.currentSetup.getView();
        int n = currentDifferenceIndex = view != null ? view.getDifferenceIndex() : -1;
        if (view != null) {
            this.nextAction.setEnabled(this.showingFileComponent() && this.getActiveFileComponent().hasNextNode((Node)this.currentSetup.getNode()) || currentDifferenceIndex < view.getDifferenceCount() - 1);
        } else {
            this.nextAction.setEnabled(false);
        }
        this.prevAction.setEnabled(this.showingFileComponent() && this.getActiveFileComponent().hasPreviousNode((Node)this.currentSetup.getNode()) || currentDifferenceIndex > 0);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        if (this.refreshTask != null) {
            Mercurial.getInstance().getFileStatusCache().addPropertyChangeListener(this);
            HgModuleConfig.getDefault(this.root).getPreferences().addPreferenceChangeListener(this);
        }
        JComponent parent = (JComponent)this.getParent();
        parent.getActionMap().put("jumpNext", this.nextAction);
        parent.getActionMap().put("jumpPrev", this.prevAction);
        if (this.splitPane != null && this.lastDividerLoc != 0) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MultiDiffPanel.this.splitPane.setDividerLocation(MultiDiffPanel.this.lastDividerLoc);
                }
            });
        }
    }

    private void updateSplitLocation() {
        Dimension dim;
        if (this.dividerSet) {
            return;
        }
        JComponent parent = (JComponent)this.getParent();
        Dimension dimension = dim = parent == null ? new Dimension() : parent.getSize();
        if (dim.width <= 0 || dim.height <= 0) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MultiDiffPanel.this.updateSplitLocation();
                }
            });
            return;
        }
        this.dividerSet = true;
        FileViewComponent<DiffNode> fileComp = this.getActiveFileComponent();
        int preferredHeaderHeight = fileComp.getPreferredHeaderHeight();
        int preferredHeight = fileComp.getPreferredHeight();
        int optimalLocation = preferredHeight + preferredHeaderHeight + 5;
        if (optimalLocation > dim.height / 3) {
            optimalLocation = dim.height / 3;
        }
        if (optimalLocation <= preferredHeaderHeight) {
            optimalLocation = preferredHeaderHeight * 3;
        }
        this.splitPane.setDividerLocation(optimalLocation);
    }

    @Override
    public void removeNotify() {
        if (this.splitPane != null) {
            this.lastDividerLoc = this.splitPane.getDividerLocation();
        }
        Mercurial.getInstance().getFileStatusCache().removePropertyChangeListener(this);
        if (this.refreshTask != null) {
            HgModuleConfig.getDefault(this.root).getPreferences().removePreferenceChangeListener(this);
        }
        super.removeNotify();
    }

    private boolean affectsView(PropertyChangeEvent event) {
        FileStatusCache.ChangedEvent changedEvent = (FileStatusCache.ChangedEvent)event.getNewValue();
        VCSFileProxy file = changedEvent.getFile();
        FileInformation oldInfo = changedEvent.getOldInfo();
        FileInformation newInfo = changedEvent.getNewInfo();
        if (oldInfo == null ? (newInfo.getStatus() & this.displayStatuses) == 0 : (oldInfo.getStatus() & this.displayStatuses) + (newInfo.getStatus() & this.displayStatuses) == 0) {
            return false;
        }
        return this.isLocal() && this.containsFile(file);
    }

    private boolean containsFile(VCSFileProxy file) {
        if (this.context != null) {
            return HgUtils.contains(this.context.getRootFiles(), file);
        }
        return false;
    }

    private void setDiffIndex(Setup selectedSetup, int location, boolean restartPrepareTask) {
        this.currentSetup = selectedSetup;
        this.currentSetupDiffLengthChanged = -1;
        if (this.currentSetup != null) {
            if (restartPrepareTask && this.dpt != null) {
                this.dpt.cancel();
                this.dpt.setSelectedSetup(this.currentSetup);
                this.prepareTask.schedule(100);
            }
            DiffController view = this.currentSetup.getView();
            TopComponent tc = (TopComponent)this.getClientProperty(TopComponent.class);
            if (tc != null) {
                DiffNode node = this.currentSetup.getNode();
                tc.setActivatedNodes(new Node[]{node == null ? Node.EMPTY : node});
            }
            this.diffView = null;
            if (view != null) {
                this.currentSetupDiffLengthChanged = view.getDifferenceCount();
                if (this.showingFileComponent()) {
                    this.fileComponentSetSelectedIndexContext = true;
                    this.getActiveFileComponent().setSelectedNode((Node)this.currentSetup.getNode());
                    this.fileComponentSetSelectedIndexContext = false;
                }
                this.diffView = view.getJComponent();
                this.diffView.getActionMap().put("jumpNext", this.nextAction);
                this.diffView.getActionMap().put("jumpPrev", this.prevAction);
                this.displayDiffView();
                if (location == -1) {
                    location = view.getDifferenceCount() - 1;
                }
                if (location >= 0 && location < view.getDifferenceCount()) {
                    view.setLocation(DiffController.DiffPane.Modified, DiffController.LocationType.DifferenceIndex, location);
                }
            } else {
                this.diffView = new NoContentPanel(NbBundle.getMessage(MultiDiffPanel.class, (String)"MSG_DiffPanel_NoContent"));
                this.displayDiffView();
            }
        } else {
            this.diffView = new NoContentPanel(NbBundle.getMessage(MultiDiffPanel.class, (String)"MSG_DiffPanel_NoFileSelected"));
            this.displayDiffView();
        }
        this.delegatingUndoRedo.setDiffView(this.diffView);
        this.refreshComponents();
    }

    private boolean showingFileComponent() {
        return this.getActiveFileComponent() != null;
    }

    private void displayDiffView() {
        if (this.splitPane != null) {
            int gg = this.splitPane.getDividerLocation();
            this.splitPane.setBottomComponent(this.diffView);
            this.splitPane.setDividerLocation(gg);
        } else {
            this.diffViewPanel.setComponent((Component)this.diffView);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.commitButton) {
            this.onCommitButton();
        } else if (source == this.cmbDiffTreeSecond) {
            boolean refresh;
            HgLogMessage.HgRevision oldSelection = this.revisionLeft;
            HgLogMessage.HgRevision newSelection = this.getSelectedRevision(this.cmbDiffTreeSecond);
            if (newSelection != null) {
                this.revisionLeft = newSelection;
            }
            boolean bl = refresh = !oldSelection.getChangesetId().equals(this.revisionLeft.getChangesetId());
            if (refresh) {
                this.refreshStatuses();
            }
        } else if (source == this.cmbDiffTreeFirst) {
            boolean refresh;
            HgLogMessage.HgRevision oldSelection = this.revisionRight;
            HgLogMessage.HgRevision newSelection = this.getSelectedRevision(this.cmbDiffTreeFirst);
            if (newSelection != null) {
                this.revisionRight = newSelection;
            }
            boolean bl = refresh = !oldSelection.getChangesetId().equals(this.revisionRight.getChangesetId());
            if (refresh) {
                this.refreshStatuses();
            }
        } else if (source == this.listButton) {
            this.setActiveComponent(this.fileListComponent);
            this.setActiveDiff();
        } else if (source == this.treeButton) {
            this.setActiveComponent(this.fileTreeComponent);
            this.setActiveDiff();
        }
    }

    private void setActiveDiff() {
        DiffNode selectedNode = (DiffNode)this.activeComponent.getSelectedNode();
        this.setDiffIndex(selectedNode == null ? null : selectedNode.getSetup(), 0, false);
    }

    private HgLogMessage.HgRevision getSelectedRevision(JComboBox cmbDiffTree) {
        Object selectedItem = cmbDiffTree.getSelectedItem();
        HgLogMessage.HgRevision selection = null;
        if (selectedItem instanceof HgLogMessage.HgRevision) {
            selection = (HgLogMessage.HgRevision)selectedItem;
        } else if (selectedItem instanceof HgLogMessage) {
            selection = ((HgLogMessage)selectedItem).getHgRevision();
        } else if (selectedItem == REVISION_SELECT) {
            VCSFileProxy repository = HgUtils.getRootFile(this.context);
            if (repository == null) {
                LOG.log(Level.INFO, "getSelectedRevision: No repository for {0}", this.context.getRootFiles());
                return null;
            }
            HeadRevisionPicker picker = new HeadRevisionPicker(repository, null);
            if (picker.showDialog()) {
                HgLogMessage selectedRevision = picker.getSelectionRevision();
                selection = selectedRevision.getHgRevision();
                this.addToModel(selectedRevision, cmbDiffTree);
            }
        }
        return selection;
    }

    private void addToModel(final HgLogMessage newItem, final JComboBox cmbDiffTree) {
        DefaultComboBoxModel model = (DefaultComboBoxModel)cmbDiffTree.getModel();
        for (int i = 0; i < model.getSize(); ++i) {
            final Object item = model.getElementAt(i);
            if (!(item instanceof HgLogMessage) || !((HgLogMessage)item).getCSetShortID().equals(newItem.getCSetShortID())) continue;
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    cmbDiffTree.setSelectedItem(item);
                }
            });
            return;
        }
        model.addElement(newItem);
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                cmbDiffTree.setSelectedItem(newItem);
            }
        });
    }

    private void onRefreshButton() {
        this.refreshStatuses();
    }

    private void refreshStatuses() {
        this.commitButton.setEnabled(false);
        if (this.context == null || this.context.getRootFiles().isEmpty()) {
            return;
        }
        if (this.executeStatusSupport != null) {
            this.executeStatusSupport.cancel();
            this.executeStatusSupport = null;
        }
        LifecycleManager.getDefault().saveAll();
        RequestProcessor rp = Mercurial.getInstance().getRequestProcessor();
        this.executeStatusSupport = new HgProgressSupport(){

            @Override
            public void perform() {
                if (MultiDiffPanel.this.context != null && MultiDiffPanel.this.revisionLeft == HgLogMessage.HgRevision.BASE && MultiDiffPanel.this.isLocal()) {
                    StatusAction.executeStatus(MultiDiffPanel.this.context, this);
                }
                MultiDiffPanel.this.refreshSetups();
            }
        };
        VCSFileProxy repositoryRoot = HgUtils.getRootFile(this.context);
        if (repositoryRoot == null) {
            LOG.log(Level.INFO, "getSelectedRevision: No repository for {0}", this.context.getRootFiles());
            return;
        }
        this.executeStatusSupport.start(rp, repositoryRoot, NbBundle.getMessage(MultiDiffPanel.class, (String)"MSG_Refresh_Progress"));
    }

    private void onCommitButton() {
        EditorCookie[] editorCookiesCopy = (EditorCookie[])CollectionUtils.copyArray((Object[])this.editorCookies);
        DiffUtils.cleanThoseUnmodified((EditorCookie[])editorCookiesCopy);
        SaveCookie[] saveCookies = MultiDiffPanel.getSaveCookies(this.setups, editorCookiesCopy);
        if (saveCookies.length == 0 || SaveBeforeCommitConfirmation.allSaved((SaveCookie[])saveCookies)) {
            CommitAction.commit(this.contextName, this.context);
        }
    }

    private void onNextButton() {
        DiffNode next;
        DiffController view = this.currentSetup.getView();
        DiffNode diffNode = next = this.showingFileComponent() ? (DiffNode)this.getActiveFileComponent().getNextNode((Node)this.currentSetup.getNode()) : null;
        if (view != null) {
            int currentDifferenceIndex = view.getDifferenceIndex();
            if (this.currentSetupDiffLengthChanged >= 0) {
                ++currentDifferenceIndex;
            }
            this.currentSetupDiffLengthChanged = view.getDifferenceCount();
            if (currentDifferenceIndex >= view.getDifferenceCount()) {
                if (next != null) {
                    this.setDiffIndex(next.getSetup(), 0, true);
                }
            } else {
                view.setLocation(DiffController.DiffPane.Modified, DiffController.LocationType.DifferenceIndex, currentDifferenceIndex);
            }
        } else if (next != null) {
            this.setDiffIndex(next.getSetup(), 0, true);
        }
        this.refreshComponents();
    }

    private void onPrevButton() {
        DiffNode prev;
        DiffController view = this.currentSetup.getView();
        DiffNode diffNode = prev = this.showingFileComponent() ? (DiffNode)this.getActiveFileComponent().getPreviousNode((Node)this.currentSetup.getNode()) : null;
        if (view != null) {
            int currentDifferenceIndex = view.getDifferenceIndex();
            if (this.currentSetupDiffLengthChanged >= 0) {
                --currentDifferenceIndex;
            }
            this.currentSetupDiffLengthChanged = view.getDifferenceCount();
            if (currentDifferenceIndex < 0) {
                if (prev != null) {
                    this.setDiffIndex(prev.getSetup(), -1, true);
                }
            } else if (currentDifferenceIndex < view.getDifferenceCount()) {
                view.setLocation(DiffController.DiffPane.Modified, DiffController.LocationType.DifferenceIndex, currentDifferenceIndex);
            }
        } else if (prev != null) {
            this.setDiffIndex(prev.getSetup(), -1, true);
        }
        this.refreshComponents();
    }

    @Override
    public Collection<Setup> getSetups() {
        if (this.setups == null) {
            return Collections.emptySet();
        }
        return Arrays.asList(this.setups);
    }

    @Override
    public String getSetupDisplayName() {
        return this.contextName;
    }

    private void refreshSetups() {
        AbstractDiffSetup[] localSetups;
        int status;
        if (this.dpt != null) {
            this.prepareTask.cancel();
        }
        switch (this.currentType) {
            case 0: {
                status = 6612;
                break;
            }
            case 1: {
                status = 1696;
                break;
            }
            case 2: {
                status = 8180;
                break;
            }
            default: {
                throw new IllegalStateException("Unknown DIFF type:" + this.currentType);
            }
        }
        final int localDisplayStatuses = status;
        if (this.revisionLeft == HgLogMessage.HgRevision.BASE && this.isLocal()) {
            VCSFileProxy[] files = HgUtils.getModifiedFiles(this.context, status, true);
            localSetups = this.computeSetups(files);
        } else {
            localSetups = this.computeSetupsBetweenRevisions();
        }
        Arrays.sort(localSetups, new Comparator<Setup>(){

            @Override
            public int compare(Setup o1, Setup o2) {
                return o2.getNode().getLocation().compareTo(o1.getNode().getLocation());
            }
        });
        EditorCookie[] cookies = DiffUtils.setupsToEditorCookies((AbstractDiffSetup[])localSetups);
        DiffNode[] nodes = MultiDiffPanel.setupsToNodes((Setup[])localSetups);
        Object modelDataList = this.fileListComponent.prepareModel((Node[])nodes);
        Object modelDataTree = this.fileTreeComponent.prepareModel((Node[])nodes);
        Runnable runnable = new Runnable((Setup[])localSetups, cookies, nodes, modelDataList, modelDataTree){
            final /* synthetic */ Setup[] val$localSetups;
            final /* synthetic */ EditorCookie[] val$cookies;
            final /* synthetic */ DiffNode[] val$nodes;
            final /* synthetic */ Object val$modelDataList;
            final /* synthetic */ Object val$modelDataTree;
            {
                this.val$localSetups = setupArray;
                this.val$cookies = editorCookieArray;
                this.val$nodes = diffNodeArray;
                this.val$modelDataList = object;
                this.val$modelDataTree = object2;
            }

            @Override
            public void run() {
                MultiDiffPanel.this.dividerSet = false;
                MultiDiffPanel.this.displayStatuses = localDisplayStatuses;
                MultiDiffPanel.this.setSetups(this.val$localSetups, this.val$cookies);
                FileViewComponent activeFileComponent = MultiDiffPanel.this.getActiveFileComponent();
                MultiDiffPanel.this.fileListComponent.setModel((Node[])this.val$nodes, MultiDiffPanel.this.editorCookies, this.val$modelDataList);
                MultiDiffPanel.this.fileTreeComponent.setModel((Node[])this.val$nodes, MultiDiffPanel.this.editorCookies, this.val$modelDataTree);
                if (MultiDiffPanel.this.setups.length == 0) {
                    String noContentLabel;
                    switch (MultiDiffPanel.this.currentType) {
                        case 0: {
                            noContentLabel = NbBundle.getMessage(MultiDiffPanel.class, (String)"MSG_DiffPanel_NoLocalChanges");
                            break;
                        }
                        case 1: {
                            noContentLabel = NbBundle.getMessage(MultiDiffPanel.class, (String)"MSG_DiffPanel_NoRemoteChanges");
                            break;
                        }
                        case 2: {
                            noContentLabel = NbBundle.getMessage(MultiDiffPanel.class, (String)"MSG_DiffPanel_NoAllChanges");
                            break;
                        }
                        default: {
                            throw new IllegalStateException("Unknown DIFF type:" + MultiDiffPanel.this.currentType);
                        }
                    }
                    MultiDiffPanel.this.setSetups(null, null);
                    MultiDiffPanel.this.fileListComponent.getComponent().setEnabled(false);
                    MultiDiffPanel.this.fileListComponent.getComponent().setPreferredSize(null);
                    MultiDiffPanel.this.fileTreeComponent.getComponent().setEnabled(false);
                    MultiDiffPanel.this.fileTreeComponent.getComponent().setPreferredSize(null);
                    Dimension dim = activeFileComponent.getComponent().getPreferredSize();
                    activeFileComponent.getComponent().setPreferredSize(new Dimension(dim.width + 1, dim.height));
                    MultiDiffPanel.this.diffView = null;
                    MultiDiffPanel.this.diffView = (JComponent)new NoContentPanel(noContentLabel);
                    MultiDiffPanel.this.displayDiffView();
                    MultiDiffPanel.this.nextAction.setEnabled(false);
                    MultiDiffPanel.this.prevAction.setEnabled(false);
                    MultiDiffPanel.this.commitButton.setEnabled(false);
                    MultiDiffPanel.this.revalidate();
                    MultiDiffPanel.this.repaint();
                } else {
                    MultiDiffPanel.this.fileListComponent.getComponent().setEnabled(true);
                    MultiDiffPanel.this.fileListComponent.getComponent().setPreferredSize(null);
                    MultiDiffPanel.this.fileTreeComponent.getComponent().setEnabled(true);
                    MultiDiffPanel.this.fileTreeComponent.getComponent().setPreferredSize(null);
                    Dimension dim = activeFileComponent.getComponent().getPreferredSize();
                    activeFileComponent.getComponent().setPreferredSize(new Dimension(dim.width + 1, dim.height));
                    Setup toSelect = ((DiffNode)activeFileComponent.getNodeAtPosition(0)).getSetup();
                    MultiDiffPanel.this.setDiffIndex(toSelect, 0, false);
                    MultiDiffPanel.this.commitButton.setEnabled(MultiDiffPanel.this.isLocalToBase());
                    MultiDiffPanel.this.dpt = new DiffPrepareTask(MultiDiffPanel.this.setups);
                    MultiDiffPanel.this.dpt.setSelectedSetup(toSelect);
                    MultiDiffPanel.this.prepareTask = Mercurial.getInstance().getRequestProcessor().post((Runnable)MultiDiffPanel.this.dpt);
                }
            }
        };
        if (EventQueue.isDispatchThread()) {
            runnable.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(runnable);
            }
            catch (InterruptedException ex) {
                Mercurial.LOG.log(Level.FINE, null, ex);
            }
            catch (InvocationTargetException ex) {
                Mercurial.LOG.log(Level.FINE, null, ex);
            }
        }
    }

    private static DiffNode[] setupsToNodes(Setup[] setups) {
        DiffNode[] nodes = new DiffNode[setups.length];
        for (int i = 0; i < setups.length; ++i) {
            nodes[i] = setups[i].getNode();
        }
        return nodes;
    }

    private boolean isLocal() {
        return this.revisionRight == HgLogMessage.HgRevision.CURRENT;
    }

    private boolean isLocalToBase() {
        return this.isLocal() && (this.revisionLeft == HgLogMessage.HgRevision.BASE || this.revisionLeft == HgLogMessage.HgRevision.QDIFF_BASE);
    }

    private Setup[] computeSetups(VCSFileProxy[] files) {
        ArrayList<Setup> newSetups = new ArrayList<Setup>(files.length);
        Mercurial hg = Mercurial.getInstance();
        for (int i = 0; i < files.length; ++i) {
            VCSFileProxy file = files[i];
            if (file.isDirectory()) continue;
            Setup setup = new Setup(file, null, this.currentType);
            setup.setNode(new DiffNode(setup, new HgFileNode(hg.getRepositoryRoot(file), file)));
            newSetups.add(setup);
        }
        Collections.sort(newSetups, new SetupsComparator());
        return newSetups.toArray(new Setup[newSetups.size()]);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("(void) differencesChanged".equals(evt.getPropertyName())) {
            if (this.currentSetup != null && this.currentSetup.getView() != null) {
                if (this.currentSetup.getView().getDifferenceCount() < this.currentSetupDiffLengthChanged) {
                    this.currentSetupDiffLengthChanged = -1;
                } else if (this.currentSetupDiffLengthChanged != -1) {
                    this.currentSetupDiffLengthChanged = this.currentSetup.getView().getDifferenceCount();
                }
                if (this.currentSetup.getView().getDifferenceCount() > 0 && this.requestedRightLine != -1) {
                    final int leftLine = this.requestedLeftLine;
                    final int rightLine = this.requestedRightLine;
                    this.requestedLeftLine = -1;
                    this.requestedRightLine = -1;
                    final DiffController view = this.currentSetup.getView();
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            view.setLocation(DiffController.DiffPane.Modified, DiffController.LocationType.LineNumber, rightLine);
                            if (leftLine != -1) {
                                view.getJComponent().putClientProperty("diff.smartScrollDisabled", Boolean.TRUE);
                                view.setLocation(DiffController.DiffPane.Base, DiffController.LocationType.LineNumber, leftLine);
                            }
                        }
                    });
                }
            }
            this.refreshComponents();
        } else if ("status.changed".equals(evt.getPropertyName())) {
            if (!this.affectsView(evt)) {
                return;
            }
            this.refreshTask.schedule(200);
        }
    }

    @Override
    public void preferenceChange(PreferenceChangeEvent evt) {
        if (evt.getKey().startsWith("commitExclusions")) {
            this.repaint();
        }
    }

    private Setup[] computeSetupsBetweenRevisions() {
        VCSFileProxy repository = HgUtils.getRootFile(this.context);
        HgLogMessage.HgRevision revLeft = this.revisionLeft;
        HgLogMessage.HgRevision revRight = this.revisionRight;
        try {
            if (this.revisionLeft == HgLogMessage.HgRevision.BASE || this.revisionRight == HgLogMessage.HgRevision.BASE) {
                HgLogMessage.HgRevision parent = HgCommand.getParent(repository, null, null);
                if (revLeft == HgLogMessage.HgRevision.BASE) {
                    revLeft = parent;
                }
                if (revRight == HgLogMessage.HgRevision.BASE) {
                    revRight = parent;
                }
            }
            if (!revLeft.getChangesetId().equals(revRight.getChangesetId())) {
                Map<VCSFileProxy, FileInformation> statuses = HgCommand.getStatus(repository, new ArrayList<VCSFileProxy>(this.context.getRootFiles()), this.revisionLeft.getChangesetId(), this.revisionRight.getChangesetId(), this.isLocalToBase());
                statuses.keySet().retainAll(VCSFileProxySupport.flattenFiles((VCSFileProxy[])this.context.getRootFiles().toArray(new VCSFileProxy[this.context.getRootFiles().size()]), statuses.keySet()));
                ArrayList<Setup> newSetups = new ArrayList<Setup>(statuses.size());
                Mercurial hg = Mercurial.getInstance();
                for (Map.Entry<VCSFileProxy, FileInformation> e : statuses.entrySet()) {
                    FileInformation fi;
                    VCSFileProxy file = e.getKey();
                    if (!this.isVisible(file, fi = e.getValue())) continue;
                    Setup setup = new Setup(file, this.revisionLeft, this.revisionRight, fi, false);
                    setup.setNode(new DiffNode(setup, new HgFileNode(hg.getRepositoryRoot(file), file)));
                    newSetups.add(setup);
                }
                return newSetups.toArray(new Setup[newSetups.size()]);
            }
        }
        catch (HgException.HgCommandCanceledException ex) {
        }
        catch (HgException ex) {
            Mercurial.LOG.log(Level.INFO, null, ex);
        }
        return new Setup[0];
    }

    private boolean isVisible(VCSFileProxy file, FileInformation fi) {
        boolean allowed;
        boolean bl = allowed = (fi.getStatus() & 4) == 0;
        if (!allowed && this.displayUnversionedFiles) {
            FileStatusCache cache = Mercurial.getInstance().getFileStatusCache();
            allowed = (cache.getStatus(file).getStatus() & 2) == 0;
        }
        return allowed;
    }

    private void refreshSelectionCombos() {
        if (!this.fixedRevisions && HgUtils.getRepositoryRoots(this.context).size() == 1) {
            this.cmbDiffTreeFirst.setEnabled(false);
            this.cmbDiffTreeSecond.setEnabled(false);
            this.refreshComboTask.schedule(100);
        }
    }

    private void initSelectionCombos() {
        if (this.fixedRevisions) {
            this.treeSelectionPanel.setVisible(false);
        } else {
            this.cmbDiffTreeFirst.setMinimumSize(this.cmbDiffTreeFirst.getMinimumSize());
            this.cmbDiffTreeSecond.setMinimumSize(this.cmbDiffTreeSecond.getMinimumSize());
            this.treeSelectionPanel.setMinimumSize(this.treeSelectionPanel.getMinimumSize());
            this.cmbDiffTreeFirst.setRenderer(new HgRevisionCellRenderer());
            this.cmbDiffTreeFirst.setModel(new DefaultComboBoxModel<HgLogMessage.HgRevision>(new HgLogMessage.HgRevision[]{this.revisionRight}));
            this.cmbDiffTreeFirst.addActionListener(this);
            this.cmbDiffTreeSecond.setRenderer(new HgRevisionCellRenderer());
            this.cmbDiffTreeSecond.setModel(new DefaultComboBoxModel<HgLogMessage.HgRevision>(new HgLogMessage.HgRevision[]{this.revisionLeft}));
            this.cmbDiffTreeSecond.addActionListener(this);
        }
    }

    private FileViewComponent<DiffNode> getActiveFileComponent() {
        return this.activeComponent;
    }

    private void setActiveComponent(FileViewComponent<DiffNode> fileComponent) {
        if (this.activeComponent == fileComponent) {
            return;
        }
        this.activeComponent = fileComponent;
        HgModuleConfig.getDefault(this.root).setDiffViewMode(this.activeComponent == this.fileListComponent ? 1 : 2);
        int gg = this.splitPane.getDividerLocation();
        this.splitPane.setTopComponent(this.getActiveFileComponent().getComponent());
        this.splitPane.setDividerLocation(gg);
    }

    private void initComponents() {
        this.viewTypeGroup = new ButtonGroup();
        this.controlsToolBar = new JToolBar();
        this.listButton = new JToggleButton();
        this.treeButton = new JToggleButton();
        this.jPanel4 = new JPanel();
        this.nextButton = new JButton();
        this.prevButton = new JButton();
        this.jPanel2 = new JPanel();
        this.refreshButton = new JButton();
        this.jPanel5 = new JPanel();
        this.commitButton = new JButton();
        this.treeSelectionPanel = new JPanel();
        this.cmbDiffTreeFirst = new JComboBox();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.cmbDiffTreeSecond = new JComboBox();
        this.splitPane = new JSplitPane();
        this.controlsToolBar.setFloatable(false);
        this.controlsToolBar.setRollover(true);
        this.viewTypeGroup.add(this.listButton);
        this.listButton.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/mercurial/remote/resources/icons/file_view.png")));
        this.listButton.setToolTipText(NbBundle.getMessage(MultiDiffPanel.class, (String)"MultiDiffPanel.listButton.toolTipText"));
        this.listButton.setFocusable(false);
        this.controlsToolBar.add(this.listButton);
        this.viewTypeGroup.add(this.treeButton);
        this.treeButton.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/mercurial/remote/resources/icons/logical_view.png")));
        this.treeButton.setToolTipText(NbBundle.getMessage(MultiDiffPanel.class, (String)"MultiDiffPanel.treeButton.toolTipText"));
        this.treeButton.setFocusable(false);
        this.controlsToolBar.add(this.treeButton);
        this.jPanel4.setMaximumSize(new Dimension(80, Short.MAX_VALUE));
        GroupLayout jPanel4Layout = new GroupLayout(this.jPanel4);
        this.jPanel4.setLayout(jPanel4Layout);
        jPanel4Layout.setHorizontalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 80, Short.MAX_VALUE));
        jPanel4Layout.setVerticalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 31, Short.MAX_VALUE));
        this.controlsToolBar.add(this.jPanel4);
        this.nextButton.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/mercurial/remote/resources/icons/diff-next.png")));
        this.nextButton.setToolTipText(NbBundle.getMessage(MultiDiffPanel.class, (String)"CTL_DiffPanel_Next_Tooltip"));
        this.nextButton.setFocusable(false);
        this.controlsToolBar.add(this.nextButton);
        this.prevButton.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/mercurial/remote/resources/icons/diff-prev.png")));
        this.prevButton.setToolTipText(NbBundle.getMessage(MultiDiffPanel.class, (String)"CTL_DiffPanel_Prev_Tooltip"));
        this.prevButton.setFocusable(false);
        this.controlsToolBar.add(this.prevButton);
        this.jPanel2.setMaximumSize(new Dimension(30, Short.MAX_VALUE));
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 30, Short.MAX_VALUE));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 31, Short.MAX_VALUE));
        this.controlsToolBar.add(this.jPanel2);
        this.refreshButton.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/mercurial/remote/resources/icons/refresh.png")));
        this.refreshButton.setToolTipText(NbBundle.getMessage(MultiDiffPanel.class, (String)"refreshButton.toolTipText"));
        this.refreshButton.setFocusable(false);
        this.refreshButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MultiDiffPanel.this.refreshButtonActionPerformed(evt);
            }
        });
        this.controlsToolBar.add(this.refreshButton);
        this.jPanel5.setMaximumSize(new Dimension(20, Short.MAX_VALUE));
        GroupLayout jPanel5Layout = new GroupLayout(this.jPanel5);
        this.jPanel5.setLayout(jPanel5Layout);
        jPanel5Layout.setHorizontalGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 20, Short.MAX_VALUE));
        jPanel5Layout.setVerticalGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 31, Short.MAX_VALUE));
        this.controlsToolBar.add(this.jPanel5);
        this.commitButton.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/mercurial/remote/resources/icons/commit.png")));
        this.commitButton.setToolTipText(NbBundle.getMessage(MultiDiffPanel.class, (String)"MSG_CommitDiff_Tooltip"));
        this.commitButton.setFocusable(false);
        this.controlsToolBar.add(this.commitButton);
        this.cmbDiffTreeFirst.setEnabled(false);
        this.jLabel1.setLabelFor(this.cmbDiffTreeFirst);
        this.jLabel1.setText(NbBundle.getMessage(MultiDiffPanel.class, (String)"MultiDiffPanel.jLabel1.text"));
        this.jLabel1.setToolTipText(NbBundle.getMessage(MultiDiffPanel.class, (String)"MultiDiffPanel.jLabel1.TTtext"));
        this.jLabel2.setText(NbBundle.getMessage(MultiDiffPanel.class, (String)"MultiDiffPanel.jLabel2.text"));
        this.jLabel2.setToolTipText(NbBundle.getMessage(MultiDiffPanel.class, (String)"MultiDiffPanel.jLabel2.TTtext"));
        this.cmbDiffTreeSecond.setEnabled(false);
        GroupLayout treeSelectionPanelLayout = new GroupLayout(this.treeSelectionPanel);
        this.treeSelectionPanel.setLayout(treeSelectionPanelLayout);
        treeSelectionPanelLayout.setHorizontalGroup(treeSelectionPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(treeSelectionPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cmbDiffTreeFirst, 0, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cmbDiffTreeSecond, 0, -1, Short.MAX_VALUE).addContainerGap()));
        treeSelectionPanelLayout.setVerticalGroup(treeSelectionPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(treeSelectionPanelLayout.createSequentialGroup().addGap(0, 0, 0).addGroup(treeSelectionPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.cmbDiffTreeFirst, -2, -1, -2).addComponent(this.jLabel2).addComponent(this.cmbDiffTreeSecond, -2, -1, -2)).addGap(0, 0, 0)));
        this.splitPane.setOrientation(0);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.controlsToolBar, -1, 716, Short.MAX_VALUE).addComponent(this.splitPane).addComponent(this.treeSelectionPanel, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.controlsToolBar, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.treeSelectionPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.splitPane, -1, 276, Short.MAX_VALUE)));
    }

    private void refreshButtonActionPerformed(ActionEvent evt) {
        this.onRefreshButton();
    }

    private class RefreshViewTask
    implements Runnable {
        private RefreshViewTask() {
        }

        @Override
        public void run() {
            MultiDiffPanel.this.refreshSetups();
        }
    }

    private static class SetupsComparator
    implements Comparator<Setup> {
        private final HgUtils.ByImportanceComparator delegate = new HgUtils.ByImportanceComparator();
        private final FileStatusCache cache = Mercurial.getInstance().getFileStatusCache();

        @Override
        public int compare(Setup setup1, Setup setup2) {
            int cmp = this.delegate.compare(this.cache.getStatus(setup1.getBaseFile()), this.cache.getStatus(setup2.getBaseFile()));
            if (cmp == 0) {
                return setup1.getBaseFile().getName().compareToIgnoreCase(setup2.getBaseFile().getName());
            }
            return cmp;
        }
    }

    private class DiffPrepareTask
    implements Runnable,
    Cancellable {
        private final Setup[] prepareSetups;
        private Setup selectedSetup;
        private boolean canceled;

        public DiffPrepareTask(Setup[] prepareSetups) {
            this.prepareSetups = prepareSetups;
            this.selectedSetup = prepareSetups[0];
        }

        @Override
        public void run() {
            DiffNode[] neighbourNodes;
            this.canceled = false;
            IOException exception = null;
            for (DiffNode n : neighbourNodes = this.prepareSetupsToRefresh()) {
                final Setup s = n.getSetup();
                if (this.prepareSetups != MultiDiffPanel.this.setups || Thread.interrupted()) {
                    return;
                }
                if (s.getView() != null) continue;
                try {
                    s.initSources();
                    if (Thread.interrupted() || this.canceled) {
                        return;
                    }
                    StreamSource ss1 = s.getFirstSource();
                    StreamSource ss2 = s.getSecondSource();
                    if (MultiDiffPanel.this.requestedRightLine != -1) {
                        MultiDiffPanel.this.requestedLeftLine = this.getMatchingLine(ss2, ss1, MultiDiffPanel.this.requestedRightLine);
                    }
                    DiffController view = DiffController.createEnhanced((StreamSource)ss1, (StreamSource)ss2);
                    view.addPropertyChangeListener((PropertyChangeListener)MultiDiffPanel.this);
                    if (Thread.interrupted() || this.canceled) {
                        return;
                    }
                    s.setView(view);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            if (DiffPrepareTask.this.prepareSetups != MultiDiffPanel.this.setups) {
                                return;
                            }
                            if (MultiDiffPanel.this.currentSetup == s) {
                                MultiDiffPanel.this.setDiffIndex(s, 0, false);
                            }
                            if (MultiDiffPanel.this.splitPane != null) {
                                MultiDiffPanel.this.updateSplitLocation();
                            }
                        }
                    });
                }
                catch (IOException e) {
                    if (HgUtils.isCanceled(e)) {
                        Logger.getLogger(MultiDiffPanel.class.getName()).log(Level.FINE, null, e);
                        return;
                    }
                    Mercurial.LOG.log(Level.INFO, null, e);
                    if (exception != null) continue;
                    exception = e;
                }
            }
            if (exception != null) {
                HgUtils.notifyException(exception);
            }
        }

        private DiffNode[] prepareSetupsToRefresh() {
            return (DiffNode[])Mutex.EVENT.readAccess((Mutex.Action)new Mutex.Action<DiffNode[]>(){

                public DiffNode[] run() {
                    DiffNode[] diffNodeArray;
                    if (MultiDiffPanel.this.showingFileComponent()) {
                        diffNodeArray = (DiffNode[])MultiDiffPanel.this.getActiveFileComponent().getNeighbouringNodes((Node)DiffPrepareTask.this.selectedSetup.getNode(), 2);
                    } else {
                        DiffNode[] diffNodeArray2 = new DiffNode[1];
                        diffNodeArray = diffNodeArray2;
                        diffNodeArray2[0] = DiffPrepareTask.this.selectedSetup.getNode();
                    }
                    return diffNodeArray;
                }
            });
        }

        private void setSelectedSetup(Setup setup) {
            this.selectedSetup = setup;
        }

        public boolean cancel() {
            this.canceled = true;
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int getMatchingLine(StreamSource ss2, StreamSource ss1, int requestedRightLine) {
            Reader currentReader = null;
            Reader previousReader = null;
            try {
                currentReader = ss2.createReader();
                previousReader = ss1.createReader();
                int n = DiffUtils.getMatchingLine((Reader)currentReader, (Reader)previousReader, (int)requestedRightLine);
                return n;
            }
            catch (IOException ex) {
                int n = -1;
                return n;
            }
            finally {
                if (currentReader != null) {
                    try {
                        currentReader.close();
                    }
                    catch (IOException ex) {}
                }
                if (previousReader != null) {
                    try {
                        previousReader.close();
                    }
                    catch (IOException ex) {}
                }
            }
        }
    }

    private static class HgRevisionCellRenderer
    extends DefaultListCellRenderer {
        private HgRevisionCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            String tooltip = null;
            if (value instanceof HgLogMessage.HgRevision) {
                HgLogMessage.HgRevision rev = (HgLogMessage.HgRevision)value;
                value = rev.toString();
            } else if (value instanceof HgLogMessage) {
                HgLogMessage message = (HgLogMessage)value;
                StringBuilder sb = new StringBuilder(60).append(message.getRevisionNumber());
                StringBuilder labels = new StringBuilder();
                for (String branch : message.getBranches()) {
                    labels.append(branch).append(' ');
                }
                int i$ = 0;
                String[] arr$ = message.getTags();
                int len$ = arr$.length;
                if (i$ < len$) {
                    String tag = arr$[i$];
                    labels.append(tag).append(' ');
                }
                sb.append(" (").append((CharSequence)labels).append(labels.length() == 0 ? "" : "- ").append(message.getCSetShortID().substring(0, 7)).append(")");
                String shortMsg = message.getShortMessage();
                if (!shortMsg.isEmpty()) {
                    sb.append(" - ").append(shortMsg);
                    if (sb.length() > 50) {
                        tooltip = shortMsg;
                        sb.setLength(47);
                        sb.append("...");
                    }
                }
                value = sb.toString();
            } else if (value instanceof String) {
                value = "<html><i>" + value + "</i></html>";
                tooltip = Bundle.MSG_Revision_Select_Tooltip();
            }
            Component comp = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (comp instanceof JComponent) {
                ((JComponent)comp).setToolTipText(tooltip);
            }
            return comp;
        }
    }

    private class RefreshComboTask
    implements Runnable {
        private RefreshComboTask() {
        }

        @Override
        public void run() {
            VCSFileProxy repository = HgUtils.getRootFile(MultiDiffPanel.this.context);
            final ArrayList<Object> modelRight = new ArrayList<Object>(10);
            final ArrayList<Object> modelLeft = new ArrayList<Object>(10);
            modelLeft.add(MultiDiffPanel.this.revisionOriginalLeft);
            if (MultiDiffPanel.this.revisionOriginalLeft != HgLogMessage.HgRevision.BASE) {
                modelLeft.add(HgLogMessage.HgRevision.BASE);
            }
            modelRight.add(MultiDiffPanel.this.revisionOriginalRight);
            if (MultiDiffPanel.this.revisionOriginalRight != HgLogMessage.HgRevision.CURRENT) {
                modelRight.add(HgLogMessage.HgRevision.CURRENT);
            }
            if (MultiDiffPanel.this.revisionOriginalRight != HgLogMessage.HgRevision.BASE) {
                modelRight.add(HgLogMessage.HgRevision.BASE);
            }
            try {
                HgLogMessage[] heads = HgCommand.getHeadRevisionsInfo(repository, false, OutputLogger.getLogger(null));
                Map<String, Collection<HgLogMessage>> branchHeads = HgUtils.sortByBranch(heads);
                for (Map.Entry<String, Collection<HgLogMessage>> e : branchHeads.entrySet()) {
                    for (HgLogMessage msg : e.getValue()) {
                        modelLeft.add(msg);
                        modelRight.add(msg);
                    }
                }
            }
            catch (HgException.HgCommandCanceledException ex) {
            }
            catch (HgException ex) {
                LOG.log(Level.INFO, null, ex);
            }
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    modelLeft.add(REVISION_SELECT_SEP);
                    modelLeft.add(REVISION_SELECT);
                    modelLeft.add(REVISION_SELECT_SEP);
                    modelRight.add(REVISION_SELECT_SEP);
                    modelRight.add(REVISION_SELECT);
                    modelRight.add(REVISION_SELECT_SEP);
                    MultiDiffPanel.this.cmbDiffTreeFirst.setModel(new DefaultComboBoxModel<Object>(modelRight.toArray(new Object[modelRight.size()])));
                    MultiDiffPanel.this.cmbDiffTreeSecond.setModel(new DefaultComboBoxModel<Object>(modelLeft.toArray(new Object[modelLeft.size()])));
                    MultiDiffPanel.this.cmbDiffTreeFirst.setEnabled(true);
                    MultiDiffPanel.this.cmbDiffTreeSecond.setEnabled(true);
                }
            });
        }
    }
}

