/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.remote.ui.merge;

import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.JOptionPane;
import org.netbeans.modules.mercurial.remote.HgException;
import org.netbeans.modules.mercurial.remote.HgProgressSupport;
import org.netbeans.modules.mercurial.remote.Mercurial;
import org.netbeans.modules.mercurial.remote.OutputLogger;
import org.netbeans.modules.mercurial.remote.ui.actions.ContextAction;
import org.netbeans.modules.mercurial.remote.ui.log.HgLogMessage;
import org.netbeans.modules.mercurial.remote.ui.merge.MergeRevisions;
import org.netbeans.modules.mercurial.remote.util.HgCommand;
import org.netbeans.modules.mercurial.remote.util.HgUtils;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.netbeans.modules.versioning.core.spi.VCSContext;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class MergeAction
extends ContextAction {
    private static final Logger LOG = Logger.getLogger(MergeAction.class.getName());

    @Override
    protected boolean enable(Node[] nodes) {
        Set ctxFiles;
        VCSContext context = HgUtils.getCurrentContext(nodes);
        Set set = ctxFiles = context != null ? context.getRootFiles() : null;
        return HgUtils.isFromHgRepository(context) && ctxFiles != null && !ctxFiles.isEmpty();
    }

    @Override
    protected String getBaseName(Node[] nodes) {
        return "CTL_MenuItem_Merge";
    }

    @Override
    protected void performContextAction(Node[] nodes) {
        final VCSContext context = HgUtils.getCurrentContext(nodes);
        VCSFileProxy[] roots = HgUtils.getActionRoots(context);
        if (roots == null || roots.length == 0) {
            return;
        }
        final VCSFileProxy root = Mercurial.getInstance().getRepositoryRoot(roots[0]);
        if (root == null) {
            OutputLogger logger = Mercurial.getInstance().getLogger(Mercurial.MERCURIAL_OUTPUT_TAB_TITLE);
            logger.outputInRed(NbBundle.getMessage(MergeAction.class, (String)"MSG_MERGE_TITLE"));
            logger.outputInRed(NbBundle.getMessage(MergeAction.class, (String)"MSG_MERGE_TITLE_SEP"));
            logger.outputInRed(NbBundle.getMessage(MergeAction.class, (String)"MSG_MERGE_NOT_SUPPORTED_INVIEW_INFO"));
            logger.output("");
            logger.closeLog();
            JOptionPane.showMessageDialog(null, NbBundle.getMessage(MergeAction.class, (String)"MSG_MERGE_NOT_SUPPORTED_INVIEW"), NbBundle.getMessage(MergeAction.class, (String)"MSG_MERGE_NOT_SUPPORTED_INVIEW_TITLE"), 1);
            return;
        }
        RequestProcessor rp = Mercurial.getInstance().getRequestProcessor(root);
        HgProgressSupport support = new HgProgressSupport(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void perform() {
                OutputLogger logger = this.getLogger();
                try {
                    List<String> headList = HgCommand.getHeadRevisions(root);
                    if (headList.size() <= 1) {
                        logger.outputInRed(NbBundle.getMessage(MergeAction.class, (String)"MSG_MERGE_TITLE"));
                        logger.outputInRed(NbBundle.getMessage(MergeAction.class, (String)"MSG_MERGE_TITLE_SEP"));
                        logger.output(NbBundle.getMessage(MergeAction.class, (String)"MSG_NOTHING_TO_MERGE"));
                        logger.outputInRed(NbBundle.getMessage(MergeAction.class, (String)"MSG_MERGE_DONE"));
                        logger.output("");
                        JOptionPane.showMessageDialog(null, NbBundle.getMessage(MergeAction.class, (String)"MSG_NOTHING_TO_MERGE"), NbBundle.getMessage(MergeAction.class, (String)"MSG_MERGE_TITLE"), 1);
                        return;
                    }
                    String revStr = null;
                    MergeRevisions mergeDlg = new MergeRevisions(root, null);
                    if (!mergeDlg.showDialog()) {
                        return;
                    }
                    revStr = mergeDlg.getSelectionRevision();
                    logger.outputInRed(NbBundle.getMessage(MergeAction.class, (String)"MSG_MERGE_TITLE"));
                    logger.outputInRed(NbBundle.getMessage(MergeAction.class, (String)"MSG_MERGE_TITLE_SEP"));
                    MergeAction.doMergeAction(root, revStr, logger);
                    HgUtils.forceStatusRefreshProject(context);
                    logger.output("");
                }
                catch (HgException.HgCommandCanceledException ex) {
                }
                catch (HgException ex) {
                    HgUtils.notifyException(ex);
                }
                finally {
                    logger.closeLog();
                }
            }
        };
        support.start(rp, root, NbBundle.getMessage(MergeAction.class, (String)"MSG_MERGE_PROGRESS"));
    }

    public static List<String> doMergeAction(final VCSFileProxy root, final String revStr, OutputLogger logger) throws HgException {
        List<String> listMerge = HgUtils.runWithoutIndexing(new Callable<List<String>>(){

            @Override
            public List<String> call() throws Exception {
                return HgCommand.doMerge(root, revStr);
            }
        }, root);
        if (listMerge != null && !listMerge.isEmpty()) {
            logger.output(listMerge);
            if (MergeAction.handleMergeOutput(root, listMerge, logger, true)) {
                logger.outputInRed(NbBundle.getMessage(MergeAction.class, (String)"MSG_MERGE_DONE"));
            }
        }
        return listMerge;
    }

    public static boolean handleMergeOutput(VCSFileProxy root, List<String> listMerge, OutputLogger logger, boolean interactive) {
        if (listMerge == null || listMerge.isEmpty()) {
            return true;
        }
        Boolean bConflicts = false;
        Boolean bMergeFailed = false;
        for (String line : listMerge) {
            if (HgCommand.isMergeAbortUncommittedMsg(line)) {
                bMergeFailed = true;
                if (!interactive) break;
                logger.outputInRed(NbBundle.getMessage(MergeAction.class, (String)"MSG_MERGE_FAILED"));
                JOptionPane.showMessageDialog(null, NbBundle.getMessage(MergeAction.class, (String)"MSG_MERGE_UNCOMMITTED"), NbBundle.getMessage(MergeAction.class, (String)"MSG_MERGE_TITLE"), 2);
                break;
            }
            if (HgCommand.isMergeAbortMultipleHeadsMsg(line)) {
                bMergeFailed = true;
                if (!interactive) break;
                logger.outputInRed(NbBundle.getMessage(MergeAction.class, (String)"MSG_MERGE_FAILED"));
                break;
            }
            String filepath = null;
            if (HgCommand.isMergeFailedMsg(line)) {
                bConflicts = true;
                if (line.contains("failed!")) {
                    filepath = line.substring("merging".length(), line.length() - "failed!".length()).trim();
                } else if (line.contains("incomplete!")) {
                    filepath = line.substring("merging".length(), line.lastIndexOf("incomplete!")).trim();
                }
                filepath = root.getPath() + "/" + filepath;
            } else if (HgCommand.isConflictDetectedInMsg(line)) {
                bConflicts = true;
                filepath = line.substring("conflicts detected in ".length());
            }
            if (filepath != null) {
                LOG.log(Level.FINER, "File {0} in conflict", filepath);
                if (interactive) {
                    logger.outputInRed(NbBundle.getMessage(MergeAction.class, (String)"MSG_MERGE_CONFLICT", (Object)filepath));
                }
            }
            if (!HgCommand.isMergeUnavailableMsg(line)) continue;
            bMergeFailed = true;
            if (!interactive) continue;
            JOptionPane.showMessageDialog(null, NbBundle.getMessage(MergeAction.class, (String)"MSG_MERGE_UNAVAILABLE"), NbBundle.getMessage(MergeAction.class, (String)"MSG_MERGE_TITLE"), 2);
            logger.outputInRed(NbBundle.getMessage(MergeAction.class, (String)"MSG_MERGE_INFO"));
            logger.outputLink(NbBundle.getMessage(MergeAction.class, (String)"MSG_MERGE_INFO_URL"));
        }
        if (bConflicts.booleanValue()) {
            LOG.log(Level.FINER, "Conflicts detected: {0}", root);
            if (interactive) {
                logger.outputInRed(NbBundle.getMessage(MergeAction.class, (String)"MSG_MERGE_DONE_CONFLICTS"));
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(MergeAction.class, (String)"MSG_Merge.ConflictsCreated")));
            }
        }
        return bMergeFailed == false && bConflicts == false;
    }

    public static void printMergeWarning(List<String> list, OutputLogger logger) {
        if (list == null || list.isEmpty() || list.size() <= 1) {
            return;
        }
        if (list.size() == 2) {
            logger.outputInRed(NbBundle.getMessage(MergeAction.class, (String)"MSG_MERGE_WARN_NEEDED", list));
            logger.outputInRed(NbBundle.getMessage(MergeAction.class, (String)"MSG_MERGE_DO_NEEDED"));
        } else {
            logger.outputInRed(NbBundle.getMessage(MergeAction.class, (String)"MSG_MERGE_WARN_MULTIPLE_HEADS", (Object)list.size(), list));
            logger.outputInRed(NbBundle.getMessage(MergeAction.class, (String)"MSG_MERGE_DONE_MULTIPLE_HEADS"));
        }
    }

    public static void displayMergeWarning(Map<String, Collection<HgLogMessage>> branchHeads, OutputLogger logger, boolean warnInDialog) {
        boolean mulitpleHeads = false;
        for (Map.Entry<String, Collection<HgLogMessage>> e : branchHeads.entrySet()) {
            if (e.getValue().size() <= 1) continue;
            mulitpleHeads = true;
            break;
        }
        if (!mulitpleHeads) {
            return;
        }
        Action a = logger.getOpenOutputAction();
        if (warnInDialog && a != null && JOptionPane.showConfirmDialog(null, NbBundle.getMessage(MergeAction.class, (String)"MSG_MERGE_NEEDED_BRANCHES"), NbBundle.getMessage(MergeAction.class, (String)"TITLE_MERGE_NEEDED_BRANCHES"), 0, 2) == 0) {
            a.actionPerformed(new ActionEvent(MergeAction.class, 1001, null));
        }
        logger.outputInRed(NbBundle.getMessage(MergeAction.class, (String)"MSG_MERGE_WARN_NEEDED_BRANCHES"));
        logger.outputInRed(NbBundle.getMessage(MergeAction.class, (String)"MSG_MERGE_DO_NEEDED_BRANCHES"));
        for (Map.Entry<String, Collection<HgLogMessage>> e : branchHeads.entrySet()) {
            Collection<HgLogMessage> heads = e.getValue();
            if (heads.size() <= 1) continue;
            logger.outputInRed(NbBundle.getMessage(MergeAction.class, (String)"MSG_MERGE_WARN_NEEDED_IN_BRANCH", (Object)e.getKey()));
            for (HgLogMessage head : heads) {
                HgUtils.logHgLog(head, logger);
            }
        }
    }
}

