/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.remote.ui.wizards;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URISyntaxException;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.mercurial.remote.ui.repository.HgURL;
import org.netbeans.modules.mercurial.remote.ui.repository.Repository;
import org.netbeans.modules.mercurial.remote.ui.wizards.ClonePathsPanel;
import org.netbeans.modules.mercurial.remote.util.HgUtils;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotificationLineSupport;
import org.openide.NotifyDescriptor;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class ClonePathsWizardPanel
implements WizardDescriptor.Panel {
    private ClonePathsPanel component;
    private HgURL repositoryOrig;
    private Listener listener;
    private HgURL pullUrl;
    private HgURL pushUrl;
    private HgURL defaultUrl;
    private String defaultUrlString;
    private VCSFileProxy root;

    public Component getComponent() {
        if (this.component == null) {
            this.component = new ClonePathsPanel();
            this.initInteraction();
        }
        return this.component;
    }

    private void initInteraction() {
        this.listener = new Listener();
        this.component.defaultValuesButton.addActionListener(this.listener);
        this.component.changePullPathButton.addActionListener(this.listener);
        this.component.changePushPathButton.addActionListener(this.listener);
    }

    private HgURL changeUrl(String titleMsgKey) {
        int repoModeMask = 36;
        String title = ClonePathsWizardPanel.getMessage(titleMsgKey);
        final JButton set = new JButton();
        JButton clear = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)set, (String)ClonePathsWizardPanel.getMessage("changePullPushPath.Set"));
        Mnemonics.setLocalizedText((AbstractButton)clear, (String)ClonePathsWizardPanel.getMessage("changePullPushPath.Clear"));
        final Repository repository = new Repository(repoModeMask, title, true, this.root);
        set.setEnabled(repository.isValid());
        clear.setDefaultCapable(false);
        final DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)HgUtils.addContainerBorder(repository.getPanel()), title, true, new Object[]{set, clear, NotifyDescriptor.CANCEL_OPTION}, (Object)set, 0, new HelpCtx(ClonePathsWizardPanel.class.getName() + ".change"), null);
        dialogDescriptor.setClosingOptions(new Object[]{clear, NotifyDescriptor.CANCEL_OPTION});
        final NotificationLineSupport notificationLineSupport = dialogDescriptor.createNotificationLineSupport();
        class RepositoryChangeListener
        implements ChangeListener,
        ActionListener {
            private Dialog dialog;

            RepositoryChangeListener() {
            }

            public void setDialog(Dialog dialog) {
                this.dialog = dialog;
            }

            @Override
            public void stateChanged(ChangeEvent e) {
                assert (e.getSource() == repository);
                boolean isValid = repository.isValid();
                dialogDescriptor.setValid(isValid);
                set.setEnabled(isValid);
                if (isValid) {
                    notificationLineSupport.clearMessages();
                } else {
                    String errMsg = repository.getMessage();
                    if (errMsg != null && errMsg.length() != 0) {
                        notificationLineSupport.setErrorMessage(errMsg);
                    } else {
                        notificationLineSupport.clearMessages();
                    }
                }
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getSource() != set) {
                    return;
                }
                try {
                    dialogDescriptor.setValue((Object)repository.getUrl());
                    this.dialog.setVisible(false);
                    this.dialog.dispose();
                }
                catch (URISyntaxException ex) {
                    repository.setInvalid();
                    notificationLineSupport.setErrorMessage(ex.getMessage());
                }
            }
        }
        RepositoryChangeListener optionListener = new RepositoryChangeListener();
        repository.addChangeListener(optionListener);
        dialogDescriptor.setButtonListener((ActionListener)optionListener);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        optionListener.setDialog(dialog);
        dialog.pack();
        dialog.setVisible(true);
        Object selectedValue = dialogDescriptor.getValue();
        assert (selectedValue instanceof HgURL || selectedValue == clear || selectedValue == NotifyDescriptor.CANCEL_OPTION || selectedValue == NotifyDescriptor.CLOSED_OPTION);
        if (selectedValue instanceof HgURL) {
            return (HgURL)selectedValue;
        }
        if (selectedValue == clear) {
            return HgURL.NO_URL;
        }
        return null;
    }

    public boolean isValid() {
        return true;
    }

    public HelpCtx getHelp() {
        return new HelpCtx(ClonePathsWizardPanel.class);
    }

    public final void addChangeListener(ChangeListener l) {
    }

    public final void removeChangeListener(ChangeListener l) {
    }

    private void setDefaultValues() {
        this.setDefaultValues(true, true);
    }

    private void setDefaultValues(boolean pullPath, boolean pushPath) {
        if (pullPath) {
            this.component.defaultPullPathField.setText(this.getDefaultPath());
            this.pullUrl = this.repositoryOrig;
        }
        if (pushPath) {
            this.component.defaultPushPathField.setText(this.getDefaultPath());
            this.pushUrl = this.repositoryOrig;
        }
    }

    private String getDefaultPath() {
        if (this.defaultUrlString == null) {
            this.defaultUrlString = this.repositoryOrig.toHgCommandUrlStringWithoutUserInfo();
        }
        return this.defaultUrlString;
    }

    public void readSettings(Object settings) {
        assert (settings instanceof WizardDescriptor);
        this.defaultUrl = (HgURL)((WizardDescriptor)settings).getProperty("repository");
        this.root = (VCSFileProxy)((WizardDescriptor)settings).getProperty("root");
        HgURL repository = this.defaultUrl;
        boolean repoistoryChanged = !repository.equals(this.repositoryOrig);
        this.repositoryOrig = repository;
        this.defaultUrlString = null;
        boolean resetPullPath = repoistoryChanged || this.pullUrl == null;
        boolean resetPushPath = repoistoryChanged || this.pushUrl == null;
        this.setDefaultValues(resetPullPath, resetPushPath);
    }

    public void storeSettings(Object settings) {
        if (settings instanceof WizardDescriptor) {
            ((WizardDescriptor)settings).putProperty("defaultPullPath", (Object)this.pullUrl);
            ((WizardDescriptor)settings).putProperty("defaultPushPath", (Object)this.pushUrl);
        }
    }

    private static String getMessage(String msgKey) {
        return NbBundle.getMessage(ClonePathsWizardPanel.class, (String)msgKey);
    }

    private final class Listener
    implements ActionListener {
        private Listener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object source = e.getSource();
            if (source == ((ClonePathsWizardPanel)ClonePathsWizardPanel.this).component.defaultValuesButton) {
                ClonePathsWizardPanel.this.setDefaultValues();
            } else if (source == ((ClonePathsWizardPanel)ClonePathsWizardPanel.this).component.changePullPathButton) {
                HgURL changedUrl = ClonePathsWizardPanel.this.changeUrl("changePullPath.Title");
                if (changedUrl != null) {
                    ((ClonePathsWizardPanel)ClonePathsWizardPanel.this).component.defaultPullPathField.setText(changedUrl.toHgCommandStringWithMaskedPassword());
                    ClonePathsWizardPanel.this.pullUrl = changedUrl != HgURL.NO_URL ? changedUrl : null;
                }
            } else if (source == ((ClonePathsWizardPanel)ClonePathsWizardPanel.this).component.changePushPathButton) {
                HgURL changedUrl = ClonePathsWizardPanel.this.changeUrl("changePushPath.Title");
                if (changedUrl != null) {
                    ((ClonePathsWizardPanel)ClonePathsWizardPanel.this).component.defaultPushPathField.setText(changedUrl.toHgCommandStringWithMaskedPassword());
                    ClonePathsWizardPanel.this.pushUrl = changedUrl != HgURL.NO_URL ? changedUrl : null;
                }
            } else assert (false);
        }
    }
}

