/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.v8debug.breakpoints;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.lib.v8debug.V8Arguments;
import org.netbeans.lib.v8debug.V8Breakpoint;
import org.netbeans.lib.v8debug.V8Command;
import org.netbeans.lib.v8debug.commands.ChangeBreakpoint;
import org.netbeans.modules.javascript.v8debug.V8Debugger;
import org.netbeans.modules.javascript.v8debug.breakpoints.BreakpointsHandler;
import org.netbeans.modules.javascript2.debug.breakpoints.JSBreakpointStatus;
import org.netbeans.modules.javascript2.debug.breakpoints.JSLineBreakpoint;
import org.openide.util.WeakListeners;

public final class SubmittedBreakpoint {
    private static final Logger LOG = Logger.getLogger(SubmittedBreakpoint.class.getName());
    private final JSLineBreakpoint breakpoint;
    private final long id;
    private final V8Debugger dbg;
    private final PropertyChangeListener bpChangeListener;
    private final PropertyChangeListener addedChangeListener;

    SubmittedBreakpoint(JSLineBreakpoint breakpoint, long id, V8Breakpoint.ActualLocation[] actualLocations, V8Debugger dbg) {
        this.breakpoint = breakpoint;
        this.id = id;
        this.dbg = dbg;
        LOG.log(Level.FINE, "SubmittedBreakpoint({0}, {1})", new Object[]{breakpoint, id});
        this.adjustLocation(actualLocations);
        LOG.log(Level.FINE, "  adjusted BP => {0}", breakpoint);
        this.bpChangeListener = new BPChangeListener();
        this.addedChangeListener = WeakListeners.propertyChange((PropertyChangeListener)this.bpChangeListener, (Object)breakpoint);
        breakpoint.addPropertyChangeListener(this.addedChangeListener);
        JSBreakpointStatus.setValid((JSLineBreakpoint)breakpoint, null);
    }

    public JSLineBreakpoint getBreakpoint() {
        return this.breakpoint;
    }

    public long getId() {
        return this.id;
    }

    private void adjustLocation(V8Breakpoint.ActualLocation[] actualLocations) {
        if (actualLocations != null && actualLocations.length > 0) {
            long line = actualLocations[0].getLine();
            this.breakpoint.setLine((int)line);
        }
    }

    void updatePosition(long line, long column) {
        this.breakpoint.setLine((int)line);
    }

    void notifyDestroyed() {
        this.breakpoint.removePropertyChangeListener(this.addedChangeListener);
        JSBreakpointStatus.resetValidity((JSLineBreakpoint)this.breakpoint);
    }

    private final class BPChangeListener
    implements PropertyChangeListener {
        private BPChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            switch (evt.getPropertyName()) {
                case "enabled": 
                case "condition": {
                    ChangeBreakpoint.Arguments cbargs = BreakpointsHandler.createChangeRequestArguments(SubmittedBreakpoint.this);
                    SubmittedBreakpoint.this.dbg.sendCommandRequest(V8Command.Changebreakpoint, (V8Arguments)cbargs);
                }
            }
        }
    }
}

