/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.bower.ui.libraries;

import java.awt.EventQueue;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.netbeans.api.project.Project;
import org.netbeans.modules.javascript.bower.exec.BowerExecutable;
import org.netbeans.modules.javascript.bower.ui.libraries.Library;
import org.openide.util.RequestProcessor;

public class LibraryProvider {
    private static final Map<Project, LibraryProvider> providers = Collections.synchronizedMap(new WeakHashMap());
    private static final RequestProcessor RP = new RequestProcessor(LibraryProvider.class.getName(), 3);
    private final Project project;
    private final Map<String, WeakReference<Library[]>> searchCache = Collections.synchronizedMap(new HashMap());
    private final Map<String, WeakReference<Library>> detailCache = Collections.synchronizedMap(new HashMap());
    private final PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

    private LibraryProvider(Project project) {
        this.project = project;
    }

    public static synchronized LibraryProvider forProject(Project project) {
        LibraryProvider provider = providers.get(project);
        if (provider == null) {
            provider = new LibraryProvider(project);
            providers.put(project, provider);
        }
        return provider;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    public Library[] findLibraries(String searchTerm) {
        WeakReference<Library[]> reference = this.searchCache.get(searchTerm);
        Library[] result = null;
        if (reference != null) {
            result = (Library[])reference.get();
        }
        if (result == null) {
            SearchTask task = new SearchTask(searchTerm);
            RP.post((Runnable)task);
        }
        return result;
    }

    public Library libraryDetails(String libraryName, boolean cachedOnly) {
        WeakReference<Library> reference = this.detailCache.get(libraryName);
        Library result = null;
        if (reference != null) {
            result = (Library)reference.get();
        }
        if (result == null && !cachedOnly) {
            JSONObject details;
            assert (!EventQueue.isDispatchThread());
            BowerExecutable executable = BowerExecutable.getDefault(this.project, false);
            if (executable != null && (details = executable.info(libraryName)) != null) {
                result = this.parseLibraryDetails(details);
                reference = new WeakReference<Library>(result);
                this.detailCache.put(libraryName, reference);
            }
        }
        return result;
    }

    public Map<String, String> installedLibraries() {
        JSONObject json;
        HashMap<String, String> result = null;
        BowerExecutable executable = BowerExecutable.getDefault(this.project, false);
        if (executable != null && (json = executable.list()) != null) {
            result = new HashMap<String, String>();
            JSONObject dependencies = (JSONObject)json.get((Object)"dependencies");
            if (dependencies != null) {
                for (Object key : dependencies.keySet()) {
                    JSONObject libraryInfo;
                    JSONObject metaInfo;
                    Object value = dependencies.get(key);
                    if (!(value instanceof JSONObject) || (metaInfo = (JSONObject)(libraryInfo = (JSONObject)value).get((Object)"pkgMeta")) == null) continue;
                    String versionName = (String)metaInfo.get((Object)"version");
                    if (versionName == null) {
                        versionName = "\t";
                    }
                    String libraryName = key.toString();
                    result.put(libraryName, versionName);
                }
            }
        }
        return result;
    }

    private Library parseLibraryDetails(JSONObject info) {
        Library.Version[] versions;
        String name = (String)info.get((Object)"name");
        Library library = new Library(name);
        String latestVersionName = null;
        JSONObject latestSection = (JSONObject)info.get((Object)"latest");
        if (latestSection != null) {
            latestVersionName = (String)latestSection.get((Object)"version");
            String description = (String)latestSection.get((Object)"description");
            library.setDescription(description);
            String homepage = (String)latestSection.get((Object)"homepage");
            library.setHomePage(homepage);
            JSONArray keywordsArray = (JSONArray)latestSection.get((Object)"keywords");
            if (keywordsArray != null) {
                String[] keywords = new String[keywordsArray.size()];
                for (int i = 0; i < keywordsArray.size(); ++i) {
                    keywords[i] = (String)keywordsArray.get(i);
                }
                library.setKeywords(keywords);
            }
        }
        Library.Version latestVersion = null;
        JSONArray versionArray = (JSONArray)info.get((Object)"versions");
        if (versionArray != null && versionArray.size() != 0) {
            versions = new Library.Version[versionArray.size()];
            for (int i = 0; i < versionArray.size(); ++i) {
                String versionName = (String)versionArray.get(i);
                Library.Version version = new Library.Version(library, versionName);
                if (versionName.equals(latestVersionName)) {
                    latestVersion = version;
                }
                versions[i] = version;
            }
        } else {
            versions = new Library.Version[]{new Library.Version(library, "\t")};
        }
        library.setVersions(versions);
        library.setLatestVersion(latestVersion == null ? versions[0] : latestVersion);
        return library;
    }

    void updateCache(String searchTerm, Library[] libraries) {
        if (libraries != null) {
            WeakReference<Library[]> reference = new WeakReference<Library[]>(libraries);
            this.searchCache.put(searchTerm, reference);
        }
        this.propertyChangeSupport.firePropertyChange(searchTerm, null, libraries);
    }

    private class SearchTask
    implements Runnable {
        private final String searchTerm;

        SearchTask(String searchTerm) {
            this.searchTerm = searchTerm;
        }

        @Override
        public void run() {
            BowerExecutable executable = BowerExecutable.getDefault(LibraryProvider.this.project, false);
            if (executable != null) {
                JSONArray result = executable.search(this.searchTerm);
                Library[] libraries = result == null ? null : this.parseSearchResult(result);
                LibraryProvider.this.updateCache(this.searchTerm, libraries);
            }
        }

        private Library[] parseSearchResult(JSONArray searchResult) {
            int size = searchResult.size();
            Library[] libraries = new Library[size];
            for (int i = 0; i < size; ++i) {
                JSONObject libraryInfo = (JSONObject)searchResult.get(i);
                String libraryName = (String)libraryInfo.get((Object)"name");
                Library library = new Library(libraryName);
                library.setPopularity(size - i);
                libraries[i] = library;
            }
            return libraries;
        }
    }
}

