/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui.wizard.common;

import java.awt.Component;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.HashSet;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.swing.event.ChangeListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.apisupport.project.api.BasicVisualPanel;
import org.netbeans.modules.apisupport.project.api.BasicWizardPanel;
import org.netbeans.modules.apisupport.project.api.Util;
import org.netbeans.modules.apisupport.project.spi.NbModuleProvider;
import org.netbeans.modules.apisupport.project.ui.wizard.common.Bundle;
import org.netbeans.modules.apisupport.project.ui.wizard.common.CreatedModifiedFiles;
import org.netbeans.modules.editor.indent.api.Reformat;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.ErrorManager;
import org.openide.WizardDescriptor;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.HelpCtx;

public abstract class BasicWizardIterator
implements WizardDescriptor.AsynchronousInstantiatingIterator<WizardDescriptor> {
    private int position = 0;
    private PrivateWizardPanel[] wizardPanels;

    protected BasicWizardIterator() {
    }

    protected abstract Panel[] createPanels(WizardDescriptor var1);

    public void initialize(WizardDescriptor wiz) {
        Panel[] panelArray;
        boolean isValidPrj;
        String[] beforeSteps = null;
        Object prop = wiz.getProperty("WizardPanel_contentData");
        if (prop != null && prop instanceof String[]) {
            beforeSteps = (String[])prop;
        }
        this.position = 0;
        Project tmpProject = Templates.getProject((WizardDescriptor)wiz);
        boolean bl = isValidPrj = tmpProject != null && tmpProject.getLookup().lookup(NbModuleProvider.class) != null;
        if (isValidPrj) {
            panelArray = this.createPanels(wiz);
        } else {
            Panel[] panelArray2 = new Panel[1];
            panelArray = panelArray2;
            panelArray2[0] = new InvalidProjectPanel(wiz);
        }
        Panel[] panels = panelArray;
        String[] steps = BasicWizardIterator.createSteps(beforeSteps, panels);
        this.wizardPanels = new PrivateWizardPanel[panels.length];
        for (int i = 0; i < panels.length; ++i) {
            this.wizardPanels[i] = new PrivateWizardPanel(panels[i], steps, i);
        }
    }

    private static String[] createSteps(String[] before, Panel[] panels) {
        assert (panels != null);
        int diff = 0;
        if (before == null) {
            before = new String[]{};
        } else if (before.length > 0) {
            diff = "...".equals(before[before.length - 1]) ? 1 : 0;
        }
        String[] res = new String[before.length - diff + panels.length];
        for (int i = 0; i < res.length; ++i) {
            res[i] = i < before.length - diff ? before[i] : panels[i - before.length + diff].getPanelName();
        }
        return res;
    }

    public void uninitialize(WizardDescriptor wiz) {
        this.wizardPanels = null;
    }

    public String name() {
        return ((PrivateWizardPanel)this.current()).getPanel().getPanelName();
    }

    public boolean hasNext() {
        return this.position < this.wizardPanels.length - 1;
    }

    public boolean hasPrevious() {
        return this.position > 0;
    }

    public void nextPanel() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.position;
    }

    public void previousPanel() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --this.position;
    }

    public WizardDescriptor.Panel<WizardDescriptor> current() {
        return this.wizardPanels[this.position];
    }

    public final void addChangeListener(ChangeListener l) {
    }

    public final void removeChangeListener(ChangeListener l) {
    }

    public static Set<FileObject> getCreatedFiles(CreatedModifiedFiles cmf, Project project) throws IOException {
        HashSet<DataObject> toBeShown = new HashSet<DataObject>();
        HashSet<FileObject> set = new HashSet<FileObject>();
        for (String path : cmf.getCreatedPaths()) {
            FileObject fo = project.getProjectDirectory().getFileObject(path);
            assert (fo != null) : path;
            BasicWizardIterator.formatFile(fo);
            DataObject dObj = DataObject.find((FileObject)fo);
            if (dObj == null || toBeShown.size() >= 10 || !toBeShown.add(dObj)) continue;
            set.add(fo);
        }
        return set;
    }

    private static BaseDocument getDocument(FileObject fo) throws DataObjectNotFoundException, IOException {
        EditorCookie editor;
        BaseDocument doc = null;
        DataObject dObj = DataObject.find((FileObject)fo);
        if (dObj != null && (editor = (EditorCookie)dObj.getLookup().lookup(EditorCookie.class)) != null) {
            doc = (BaseDocument)editor.openDocument();
        }
        return doc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void formatFile(FileObject fo) {
        assert (fo != null);
        try {
            final BaseDocument doc = BasicWizardIterator.getDocument(fo);
            if (doc == null) {
                return;
            }
            final Reformat reformat = Reformat.get((Document)doc);
            reformat.lock();
            try {
                doc.runAtomic(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            reformat.reformat(0, doc.getLength());
                        }
                        catch (BadLocationException x) {
                            throw new RuntimeException(x);
                        }
                    }
                });
            }
            finally {
                reformat.unlock();
            }
            try {
                ((EditorCookie)DataObject.find((FileObject)fo).getLookup().lookup(EditorCookie.class)).saveDocument();
            }
            catch (IOException e) {
                Util.err.notify(1, (Throwable)e);
            }
        }
        catch (Exception ex) {
            ErrorManager.getDefault().log(16, "Cannot reformat the file: " + fo.getPath());
        }
    }

    private static final class PrivateWizardPanel
    extends BasicWizardPanel {
        private Panel panel;

        PrivateWizardPanel(Panel panel, String[] allSteps, int stepIndex) {
            super(panel.getSettings());
            panel.addPropertyChangeListener((PropertyChangeListener)((Object)this));
            panel.setName(panel.getPanelName());
            this.panel = panel;
            panel.putClientProperty("WizardPanel_contentSelectedIndex", new Integer(stepIndex));
            panel.putClientProperty("WizardPanel_contentData", allSteps);
        }

        private Panel getPanel() {
            return this.panel;
        }

        public Component getComponent() {
            return this.getPanel();
        }

        public void storeSettings(WizardDescriptor wiz) {
            if (WizardDescriptor.NEXT_OPTION.equals(wiz.getValue()) || WizardDescriptor.FINISH_OPTION.equals(wiz.getValue())) {
                this.panel.storeToDataModel();
            }
            wiz.putProperty("NewFileWizard_Title", null);
        }

        public void readSettings(WizardDescriptor wiz) {
            Object substitute = this.getPanel().getClientProperty("NewFileWizard_Title");
            if (substitute != null) {
                wiz.putProperty("NewFileWizard_Title", substitute);
            }
            if (WizardDescriptor.NEXT_OPTION.equals(wiz.getValue()) || wiz.getValue() == null) {
                this.panel.readFromDataModel();
            }
        }

        public HelpCtx getHelp() {
            return this.getPanel().getHelp();
        }
    }

    public static class InvalidProjectPanel
    extends Panel {
        public InvalidProjectPanel(WizardDescriptor wiz) {
            super(wiz);
            this.setError(Bundle.LBL_InvalidProjectMsg());
        }

        @Override
        protected String getPanelName() {
            return Bundle.LBL_InvalidProject();
        }

        @Override
        protected HelpCtx getHelp() {
            return new HelpCtx(InvalidProjectPanel.class);
        }

        @Override
        protected void readFromDataModel() {
        }

        @Override
        protected void storeToDataModel() {
        }
    }

    public static class BasicDataModel {
        private Project project;
        private NbModuleProvider module;
        private SourceGroup sourceRootGroup;
        private String packageName;

        public BasicDataModel(WizardDescriptor wiz) {
            Project tmpProject = Templates.getProject((WizardDescriptor)wiz);
            if (tmpProject == null) {
                throw new IllegalArgumentException();
            }
            this.module = (NbModuleProvider)tmpProject.getLookup().lookup(NbModuleProvider.class);
            if (this.module == null) {
                throw new IllegalArgumentException(tmpProject.getClass().toString());
            }
            this.project = tmpProject;
            FileObject fo = Templates.getTargetFolder((WizardDescriptor)wiz);
            if (fo != null) {
                Sources srcs = ProjectUtils.getSources((Project)this.project);
                SourceGroup[] grps = srcs.getSourceGroups("java");
                for (int i = 0; i < grps.length; ++i) {
                    if (!FileUtil.isParentOf((FileObject)grps[i].getRootFolder(), (FileObject)fo)) continue;
                    String relPath = FileUtil.getRelativePath((FileObject)grps[i].getRootFolder(), (FileObject)fo);
                    relPath = relPath.replace('/', '.');
                    this.setPackageName(relPath);
                    break;
                }
            }
        }

        public Project getProject() {
            return this.project;
        }

        public NbModuleProvider getModuleInfo() {
            return this.module;
        }

        public String getPackageName() {
            return this.packageName;
        }

        public void setPackageName(String packageName) {
            this.packageName = packageName;
        }

        public SourceGroup getSourceRootGroup() {
            if (this.sourceRootGroup == null) {
                FileObject tempSrcRoot = this.getModuleInfo().getSourceDirectory();
                assert (tempSrcRoot != null);
                Sources sources = ProjectUtils.getSources((Project)this.project);
                SourceGroup[] groups = sources.getSourceGroups("java");
                for (int i = 0; this.sourceRootGroup == null && i < groups.length; ++i) {
                    if (!groups[i].getRootFolder().equals(tempSrcRoot)) continue;
                    this.sourceRootGroup = groups[i];
                }
            }
            return this.sourceRootGroup;
        }

        public String getDefaultPackagePath(String fileName, boolean resource) {
            return this.getDefaultPackagePath(fileName, resource, false);
        }

        public String getDefaultPackagePath(String fileName, boolean resource, boolean inTests) {
            if (inTests) {
                String path = resource ? this.getModuleInfo().getResourceDirectoryPath(true) : this.getModuleInfo().getTestSourceDirectoryPath();
                return path + '/' + this.getPackageName().replace('.', '/') + '/' + fileName;
            }
            return (resource ? this.getModuleInfo().getResourceDirectoryPath(inTests) : this.getModuleInfo().getSourceDirectoryPath()) + '/' + this.getPackageName().replace('.', '/') + '/' + fileName;
        }

        public String addCreateIconOperation(CreatedModifiedFiles cmf, @NonNull FileObject originalIcon) {
            String relativeIconPath = null;
            if (!FileUtil.isParentOf((FileObject)Util.getResourceDirectory((Project)this.getProject()), (FileObject)originalIcon)) {
                String iconPath = this.getDefaultPackagePath(originalIcon.getNameExt(), true);
                cmf.add(cmf.createFile(iconPath, originalIcon));
                relativeIconPath = this.getPackageName().replace('.', '/') + '/' + originalIcon.getNameExt();
            } else {
                relativeIconPath = FileUtil.getRelativePath((FileObject)Util.getResourceDirectory((Project)this.getProject()), (FileObject)originalIcon);
            }
            return relativeIconPath;
        }
    }

    public static abstract class Panel
    extends BasicVisualPanel {
        protected Panel(WizardDescriptor wiz) {
            super(wiz);
        }

        protected abstract String getPanelName();

        protected abstract void storeToDataModel();

        protected abstract void readFromDataModel();

        protected abstract HelpCtx getHelp();
    }
}

