/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.j2ee;

import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.lib.profiler.client.ClientUtils;
import org.netbeans.modules.j2ee.deployment.devmodules.api.JSPServletFinder;
import org.netbeans.modules.j2ee.spi.ejbjar.EarProvider;
import org.netbeans.modules.profiler.api.java.JavaProfilerSource;
import org.netbeans.modules.profiler.j2ee.Bundle;
import org.netbeans.modules.profiler.nbimpl.project.ProjectUtilities;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class WebProjectUtils {
    private static final Logger LOGGER = Logger.getLogger(WebProjectUtils.class.getName());
    private static final Map<ClientUtils.SourceCodeSelection, String> jspClass2NameMap = new HashMap<ClientUtils.SourceCodeSelection, String>();
    private static final String[][] jspServletMethods = new String[][]{{"_jspService", "(Ljavax/servlet/http/HttpServletRequest;Ljavax/servlet/http/HttpServletResponse;)V"}};

    public static Document getDeploymentDescriptorDocument(FileObject deploymentDescriptorFile) {
        Document deploymentDescriptorDocument = null;
        try {
            DocumentBuilderFactory dbfactory = DocumentBuilderFactory.newInstance();
            dbfactory.setValidating(false);
            DocumentBuilder builder = dbfactory.newDocumentBuilder();
            builder.setEntityResolver(new EntityResolver(){

                @Override
                public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                    StringReader reader = new StringReader("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
                    InputSource source = new InputSource(reader);
                    source.setPublicId(publicId);
                    source.setSystemId(systemId);
                    return source;
                }
            });
            deploymentDescriptorDocument = builder.parse(FileUtil.toFile((FileObject)deploymentDescriptorFile));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return deploymentDescriptorDocument;
    }

    public static Collection<Document> getDeploymentDescriptorDocuments(Project project, boolean subprojects) {
        ArrayList<Document> documents = new ArrayList<Document>();
        for (FileObject ddFile : WebProjectUtils.getDeploymentDescriptorFileObjects(project, subprojects)) {
            Document d = WebProjectUtils.getDeploymentDescriptorDocument(ddFile);
            if (d == null) continue;
            documents.add(d);
        }
        return documents;
    }

    public static Collection<FileObject> getDeploymentDescriptorFileObjects(Project project, boolean subprojects) {
        ArrayList<FileObject> descriptors = new ArrayList<FileObject>();
        for (WebModule wm : WebProjectUtils.getWebModules(project, subprojects)) {
            FileObject d = wm.getDeploymentDescriptor();
            if (d == null) continue;
            descriptors.add(d);
        }
        return descriptors;
    }

    public static Collection<FileObject> getDocumentBaseFileObjects(Project project, boolean subprojects) {
        ArrayList<FileObject> basefos = new ArrayList<FileObject>();
        for (WebModule wm : WebProjectUtils.getWebModules(project, subprojects)) {
            FileObject d = wm.getDocumentBase();
            if (d == null) continue;
            basefos.add(d);
        }
        return basefos;
    }

    public static Collection<File> getDocumentBaseFiles(Project project, boolean subprojects) {
        ArrayList<File> basefiles = new ArrayList<File>();
        for (FileObject basefo : WebProjectUtils.getDocumentBaseFileObjects(project, subprojects)) {
            basefiles.add(FileUtil.toFile((FileObject)basefo));
        }
        return basefiles;
    }

    public static boolean isWebProject(Lookup.Provider p) {
        assert (p != null);
        return p.getLookup().lookup(WebModule.class) != null;
    }

    public static ArrayList[] getFilterClasses(Document deploymentDescriptorDocument) {
        int i;
        ArrayList<String> mappedFilters = new ArrayList<String>();
        ArrayList<String> notMappedFilters = new ArrayList<String>();
        NodeList filtersList = WebProjectUtils.getFilters(deploymentDescriptorDocument);
        NodeList filterMappingsList = WebProjectUtils.getFilterMappings(deploymentDescriptorDocument);
        HashSet<String> mappedFilterNames = new HashSet<String>();
        for (i = 0; i < filterMappingsList.getLength(); ++i) {
            String mappedFilterName = WebProjectUtils.getElementContent((Element)filterMappingsList.item(i), "filter-name");
            if (mappedFilterName == null || mappedFilterNames.contains(mappedFilterName)) continue;
            mappedFilterNames.add(mappedFilterName);
        }
        for (i = 0; i < filtersList.getLength(); ++i) {
            String filterName = WebProjectUtils.getElementContent((Element)filtersList.item(i), "filter-name");
            String filterClassName = WebProjectUtils.getElementContent((Element)filtersList.item(i), "filter-class");
            if (filterName != null && filterClassName != null && mappedFilterNames.contains(filterName)) {
                if (mappedFilters.contains(filterClassName)) continue;
                mappedFilters.add(filterClassName);
                continue;
            }
            if (notMappedFilters.contains(filterClassName)) continue;
            notMappedFilters.add(filterClassName);
        }
        return new ArrayList[]{mappedFilters, notMappedFilters};
    }

    public static NodeList getFilterMappings(Document deploymentDescriptorDocument) {
        return deploymentDescriptorDocument.getElementsByTagName("filter-mapping");
    }

    public static NodeList getFilters(Document deploymentDescriptorDocument) {
        return deploymentDescriptorDocument.getElementsByTagName("filter");
    }

    public static boolean isHttpServlet(FileObject fo) {
        JavaProfilerSource src = JavaProfilerSource.createFrom((FileObject)fo);
        return src != null && src.isInstanceOf("javax.servlet.http.HttpServlet");
    }

    public static boolean isJSP(FileObject fo) {
        return "jsp".equals(fo.getExt());
    }

    public static String getJSPFileContext(Project project, FileObject jspFile, boolean subprojects) {
        Collection<FileObject> docBases = WebProjectUtils.getDocumentBaseFileObjects(project, subprojects);
        String relPathUsed = null;
        for (FileObject docBase : docBases) {
            String relativePath;
            if (docBase == null || (relativePath = FileUtil.getRelativePath((FileObject)docBase, (FileObject)jspFile)) == null || relPathUsed != null && relPathUsed.length() <= relativePath.length()) continue;
            relPathUsed = relativePath;
        }
        return relPathUsed;
    }

    public static ClientUtils.SourceCodeSelection getJSPFileRootMethod(Project project, FileObject jspFile) {
        return WebProjectUtils.getJSPMethodSignature(project, jspFile);
    }

    public static ClientUtils.SourceCodeSelection getJSPMethodSignature(Project project, FileObject jspFile) {
        String jspPseudoServletClass = WebProjectUtils.getJSPPseudoServletClass(project, jspFile);
        if (jspPseudoServletClass == null) {
            LOGGER.log(Level.WARNING, Bundle.WebProjectUtils_CannotFindServletMsg(FileUtil.toFile((FileObject)jspFile).getPath()));
            return null;
        }
        return WebProjectUtils.getJSPMethodSignature(jspPseudoServletClass);
    }

    public static ClientUtils.SourceCodeSelection getJSPMethodSignature(String jspPseudoServletClass) {
        return new ClientUtils.SourceCodeSelection(jspPseudoServletClass, jspServletMethods[0][0], jspServletMethods[0][1]);
    }

    public static Set<ClientUtils.SourceCodeSelection> getJSPMethodSignatures(Project project, boolean subprojects) {
        HashSet<ClientUtils.SourceCodeSelection> methodSignatures = new HashSet<ClientUtils.SourceCodeSelection>();
        Collection<FileObject> baseFOs = WebProjectUtils.getDocumentBaseFileObjects(project, subprojects);
        if (baseFOs == null || baseFOs.isEmpty()) {
            return methodSignatures;
        }
        for (FileObject baseFO : baseFOs) {
            int jspStringStartIndex = baseFO.getPath().length();
            ArrayList jspFileObjects = WebProjectUtils.getJSPs(baseFO);
            for (FileObject jsp : jspFileObjects) {
                ClientUtils.SourceCodeSelection methodDescription = WebProjectUtils.getJSPMethodSignature(project, jsp);
                if (methodDescription == null) continue;
                jspClass2NameMap.put(methodDescription, jsp.getPath().substring(jspStringStartIndex));
                methodSignatures.add(methodDescription);
            }
        }
        return methodSignatures;
    }

    public static String getJSPPath(ClientUtils.SourceCodeSelection jspMethod) {
        return jspClass2NameMap.get(jspMethod);
    }

    public static String getJSPPseudoServletClass(Project project, FileObject jspFile) {
        String jspPseudoServletJavaFile = JSPServletFinder.findJSPServletFinder((FileObject)jspFile).getServletResourcePath(WebProjectUtils.getJSPFileContext(project, jspFile, true));
        if (jspPseudoServletJavaFile == null) {
            return null;
        }
        String jspPseudoServletJavaClass = jspPseudoServletJavaFile.substring(0, jspPseudoServletJavaFile.length() - ".java".length()).replace('/', '.');
        return jspPseudoServletJavaClass;
    }

    public static ClientUtils.SourceCodeSelection[] getJSPRootMethods(Project project, boolean subprojects) {
        Set<ClientUtils.SourceCodeSelection> jspRootMethodDescriptions = WebProjectUtils.getJSPMethodSignatures(project, subprojects);
        if (jspRootMethodDescriptions == null) {
            return new ClientUtils.SourceCodeSelection[0];
        }
        return jspRootMethodDescriptions.toArray(new ClientUtils.SourceCodeSelection[jspRootMethodDescriptions.size()]);
    }

    public static ArrayList getJSPs(FileObject documentBase) {
        ArrayList jspFileObjects = new ArrayList();
        if (documentBase.isFolder()) {
            WebProjectUtils.searchForJSPs(documentBase, jspFileObjects);
        }
        return jspFileObjects;
    }

    public static ArrayList getListenerClasses(Document deploymentDescriptorDocument) {
        ArrayList<String> listeners = new ArrayList<String>();
        NodeList listenersList = WebProjectUtils.getListeners(deploymentDescriptorDocument);
        for (int i = 0; i < listenersList.getLength(); ++i) {
            String listenerClass = WebProjectUtils.getElementContent((Element)listenersList.item(i), "listener-class");
            if (listenerClass == null || listeners.contains(listenerClass)) continue;
            listeners.add(listenerClass);
        }
        return listeners;
    }

    public static NodeList getListeners(Document deploymentDescriptorDocument) {
        return deploymentDescriptorDocument.getElementsByTagName("listener");
    }

    public static boolean isMappedServlet(FileObject servlet, Project project, boolean subprojects) {
        Collection<Document> dds = WebProjectUtils.getDeploymentDescriptorDocuments(project, subprojects);
        for (Document dd : dds) {
            if (WebProjectUtils.getServletMapping(servlet, dd) == null) continue;
            return true;
        }
        return false;
    }

    public static ArrayList[] getServletClasses(Document deploymentDescriptorDocument) {
        int i;
        ArrayList<String> mappedServlets = new ArrayList<String>();
        ArrayList<String> notMappedServlets = new ArrayList<String>();
        NodeList servletsList = WebProjectUtils.getServlets(deploymentDescriptorDocument);
        NodeList servletMappingsList = WebProjectUtils.getServletMappings(deploymentDescriptorDocument);
        HashSet<String> mappedServletNames = new HashSet<String>();
        for (i = 0; i < servletMappingsList.getLength(); ++i) {
            String mappedServletName = WebProjectUtils.getElementContent((Element)servletMappingsList.item(i), "servlet-name");
            if (mappedServletName == null || mappedServletNames.contains(mappedServletName)) continue;
            mappedServletNames.add(mappedServletName);
        }
        for (i = 0; i < servletsList.getLength(); ++i) {
            String servletName = WebProjectUtils.getElementContent((Element)servletsList.item(i), "servlet-name");
            String servletClassName = WebProjectUtils.getElementContent((Element)servletsList.item(i), "servlet-class");
            if (servletName != null && servletClassName != null && mappedServletNames.contains(servletName)) {
                if (mappedServlets.contains(servletClassName)) continue;
                mappedServlets.add(servletClassName);
                continue;
            }
            if (notMappedServlets.contains(servletClassName)) continue;
            notMappedServlets.add(servletClassName);
        }
        return new ArrayList[]{mappedServlets, notMappedServlets};
    }

    public static String getServletMapping(FileObject servletFO, Document deploymentDescriptorDocument) {
        JavaProfilerSource src = JavaProfilerSource.createFrom((FileObject)servletFO);
        if (src == null) {
            return null;
        }
        String servletClassName = src.getTopLevelClass().getVMName();
        if (servletClassName == null || deploymentDescriptorDocument == null) {
            return null;
        }
        NodeList servletsList = WebProjectUtils.getServlets(deploymentDescriptorDocument);
        for (int i = 0; i < servletsList.getLength(); ++i) {
            String servletName = WebProjectUtils.getElementContent((Element)servletsList.item(i), "servlet-name");
            String className = WebProjectUtils.getElementContent((Element)servletsList.item(i), "servlet-class");
            if (servletName == null || className == null || !servletClassName.equals(className)) continue;
            NodeList servletMappingsList = WebProjectUtils.getServletMappings(deploymentDescriptorDocument);
            for (int j = 0; j < servletMappingsList.getLength(); ++j) {
                if (!servletName.equals(WebProjectUtils.getElementContent((Element)servletMappingsList.item(j), "servlet-name"))) continue;
                return WebProjectUtils.getElementContent((Element)servletMappingsList.item(j), "url-pattern");
            }
            return null;
        }
        return null;
    }

    public static NodeList getServletMappings(Document deploymentDescriptorDocument) {
        return deploymentDescriptorDocument.getElementsByTagName("servlet-mapping");
    }

    public static NodeList getServlets(Document deploymentDescriptorDocument) {
        return deploymentDescriptorDocument.getElementsByTagName("servlet");
    }

    public static boolean isWebDocumentSource(FileObject fo, Project project) {
        SourceGroup[] sg = ProjectUtils.getSources((Project)project).getSourceGroups("doc_root");
        for (int i = 0; i < sg.length; ++i) {
            if (!FileUtil.isParentOf((FileObject)sg[i].getRootFolder(), (FileObject)fo)) continue;
            return true;
        }
        return false;
    }

    public static boolean isWebJavaSource(FileObject fo, Project project) {
        SourceGroup[] sg = ProjectUtils.getSources((Project)project).getSourceGroups("java");
        for (int i = 0; i < sg.length; ++i) {
            if (!FileUtil.isParentOf((FileObject)sg[i].getRootFolder(), (FileObject)fo)) continue;
            return true;
        }
        return false;
    }

    public static Collection<WebModule> getWebModules(Project project, boolean subprojects) {
        ArrayList<WebModule> wms = new ArrayList<WebModule>();
        WebModule wm = WebModule.getWebModule((FileObject)project.getProjectDirectory());
        if (wm != null) {
            wms.add(wm);
        }
        if (subprojects) {
            EarProvider earprovider = (EarProvider)project.getLookup().lookup(EarProvider.class);
            if (wm == null && earprovider != null) {
                HashSet projects = new HashSet();
                ProjectUtilities.fetchSubprojects((Project)project, projects);
                for (Project subp : projects) {
                    wms.addAll(WebProjectUtils.getWebModules(subp, subprojects));
                }
            }
        }
        return wms;
    }

    public static void resetJSPNameCache() {
        jspClass2NameMap.clear();
    }

    private static String getElementContent(Element rootElement, String tagName) {
        if (rootElement == null) {
            return null;
        }
        NodeList elementsList = rootElement.getElementsByTagName(tagName);
        if (elementsList == null || elementsList.getLength() == 0) {
            return null;
        }
        Node element = elementsList.item(0);
        if (element == null) {
            return null;
        }
        String elementContents = element.getTextContent();
        if (elementContents == null) {
            return null;
        }
        return elementContents.trim();
    }

    private static void searchForJSPs(FileObject root, ArrayList jspFileObjects) {
        FileObject[] childs = root.getChildren();
        for (int i = 0; i < childs.length; ++i) {
            FileObject child = childs[i];
            if (child.isFolder()) {
                WebProjectUtils.searchForJSPs(child, jspFileObjects);
                continue;
            }
            if (!child.isData() || !"jsp".equals(child.getExt())) continue;
            jspFileObjects.add(child);
        }
    }
}

