/**
 * Push button. See the BUTTON element definition in HTML 4.01.
 */
var HTMLButtonElement = {
}
/**
 * A single character access key to give access to the form control. See the accesskey attribute definition in HTML 4.01.
 * @syntax hTMLButtonElement.accessKey
 * @returns {String} 
 */
HTMLButtonElement.prototype.accessKey = new String();

/**
 * Returns the FORM element containing this control. Returns null if this control is not within the context of a form.
 * @syntax hTMLButtonElement.form
 * @returns {HTMLFormElement} 
 */
HTMLButtonElement.prototype.form = new HTMLFormElement();

/**
 * Form control or object name when submitted with a form. See the name attribute definition in HTML 4.01.
 * @syntax hTMLButtonElement.name
 * @returns {String} 
 */
HTMLButtonElement.prototype.name = new String();

/**
 * Index that represents the element's position in the tabbing order. See the tabindex attribute definition in HTML 4.01.
 * @syntax hTMLButtonElement.tabIndex
 * @returns {Number} 
 */
HTMLButtonElement.prototype.tabIndex = new Number();

/**
 * The current form control value. See the value attribute definition in HTML 4.01.
 * @syntax hTMLButtonElement.value
 * @returns {String} 
 */
HTMLButtonElement.prototype.value = new String();

/**
 * The type of button (all lower case). See the type attribute definition in HTML 4.01.
 * @syntax hTMLButtonElement.type
 * @returns {String} 
 */
HTMLButtonElement.prototype.type = new String();

/**
 * The control is unavailable in this context. See the disabled attribute definition in HTML 4.01.
 * @syntax hTMLButtonElement.disabled
 * @returns {boolean} 
 */
HTMLButtonElement.prototype.disabled = new boolean();

/**
 * Represents the HTMLButtonElement prototype object.
 * @syntax HTMLButtonElement.prototype
 * @static
 */
HTMLButtonElement.prototype;

