
package org.llvm.adt.aliases;

import org.clank.java.*;
import org.clank.support.*;
import org.clank.support.aliases.*;
import static org.clank.support.Casts.*;
import static org.clank.java.io.*;
import static org.clank.java.std.*;
import static org.llvm.adt.ADTAliases.*;
import static org.llvm.support.llvm.*;
import static org.clank.support.NativePointer.*;
import static org.clank.support.NativeType.*;
import static org.clank.support.Native.*;
import org.llvm.support.*;
import org.llvm.adt.*;
import org.llvm.adt.aliases.*;

/*template <typename ${KEY_TYPE}, typename ${VALUE_TYPE}, typename KeyInfoT = ${DENSE_MAP_INFO}, bool IsConst = false> TEMPLATE*/
//<editor-fold defaultstate="collapsed" desc="llvm::${FILE_NAME}">
@Converted(kind = Converted.Kind.AUTO, source = "${LLVM_SRC}/llvm/include/llvm/ADT/DenseMap.h", line = 985,
 cmd="jclank.sh ${LLVM_SRC}/llvm/tools/clang/lib/Lex/HeaderMap.cpp -filter=llvm::${FILE_NAME}")
//</editor-fold>
public class ${FILE_NAME}${CLASS_SUFFIX}  implements type$iterator<${FILE_NAME}${CLASS_SUFFIX}, ${PAIR_TYPE}>, Cloneable {
  /*typedef std::${PAIR_TYPE} Bucket*/
//  public final class Bucket extends ${PAIR_TYPE}{ };
  /*typedef ${FILE_NAME}<${KEY_TYPE}, ${VALUE_TYPE}, KeyInfoT, true> ConstIterator*/
//  public final class ConstIterator extends ${FILE_NAME}<${KEY_TYPE}, ${VALUE_TYPE}, KeyInfoT, true>{ };
  /*friend  class ${FILE_NAME}<${KEY_TYPE}, ${VALUE_TYPE}, KeyInfoT, true>*/;
/*public:*/
  /*typedef ptrdiff_t difference_type*/;
  /*typedef typename conditional<IsConst, const Bucket, Bucket>::type value_type*/
//  public final class value_type extends  conditional<IsConst, /*const*/Bucket, Bucket>.type{ };
  /*typedef value_type *pointer*/
//  public final class pointer extends value_type /*P*/ { };
  /*typedef value_type &reference*/
//  public final class reference extends value_type /*&*/ { };
  /*typedef std::forward_iterator_tag iterator_category*/
//  public final class iterator_category extends std.forward_iterator_tag{ };
/*private:*/
  private final ${DENSE_MAP_INFO} keyInfoT;
  private final ${PAIR_TYPE}[] Buckets;
  private int Ptr;
  private final int End;
  private static final int INVALID_INDEX = DenseMapBase.INVALID_INDEX;
/*public:*/
  //<editor-fold defaultstate="collapsed" desc="llvm::${FILE_NAME}::${FILE_NAME}<${KEY_TYPE}, ${VALUE_TYPE}, KeyInfoT, IsConst>">
  @Converted(kind = Converted.Kind.AUTO, source = "${LLVM_SRC}/llvm/include/llvm/ADT/DenseMap.h", line = 1001,
   cmd="jclank.sh ${LLVM_SRC}/llvm/tools/clang/lib/Lex/HeaderMap.cpp -filter=llvm::${FILE_NAME}::${FILE_NAME}<${KEY_TYPE}, ${VALUE_TYPE}, KeyInfoT, IsConst>")
  //</editor-fold>
  public ${FILE_NAME}(${DENSE_MAP_INFO} keyInfoT) {
    /* : Ptr(0), End(0)*/ 
    //START JInit
    this.keyInfoT = keyInfoT;
    this.Ptr = INVALID_INDEX;
    this.End = INVALID_INDEX;
    this.Buckets = null;
    //END JInit
  }

  //<editor-fold defaultstate="collapsed" desc="llvm::${FILE_NAME}::${FILE_NAME}<${KEY_TYPE}, ${VALUE_TYPE}, KeyInfoT, IsConst>">
  @Converted(kind = Converted.Kind.AUTO, source = "${LLVM_SRC}/llvm/include/llvm/ADT/DenseMap.h", line = 1003,
   cmd="jclank.sh ${LLVM_SRC}/llvm/tools/clang/lib/Lex/HeaderMap.cpp -filter=llvm::${FILE_NAME}::${FILE_NAME}<${KEY_TYPE}, ${VALUE_TYPE}, KeyInfoT, IsConst>")
  //</editor-fold>
  public ${FILE_NAME}(${DENSE_MAP_INFO} keyInfoT, ${PAIR_TYPE}[] Buckets, int Pos, int E) {
    this(keyInfoT, Buckets, Pos, E, false);
  }
  public ${FILE_NAME}(${DENSE_MAP_INFO} keyInfoT, ${PAIR_TYPE}[] Buckets, int Pos, int E, boolean NoAdvance/*= false*/) {
    /* : Ptr(Pos), End(E)*/ 
    //START JInit
    this.keyInfoT = keyInfoT;
    this.Ptr = Pos;
    this.End = E;
    //END JInit
    this.Buckets = Buckets;
    if (!NoAdvance) {
      AdvancePastEmptyBuckets();
    }    
  }

  public ${FILE_NAME}${CLASS_SUFFIX} $assignMove(${FILE_NAME}${CLASS_SUFFIX} other) {
    assert this.End == other.End;
    assert this.Buckets == other.Buckets;
    this.Ptr = other.Ptr;
    return this;
  }

//  //<editor-fold defaultstate="collapsed" desc="llvm::${FILE_NAME}::${FILE_NAME}<${KEY_TYPE}, ${VALUE_TYPE}, KeyInfoT, IsConst>">
//  @Converted(kind = Converted.Kind.AUTO, source = "${LLVM_SRC}/llvm/include/llvm/ADT/DenseMap.h", line = 1003,
//   cmd="jclank.sh ${LLVM_SRC}/llvm/tools/clang/lib/Lex/HeaderMap.cpp -filter=llvm::${FILE_NAME}::${FILE_NAME}<${KEY_TYPE}, ${VALUE_TYPE}, KeyInfoT, IsConst>")
//  //</editor-fold>
//  public ${FILE_NAME}(${DENSE_MAP_INFO} keyInfoT, type$ptr<${PAIR_TYPE}> Pos, type$ptr<${PAIR_TYPE}> E) {
//    this(keyInfoT, Pos, E, false);
//  }
//  public ${FILE_NAME}(${DENSE_MAP_INFO} keyInfoT, type$ptr<${PAIR_TYPE}> Pos, type$ptr<${PAIR_TYPE}> E, boolean NoAdvance/*= false*/) {
//    /* : Ptr(Pos), End(E)*/ 
//    //START JInit
//    assert (Pos == null && E == null) || (Pos.$array() == E.$array());
//    this.keyInfoT = keyInfoT;
//    this.Ptr = Pos != null ? Pos.$index() : INVALID_INDEX;
//    this.End = E != null ? E.$index() : INVALID_INDEX;
//    //END JInit
//    this.Buckets = Pos == null ? null : Pos.$array();
//    if (!NoAdvance) {
//      AdvancePastEmptyBuckets();
//    }
//  }

  
  // If IsConst is true this is a converting constructor from iterator to
  // const_iterator and the default copy constructor is used.
  // Otherwise this is a copy constructor for iterator.
  //<editor-fold defaultstate="collapsed" desc="llvm::${FILE_NAME}::${FILE_NAME}<${KEY_TYPE}, ${VALUE_TYPE}, KeyInfoT, IsConst>">
  @Converted(kind = Converted.Kind.AUTO, source = "${LLVM_SRC}/llvm/include/llvm/ADT/DenseMap.h", line = 1011,
   cmd="jclank.sh ${LLVM_SRC}/llvm/tools/clang/lib/Lex/HeaderMap.cpp -filter=llvm::${FILE_NAME}::${FILE_NAME}<${KEY_TYPE}, ${VALUE_TYPE}, KeyInfoT, IsConst>")
  //</editor-fold>
  public ${FILE_NAME}(/*const*/${FILE_NAME}${CLASS_SUFFIX} /*&*/ I) {
    /* : Ptr(I.Ptr), End(I.End)*/ 
    //START JInit
    this.keyInfoT = I.keyInfoT;
    this.Ptr = I.Ptr;
    this.End = I.End;
    this.Buckets = I.Buckets;
    //END JInit
  }

  @Override
  //<editor-fold defaultstate="collapsed" desc="llvm::${FILE_NAME}::operator*">
  @Converted(kind = Converted.Kind.AUTO, source = "${LLVM_SRC}/llvm/include/llvm/ADT/DenseMap.h", line = 1015,
   cmd="jclank.sh ${LLVM_SRC}/llvm/tools/clang/lib/Lex/HeaderMap.cpp -filter=llvm::${FILE_NAME}::operator*")
  //</editor-fold>
  public ${PAIR_TYPE} $star() /*const*/ {
    return /*Deref*/Buckets[Ptr];
  }

  @Override
  public type$ref<${PAIR_TYPE}> star$ref() {
    return new type$ref<${PAIR_TYPE}>() {
        
        int localPtr = Ptr;

        @Override
        public ${PAIR_TYPE} $deref() {
            return Buckets[localPtr];
        }

        @Override
        public ${PAIR_TYPE} $set(${PAIR_TYPE} value) {
            return Buckets[localPtr] = value;
        }

        @Override
        public type$ptr<${PAIR_TYPE}> deref$ptr() {
            return create_type$ptr(Buckets, localPtr);
        }
    };
  }

  //<editor-fold defaultstate="collapsed" desc="llvm::${FILE_NAME}::operator->">
  @Converted(kind = Converted.Kind.AUTO, source = "${LLVM_SRC}/llvm/include/llvm/ADT/DenseMap.h", line = 1018,
   cmd="jclank.sh ${LLVM_SRC}/llvm/tools/clang/lib/Lex/HeaderMap.cpp -filter=llvm::${FILE_NAME}::operator->")
  //</editor-fold>
  public type$ptr<${PAIR_TYPE}> $arrow() /*const*/ {
    return create_type$ptr(Buckets, Ptr);
  }

  //<editor-fold defaultstate="collapsed" desc="llvm::${FILE_NAME}::operator==">
  @Converted(kind = Converted.Kind.AUTO, source = "${LLVM_SRC}/llvm/include/llvm/ADT/DenseMap.h", line = 1022,
   cmd="jclank.sh ${LLVM_SRC}/llvm/tools/clang/lib/Lex/HeaderMap.cpp -filter=llvm::${FILE_NAME}::operator==")
  //</editor-fold>
  public boolean $eq(/*const*/${FILE_NAME}${CLASS_SUFFIX} /*&*/ RHS) /*const*/ {
    assert Buckets == RHS.Buckets;
    return Ptr == RHS.Ptr;
  }

  //<editor-fold defaultstate="collapsed" desc="llvm::${FILE_NAME}::operator!=">
  @Converted(kind = Converted.Kind.AUTO, source = "${LLVM_SRC}/llvm/include/llvm/ADT/DenseMap.h", line = 1025,
   cmd="jclank.sh ${LLVM_SRC}/llvm/tools/clang/lib/Lex/HeaderMap.cpp -filter=llvm::${FILE_NAME}::operator!=")
  //</editor-fold>
  public boolean $noteq(/*const*/${FILE_NAME}${CLASS_SUFFIX} /*&*/ RHS) /*const*/ {
    assert Buckets == RHS.Buckets;
    return Ptr != RHS.Ptr;
  }

  // Preincrement
  @Override
  //<editor-fold defaultstate="collapsed" desc="llvm::${FILE_NAME}::operator++">
  @Converted(kind = Converted.Kind.AUTO, source = "${LLVM_SRC}/llvm/include/llvm/ADT/DenseMap.h", line = 1029,
   cmd="jclank.sh ${LLVM_SRC}/llvm/tools/clang/lib/Lex/HeaderMap.cpp -filter=llvm::${FILE_NAME}::operator++")
  //</editor-fold>
  public /*inline*/ ${FILE_NAME}${CLASS_SUFFIX} /*&*/ $preInc() {
    ++Ptr;
    AdvancePastEmptyBuckets();
    return /*Deref*/this;
  }

  // Postincrement
  //<editor-fold defaultstate="collapsed" desc="llvm::${FILE_NAME}::operator++">
  @Converted(kind = Converted.Kind.AUTO, source = "${LLVM_SRC}/llvm/include/llvm/ADT/DenseMap.h", line = 1034,
   cmd="jclank.sh ${LLVM_SRC}/llvm/tools/clang/lib/Lex/HeaderMap.cpp -filter=llvm::${FILE_NAME}::operator++")
  //</editor-fold>
  public ${FILE_NAME}${CLASS_SUFFIX} $postInc() {
    ${FILE_NAME}${CLASS_SUFFIX} tmp = /*Deref*/new ${FILE_NAME}(keyInfoT, Buckets, Ptr, End, true);
    ++Ptr;
    return tmp;
  }

/*private:*/
  //<editor-fold defaultstate="collapsed" desc="llvm::${FILE_NAME}::AdvancePastEmptyBuckets">
  @Converted(kind = Converted.Kind.AUTO, source = "${LLVM_SRC}/llvm/include/llvm/ADT/DenseMap.h", line = 1039,
   cmd="jclank.sh ${LLVM_SRC}/llvm/tools/clang/lib/Lex/HeaderMap.cpp -filter=llvm::${FILE_NAME}::AdvancePastEmptyBuckets")
  //</editor-fold>
  private void AdvancePastEmptyBuckets() {
    /*const*/${KEY_TYPE} Empty = keyInfoT.getEmptyKey();
    /*const*/${KEY_TYPE} Tombstone = keyInfoT.getTombstoneKey();
    while (Native.$noteq(Ptr, End) && ((Buckets[Ptr].first == Empty) || (Buckets[Ptr].first == Tombstone))) {
      ++Ptr;
    }
  }
  
  @Override
  public ${FILE_NAME}${CLASS_SUFFIX} clone() {
    return new ${FILE_NAME}(keyInfoT, Buckets, Ptr, End, true);
  }

  @Override
  public ${FILE_NAME}${CLASS_SUFFIX} const_clone() {
    // TODO: pass constness
    return new ${FILE_NAME}(keyInfoT, Buckets, Ptr, End, true);
  }

  @Override
  public boolean $eq(Object other) {
    if (other instanceof ${FILE_NAME}) {
      return Native.$eq(Ptr, ((${FILE_NAME}) other).Ptr);
    }
    return false;
  }

  @Override
  public boolean $noteq(Object other) {
    if (other instanceof ${FILE_NAME}) {
      return Native.$noteq(Ptr, ((${FILE_NAME}) other).Ptr);
    }
    return true;
  }

  @Override
  public int $sub(${FILE_NAME}${CLASS_SUFFIX} iter) {
    throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
  }

  @Override
  public ${FILE_NAME}${CLASS_SUFFIX} $preDec() {
    throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
  }

  @Override
  public ${FILE_NAME}${CLASS_SUFFIX} $postDec() {
    throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
  }

  @Override
  public ${FILE_NAME}${CLASS_SUFFIX} $inc(int amount) {
    throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
  }
  @Override
  public ${FILE_NAME}${CLASS_SUFFIX} $inc(long amount) {
    throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
  }

  @Override
  public ${FILE_NAME}${CLASS_SUFFIX} $dec(int amount) {
    throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
  }
  @Override
  public ${FILE_NAME}${CLASS_SUFFIX} $dec(long amount) {
    throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
  }

  @Override
  public ${FILE_NAME}${CLASS_SUFFIX} $add(int amount) {
    throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
  }
  @Override
  public ${FILE_NAME}${CLASS_SUFFIX} $add(long amount) {
    throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
  }

  @Override
  public ${FILE_NAME}${CLASS_SUFFIX} $sub(int amount) {
    throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
  }
  @Override
  public ${FILE_NAME}${CLASS_SUFFIX} $sub(long amount) {
    throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
  }
}
