/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.control;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.commons.configuration.tree.ExpressionEngine;
import org.apache.commons.configuration.tree.xpath.XPathExpressionEngine;
import org.apache.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.zaproxy.zap.control.AddOn;
import org.zaproxy.zap.control.AddOnRunIssuesUtils;
import org.zaproxy.zap.control.ZapRelease;
import org.zaproxy.zap.utils.ZapXmlConfiguration;

public class AddOnCollection {
    private static final Logger logger = Logger.getLogger(AddOnCollection.class);
    private ZapRelease zapRelease = null;
    private List<AddOn> addOns = new ArrayList<AddOn>();
    private File downloadDir = new File(Constant.FOLDER_LOCAL_PLUGIN);
    private Platform platform;

    public AddOnCollection(ZapXmlConfiguration zapXmlConfiguration, Platform platform) {
        this(zapXmlConfiguration, platform, true);
    }

    public AddOnCollection(ZapXmlConfiguration zapXmlConfiguration, Platform platform, boolean bl) {
        this.platform = platform;
        this.load(zapXmlConfiguration);
        if (!bl) {
            ArrayList<AddOn> arrayList = new ArrayList<AddOn>(this.addOns);
            ArrayList<AddOn> arrayList2 = new ArrayList<AddOn>(this.addOns.size());
            while (!arrayList.isEmpty()) {
                AddOn addOn = (AddOn)arrayList.remove(0);
                AddOn.AddOnRunRequirements addOnRunRequirements = addOn.calculateRunRequirements(this.addOns);
                if (addOnRunRequirements.hasDependencyIssue()) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Ignoring add-on  " + addOn.getName() + " because of dependency issue: " + AddOnRunIssuesUtils.getDependencyIssue(addOnRunRequirements)));
                    }
                    if (AddOn.BaseRunRequirements.DependencyIssue.CYCLIC != addOnRunRequirements.getDependencyIssue()) continue;
                    Set set = (Set)addOnRunRequirements.getDependencyIssueDetails().get(0);
                    arrayList.removeAll(set);
                    continue;
                }
                if (addOnRunRequirements.hasExtensionsWithRunningIssues()) {
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug((Object)("Ignoring add-on  " + addOn.getName() + " because of dependency issue in an extension: " + AddOnRunIssuesUtils.getDependencyIssue(addOnRunRequirements)));
                    continue;
                }
                arrayList2.add(addOn);
            }
            this.addOns = arrayList2;
        }
    }

    private void load(ZapXmlConfiguration zapXmlConfiguration) {
        Object object;
        zapXmlConfiguration.setExpressionEngine((ExpressionEngine)new XPathExpressionEngine());
        try {
            object = zapXmlConfiguration.getString("core/version");
            if (Platform.daily.equals((Object)this.platform)) {
                object = zapXmlConfiguration.getString("core/daily-version", (String)object);
            } else if (Constant.isKali()) {
                object = zapXmlConfiguration.getString("core/kali-version", (String)object);
            }
            if (object != null && ((String)object).length() > 0) {
                String object2 = zapXmlConfiguration.getString("core/relnotes-url", null);
                URL uRL = null;
                if (object2 != null) {
                    uRL = new URL(object2);
                }
                this.zapRelease = new ZapRelease((String)object, new URL(zapXmlConfiguration.getString("core/" + this.platform.name() + "/url")), zapXmlConfiguration.getString("core/" + this.platform.name() + "/file"), zapXmlConfiguration.getLong("core/" + this.platform.name() + "/size"), zapXmlConfiguration.getString("core/relnotes"), uRL, zapXmlConfiguration.getString("core/" + this.platform.name() + "/hash"));
            }
        }
        catch (Exception exception) {
            logger.error((Object)exception.getMessage(), (Throwable)exception);
        }
        try {
            object = zapXmlConfiguration.getStringArray("addon");
            for (String string : object) {
                AddOn addOn;
                logger.debug((Object)("Found addon " + string));
                try {
                    addOn = new AddOn(string, this.downloadDir, zapXmlConfiguration.configurationAt("addon_" + string));
                    addOn.setInstallationStatus(AddOn.InstallationStatus.AVAILABLE);
                }
                catch (Exception exception) {
                    logger.warn((Object)("Failed to create add-on for " + string), (Throwable)exception);
                    continue;
                }
                if (addOn.canLoadInCurrentVersion()) {
                    this.addOns.add(addOn);
                    continue;
                }
                logger.debug((Object)("Ignoring addon " + addOn.getName() + " cant load in this version"));
            }
        }
        catch (Exception exception) {
            logger.error((Object)exception.getMessage(), (Throwable)exception);
        }
    }

    public AddOnCollection(File[] fileArray) {
        if (fileArray != null) {
            for (File file : fileArray) {
                try {
                    this.addDirectory(file);
                }
                catch (Exception exception) {
                    logger.error((Object)exception.getMessage(), (Throwable)exception);
                }
            }
        }
    }

    private void addDirectory(File file) throws Exception {
        File[] fileArray;
        if (file == null) {
            logger.error((Object)"Null directory supplied");
            return;
        }
        if (!file.exists()) {
            logger.error((Object)("No such directory: " + file.getAbsolutePath()));
        }
        if (!file.isDirectory()) {
            logger.error((Object)("Not a directory: " + file.getAbsolutePath()));
        }
        if ((fileArray = file.listFiles()) != null) {
            for (File file2 : fileArray) {
                AddOn addOn;
                if (!AddOn.isAddOn(file2) || (addOn = AddOnCollection.createAddOn(file2)) == null) continue;
                boolean bl = true;
                for (AddOn addOn2 : this.addOns) {
                    if (!addOn.isSameAddOn(addOn2)) continue;
                    if (addOn.isUpdateTo(addOn2)) {
                        if (addOn.canLoadInCurrentVersion()) {
                            logger.debug((Object)("Addon " + addOn2.getId() + " version " + addOn2.getFileVersion() + " superceeded by " + addOn.getFileVersion()));
                            this.addOns.remove(addOn2);
                            break;
                        }
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("Ignoring newer addon " + addOn.getId() + " version " + addOn.getFileVersion() + " because of ZAP version constraints; Not before=" + addOn.getNotBeforeVersion() + " Not from=" + addOn.getNotFromVersion() + " Current Version=" + Constant.PROGRAM_VERSION));
                        }
                        bl = false;
                        break;
                    }
                    logger.debug((Object)("Addon " + addOn.getId() + " version " + addOn.getFileVersion() + " not latest."));
                    bl = false;
                    break;
                }
                if (!bl) continue;
                logger.debug((Object)("Found addon " + addOn.getId() + " version " + addOn.getFileVersion()));
                this.addOns.add(addOn);
            }
        }
    }

    private static AddOn createAddOn(File file) {
        try {
            return new AddOn(file);
        }
        catch (Exception exception) {
            logger.warn((Object)("Failed to create add-on for: " + file.toString()), (Throwable)exception);
            return null;
        }
    }

    public List<AddOn> getAddOns() {
        return this.addOns;
    }

    public List<AddOn> getInstalledAddOns() {
        ArrayList<AddOn> arrayList = new ArrayList<AddOn>(this.addOns.size());
        for (AddOn addOn : this.addOns) {
            if (AddOn.InstallationStatus.INSTALLED != addOn.getInstallationStatus()) continue;
            arrayList.add(addOn);
        }
        return arrayList;
    }

    public AddOn getAddOn(String string) {
        for (AddOn addOn : this.addOns) {
            if (!addOn.getId().equals(string)) continue;
            return addOn;
        }
        return null;
    }

    public List<AddOn> getUpdatedAddOns(AddOnCollection addOnCollection) {
        ArrayList<AddOn> arrayList = new ArrayList<AddOn>();
        for (AddOn addOn : addOnCollection.getAddOns()) {
            for (AddOn addOn2 : this.addOns) {
                try {
                    if (!addOn.isSameAddOn(addOn2) || !addOn.isUpdateTo(addOn2)) continue;
                    arrayList.add(addOn);
                }
                catch (Exception exception) {
                    logger.error((Object)exception.getMessage(), (Throwable)exception);
                }
            }
        }
        return arrayList;
    }

    public List<AddOn> getNewAddOns(AddOnCollection addOnCollection) {
        ArrayList<AddOn> arrayList = new ArrayList<AddOn>();
        for (AddOn addOn : addOnCollection.getAddOns()) {
            boolean bl = true;
            for (AddOn addOn2 : this.addOns) {
                try {
                    if (!addOn.isSameAddOn(addOn2)) continue;
                    bl = false;
                    break;
                }
                catch (Exception exception) {
                    logger.error((Object)exception.getMessage(), (Throwable)exception);
                }
            }
            if (!bl) continue;
            arrayList.add(addOn);
        }
        return arrayList;
    }

    public ZapRelease getZapRelease() {
        return this.zapRelease;
    }

    public boolean includesAddOn(String string) {
        boolean bl = false;
        for (AddOn addOn : this.addOns) {
            if (!addOn.getId().equals(string)) continue;
            return true;
        }
        return bl;
    }

    public boolean addAddOn(AddOn addOn) {
        if (this.includesAddOn(addOn.getId())) {
            return false;
        }
        this.addOns.add(addOn);
        return true;
    }

    public boolean removeAddOn(AddOn addOn) {
        for (AddOn addOn2 : this.addOns) {
            if (!addOn2.getId().equals(addOn.getId())) continue;
            this.addOns.remove(addOn2);
            return true;
        }
        return false;
    }

    public static enum Platform {
        daily,
        windows,
        linux,
        mac;

    }
}

