/*
 * Decompiled with CFR 0.152.
 */
package grails.util;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class Holder<T> {
    private Map<Integer, T> instances = new ConcurrentHashMap<Integer, T>();
    private T singleton;
    private String name;

    public Holder(String name) {
        this.name = name;
    }

    public T get() {
        return this.get(false);
    }

    public T get(boolean mappedOnly) {
        T t = this.instances.get(this.getClassLoaderId());
        if (t != null) {
            return t;
        }
        t = this.lookupSecondary();
        if (t != null) {
            return t;
        }
        if (t == null && !mappedOnly) {
            t = this.singleton;
        }
        return t;
    }

    protected T lookupSecondary() {
        return null;
    }

    public void set(T t) {
        int id = this.getClassLoaderId();
        int thisClassLoaderId = System.identityHashCode(this.getClass().getClassLoader());
        if (t == null) {
            this.instances.remove(id);
            this.instances.remove(thisClassLoaderId);
        } else {
            this.instances.put(id, t);
            this.instances.put(thisClassLoaderId, t);
        }
        this.singleton = t;
    }

    private int getClassLoaderId() {
        return System.identityHashCode(Thread.currentThread().getContextClassLoader());
    }
}

