/*
 * Decompiled with CFR 0.152.
 */
package org.grails.web.sitemesh;

import groovy.lang.Writable;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import org.grails.buffer.GrailsPrintWriter;
import org.grails.buffer.GrailsPrintWriterAdapter;
import org.grails.buffer.StreamCharBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.objenesis.ObjenesisStd;
import org.springframework.objenesis.instantiator.ObjectInstantiator;

public class GrailsRoutablePrintWriter
extends GrailsPrintWriterAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(GrailsRoutablePrintWriter.class);
    private DestinationFactory factory;
    private boolean blockFlush = true;
    private boolean blockClose = true;
    private boolean destinationActivated = false;
    private static ObjectInstantiator instantiator = null;

    public GrailsRoutablePrintWriter(DestinationFactory factory) {
        super((Writer)new NullWriter());
        this.factory = factory;
    }

    public static GrailsRoutablePrintWriter newInstance(DestinationFactory factory) {
        if (instantiator != null) {
            GrailsRoutablePrintWriter instance = (GrailsRoutablePrintWriter)((Object)instantiator.newInstance());
            instance.out = new NullWriter();
            instance.factory = factory;
            instance.blockFlush = true;
            instance.blockClose = true;
            return instance;
        }
        return new GrailsRoutablePrintWriter(factory);
    }

    protected void activateDestination() {
        if (!this.destinationActivated && this.factory != null) {
            try {
                super.setTarget(this.factory.activateDestination());
            }
            catch (IOException e) {
                this.setError();
            }
            this.destinationActivated = true;
        }
    }

    public boolean isAllowUnwrappingOut() {
        return this.destinationActivated ? super.isAllowUnwrappingOut() : false;
    }

    public Writer unwrap() {
        return this.destinationActivated ? super.unwrap() : this;
    }

    public void updateDestination(DestinationFactory f) {
        this.setDestinationActivated(false);
        this.factory = f;
    }

    public void close() {
        if (!this.isBlockClose() && this.isDestinationActivated()) {
            super.close();
        }
    }

    public void println(Object x) {
        this.activateDestination();
        super.println(x);
    }

    public void println(String x) {
        this.activateDestination();
        super.println(x);
    }

    public void println(char[] x) {
        this.activateDestination();
        super.println(x);
    }

    public void println(double x) {
        this.activateDestination();
        super.println(x);
    }

    public void println(float x) {
        this.activateDestination();
        super.println(x);
    }

    public void println(long x) {
        this.activateDestination();
        super.println(x);
    }

    public void println(int x) {
        this.activateDestination();
        super.println(x);
    }

    public void println(char x) {
        this.activateDestination();
        super.println(x);
    }

    public void println(boolean x) {
        this.activateDestination();
        super.println(x);
    }

    public void println() {
        this.activateDestination();
        super.println();
    }

    public void print(Object obj) {
        this.activateDestination();
        super.print(obj);
    }

    public void print(String s) {
        this.activateDestination();
        super.print(s);
    }

    public void print(char[] s) {
        this.activateDestination();
        super.print(s);
    }

    public void print(double d) {
        this.activateDestination();
        super.print(d);
    }

    public void print(float f) {
        this.activateDestination();
        super.print(f);
    }

    public void print(long l) {
        this.activateDestination();
        super.print(l);
    }

    public void print(int i) {
        this.activateDestination();
        super.print(i);
    }

    public void print(char c) {
        this.activateDestination();
        super.print(c);
    }

    public void print(boolean b) {
        this.activateDestination();
        super.print(b);
    }

    public void write(String s) {
        this.activateDestination();
        super.write(s);
    }

    public void write(String s, int off, int len) {
        this.activateDestination();
        super.write(s, off, len);
    }

    public void write(char[] buf) {
        this.activateDestination();
        super.write(buf);
    }

    public void write(char[] buf, int off, int len) {
        this.activateDestination();
        super.write(buf, off, len);
    }

    public void write(int c) {
        this.activateDestination();
        super.write(c);
    }

    public boolean checkError() {
        this.activateDestination();
        return super.checkError();
    }

    public void flush() {
        if (!this.isBlockFlush() && this.isDestinationActivated()) {
            super.flush();
        }
    }

    public PrintWriter append(char c) {
        this.activateDestination();
        return super.append(c);
    }

    public PrintWriter append(CharSequence csq, int start, int end) {
        this.activateDestination();
        return super.append(csq, start, end);
    }

    public PrintWriter append(CharSequence csq) {
        this.activateDestination();
        return super.append(csq);
    }

    public boolean isBlockFlush() {
        return this.blockFlush;
    }

    public void setBlockFlush(boolean blockFlush) {
        this.blockFlush = blockFlush;
    }

    public boolean isBlockClose() {
        return this.blockClose;
    }

    public void setBlockClose(boolean blockClose) {
        this.blockClose = blockClose;
    }

    public void unBlockFlushAndClose() {
        this.blockClose = false;
        this.blockFlush = false;
    }

    public void blockFlushAndClose() {
        this.blockClose = true;
        this.blockFlush = true;
    }

    public GrailsPrintWriter leftShift(Object value) throws IOException {
        this.activateDestination();
        return super.leftShift(value);
    }

    public GrailsPrintWriter leftShift(StreamCharBuffer otherBuffer) {
        this.activateDestination();
        return super.leftShift(otherBuffer);
    }

    public GrailsPrintWriter leftShift(Writable writable) {
        this.activateDestination();
        return super.leftShift(writable);
    }

    public boolean isDestinationActivated() {
        return this.destinationActivated;
    }

    public void setDestinationActivated(boolean destinationActivated) {
        this.destinationActivated = destinationActivated;
        if (!this.destinationActivated) {
            super.setTarget((Writer)new NullWriter());
        }
    }

    static {
        try {
            instantiator = new ObjenesisStd(false).getInstantiatorOf(GrailsRoutablePrintWriter.class);
        }
        catch (Exception e) {
            LOG.debug("Couldn't get direct performance optimized instantiator for GrailsRoutablePrintWriter. Using default instantiation.", (Throwable)e);
        }
    }

    private static class NullWriter
    extends Writer {
        protected NullWriter() {
        }

        @Override
        public void write(char[] cbuf, int off, int len) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void flush() throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void close() throws IOException {
            throw new UnsupportedOperationException();
        }
    }

    public static interface DestinationFactory {
        public Writer activateDestination() throws IOException;
    }
}

