/*
 * Decompiled with CFR 0.152.
 */
package org.grails.core;

import grails.core.GrailsApplication;
import grails.core.GrailsControllerClass;
import grails.util.Environment;
import grails.web.Action;
import grails.web.UrlConverter;
import groovy.lang.GroovyObject;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.grails.core.AbstractInjectableGrailsClass;
import org.springframework.util.ReflectionUtils;

public class DefaultGrailsControllerClass
extends AbstractInjectableGrailsClass
implements GrailsControllerClass,
org.codehaus.groovy.grails.commons.GrailsControllerClass {
    public static final String CONTROLLER = "Controller";
    private static final String DEFAULT_CLOSURE_PROPERTY = "defaultAction";
    public static final String ALLOWED_HTTP_METHODS_PROPERTY = "allowedMethods";
    public static final Object[] EMPTY_ARGS = new Object[0];
    public static final String SCOPE = "scope";
    public static final String SCOPE_SINGLETON = "singleton";
    private String scope;
    private Map<String, ActionInvoker> actions = new HashMap<String, ActionInvoker>();
    private String defaultActionName;
    private String namespace;
    protected Map<String, String> actionUriToViewName = new HashMap<String, String>();

    public DefaultGrailsControllerClass(Class<?> clazz) {
        super(clazz, CONTROLLER);
        this.namespace = this.getStaticPropertyValue("namespace", String.class);
        this.defaultActionName = this.getStaticPropertyValue(DEFAULT_CLOSURE_PROPERTY, String.class);
        if (this.defaultActionName == null) {
            this.defaultActionName = "index";
        }
        this.methodStrategy(this.actions);
        this.scope = this.getStaticPropertyValue(SCOPE, String.class);
    }

    @Override
    public void initialize() {
    }

    @Override
    public void setGrailsApplication(GrailsApplication grailsApplication) {
        this.grailsApplication = grailsApplication;
        if (this.scope == null) {
            this.scope = grailsApplication.getConfig().getProperty("grails.controllers.defaultScope", "prototype");
        }
    }

    @Override
    public Set<String> getActions() {
        return this.actions.keySet();
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    @Override
    public String getScope() {
        return this.scope;
    }

    @Override
    public boolean isSingleton() {
        return SCOPE_SINGLETON.equalsIgnoreCase(this.getScope());
    }

    @Override
    public String getDefaultAction() {
        return this.defaultActionName;
    }

    private void methodStrategy(Map<String, ActionInvoker> methodNames) {
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        for (Class<?> superClass = this.getClazz(); superClass != Object.class && superClass != GroovyObject.class; superClass = superClass.getSuperclass()) {
            for (Method method : superClass.getMethods()) {
                if (!Modifier.isPublic(method.getModifiers()) || method.getAnnotation(Action.class) == null) continue;
                String methodName = method.getName();
                if (Environment.isDevelopmentMode()) {
                    methodNames.put(methodName, new ReflectionInvoker(method));
                    continue;
                }
                try {
                    MethodHandle mh = lookup.findVirtual(superClass, methodName, MethodType.methodType(method.getReturnType()));
                    methodNames.put(methodName, new MethodHandleInvoker(mh));
                }
                catch (IllegalAccessException | NoSuchMethodException e) {
                    methodNames.put(methodName, new ReflectionInvoker(method));
                }
            }
        }
        if (!this.isActionMethod(this.defaultActionName) && methodNames.size() == 1 && !this.isReadableProperty("scaffold")) {
            this.defaultActionName = methodNames.keySet().iterator().next();
        }
    }

    @Override
    public boolean mapsToURI(String uri) {
        String[] tokens;
        if (uri.startsWith("/") && (tokens = uri.substring(1).split("\\/")).length > 0) {
            String controllerName = tokens[0];
            if (this.getLogicalPropertyName().equals(controllerName)) {
                if (tokens.length > 1) {
                    String actionName = tokens[1];
                    if (this.actions.containsKey(actionName) || this.defaultActionName.equals(actionName)) {
                        return true;
                    }
                } else {
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public void registerUrlConverter(UrlConverter urlConverter) {
        for (String actionName : new ArrayList<String>(this.actions.keySet())) {
            this.actionUriToViewName.put(urlConverter.toUrlElement(actionName), actionName);
            this.actions.put(urlConverter.toUrlElement(actionName), this.actions.remove(actionName));
        }
    }

    @Override
    public Object invoke(Object controller, String action) throws Throwable {
        ActionInvoker handle;
        if (action == null) {
            action = this.defaultActionName;
        }
        if ((handle = this.actions.get(action)) == null) {
            throw new IllegalArgumentException("Invalid action name: " + action);
        }
        return handle.invoke(controller);
    }

    @Override
    public String actionUriToViewName(String actionUri) {
        String actionName = this.actionUriToViewName.get(actionUri);
        return actionName != null ? actionName : actionUri;
    }

    private class MethodHandleInvoker
    implements ActionInvoker {
        private final MethodHandle handle;

        public MethodHandleInvoker(MethodHandle handle) {
            this.handle = handle;
        }

        @Override
        public Object invoke(Object controller) throws Throwable {
            return this.handle.invoke(controller);
        }
    }

    private class ReflectionInvoker
    implements ActionInvoker {
        private final Method method;

        public ReflectionInvoker(Method method) {
            this.method = method;
            ReflectionUtils.makeAccessible((Method)method);
        }

        @Override
        public Object invoke(Object controller) throws Throwable {
            return this.method.invoke(controller, new Object[0]);
        }
    }

    private static interface ActionInvoker {
        public Object invoke(Object var1) throws Throwable;
    }
}

