/*
 * Decompiled with CFR 0.152.
 */
package org.grails.plugins;

import grails.config.Config;
import grails.plugins.PluginFilter;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.grails.plugins.ExcludingPluginFilter;
import org.grails.plugins.IdentityPluginFilter;
import org.grails.plugins.IncludingPluginFilter;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class PluginFilterRetriever {
    public PluginFilter getPluginFilter(Config config) {
        Assert.notNull((Object)config);
        Object includes = config.getProperty("grails.plugin.includes", Object.class, null);
        Object excludes = config.getProperty("grails.plugin.excludes", Object.class, null);
        return this.getPluginFilter(includes, excludes);
    }

    PluginFilter getPluginFilter(Object includes, Object excludes) {
        PluginFilter pluginFilter = null;
        if (includes != null) {
            if (includes instanceof Collection) {
                pluginFilter = new IncludingPluginFilter((Set)new HashSet((Collection)includes));
            } else {
                String[] includesArray = StringUtils.commaDelimitedListToStringArray((String)includes.toString());
                pluginFilter = new IncludingPluginFilter(includesArray);
            }
        } else if (excludes != null) {
            if (excludes instanceof Collection) {
                pluginFilter = new ExcludingPluginFilter((Set)new HashSet((Collection)excludes));
            } else {
                String[] excludesArray = StringUtils.commaDelimitedListToStringArray((String)excludes.toString());
                pluginFilter = new ExcludingPluginFilter(excludesArray);
            }
        } else {
            pluginFilter = new IdentityPluginFilter();
        }
        return pluginFilter;
    }
}

