/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.logging.log4j;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.springframework.boot.logging.LogFile;
import org.springframework.boot.logging.LogLevel;
import org.springframework.boot.logging.LoggingInitializationContext;
import org.springframework.boot.logging.Slf4JLoggingSystem;
import org.springframework.util.Assert;
import org.springframework.util.Log4jConfigurer;
import org.springframework.util.StringUtils;

@Deprecated
public class Log4JLoggingSystem
extends Slf4JLoggingSystem {
    private static final Map<LogLevel, Level> LEVELS;

    public Log4JLoggingSystem(ClassLoader classLoader) {
        super(classLoader);
    }

    @Override
    protected String[] getStandardConfigLocations() {
        return new String[]{"log4j.xml", "log4j.properties"};
    }

    @Override
    public void beforeInitialize() {
        super.beforeInitialize();
        LogManager.getRootLogger().setLevel(Level.FATAL);
    }

    @Override
    protected void loadDefaults(LoggingInitializationContext initializationContext, LogFile logFile) {
        if (logFile != null) {
            this.loadConfiguration(this.getPackagedConfigFile("log4j-file.properties"), logFile);
        } else {
            this.loadConfiguration(this.getPackagedConfigFile("log4j.properties"), logFile);
        }
    }

    @Override
    protected void loadConfiguration(LoggingInitializationContext initializationContext, String location, LogFile logFile) {
        this.loadConfiguration(location, logFile);
    }

    protected void loadConfiguration(String location, LogFile logFile) {
        Assert.notNull((Object)location, (String)"Location must not be null");
        try {
            Log4jConfigurer.initLogging((String)location);
        }
        catch (Exception ex) {
            throw new IllegalStateException("Could not initialize Log4J logging from " + location, ex);
        }
    }

    @Override
    protected void reinitialize(LoggingInitializationContext initializationContext) {
        this.loadConfiguration(this.getSelfInitializationConfig(), null);
    }

    @Override
    public void setLogLevel(String loggerName, LogLevel level) {
        Logger logger = StringUtils.hasLength((String)loggerName) ? LogManager.getLogger((String)loggerName) : LogManager.getRootLogger();
        logger.setLevel(LEVELS.get((Object)level));
    }

    @Override
    public Runnable getShutdownHandler() {
        return new ShutdownHandler();
    }

    static {
        HashMap<LogLevel, Level> levels = new HashMap<LogLevel, Level>();
        levels.put(LogLevel.TRACE, Level.TRACE);
        levels.put(LogLevel.DEBUG, Level.DEBUG);
        levels.put(LogLevel.INFO, Level.INFO);
        levels.put(LogLevel.WARN, Level.WARN);
        levels.put(LogLevel.ERROR, Level.ERROR);
        levels.put(LogLevel.FATAL, Level.FATAL);
        levels.put(LogLevel.OFF, Level.OFF);
        LEVELS = Collections.unmodifiableMap(levels);
    }

    private static final class ShutdownHandler
    implements Runnable {
        private ShutdownHandler() {
        }

        @Override
        public void run() {
            LogManager.shutdown();
        }
    }
}

