/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.rtf.rtflib.rtfdoc;

import java.util.LinkedList;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfAttributes;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfSpaceSplitter;

public class RtfSpaceManager {
    private LinkedList blockAttributes = new LinkedList();
    private LinkedList inlineAttributes = new LinkedList();
    private int accumulatedSpace;

    public void stopUpdatingSpaceBefore() {
        for (RtfSpaceSplitter splitter : this.blockAttributes) {
            if (!splitter.isBeforeCadidateSet()) continue;
            splitter.stopUpdatingSpaceBefore();
        }
    }

    public void setCandidate(RtfAttributes attrs) {
        for (RtfSpaceSplitter splitter : this.blockAttributes) {
            splitter.setSpaceBeforeCandidate(attrs);
            splitter.setSpaceAfterCandidate(attrs);
        }
    }

    public RtfSpaceSplitter pushRtfSpaceSplitter(RtfAttributes attrs) {
        RtfSpaceSplitter splitter = new RtfSpaceSplitter(attrs, this.accumulatedSpace);
        this.accumulatedSpace = 0;
        this.blockAttributes.addLast(splitter);
        return splitter;
    }

    public void popRtfSpaceSplitter() {
        if (!this.blockAttributes.isEmpty()) {
            RtfSpaceSplitter splitter = (RtfSpaceSplitter)this.blockAttributes.removeLast();
            this.accumulatedSpace += splitter.flush();
        }
    }

    public void pushInlineAttributes(RtfAttributes attrs) {
        this.inlineAttributes.addLast(attrs);
    }

    public void popInlineAttributes() {
        if (!this.inlineAttributes.isEmpty()) {
            this.inlineAttributes.removeLast();
        }
    }

    public RtfAttributes getLastInlineAttribute() {
        return (RtfAttributes)this.inlineAttributes.getLast();
    }
}

