/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.net.sf.retrotranslator.runtime.format;

import java.text.DecimalFormatSymbols;
import java.util.Locale;
import org.mozilla.javascript.net.sf.retrotranslator.runtime.format.Conversion;
import org.mozilla.javascript.net.sf.retrotranslator.runtime.java.util.FormatFlagsConversionMismatchException_;
import org.mozilla.javascript.net.sf.retrotranslator.runtime.java.util.IllegalFormatConversionException_;
import org.mozilla.javascript.net.sf.retrotranslator.runtime.java.util.IllegalFormatFlagsException_;
import org.mozilla.javascript.net.sf.retrotranslator.runtime.java.util.IllegalFormatPrecisionException_;
import org.mozilla.javascript.net.sf.retrotranslator.runtime.java.util.IllegalFormatWidthException_;
import org.mozilla.javascript.net.sf.retrotranslator.runtime.java.util.MissingFormatArgumentException_;
import org.mozilla.javascript.net.sf.retrotranslator.runtime.java.util.MissingFormatWidthException_;
import org.mozilla.javascript.net.sf.retrotranslator.runtime.java.util.UnknownFormatConversionException_;

public abstract class FormatContext {
    private static final DecimalFormatSymbols US_SYMBOLS = new DecimalFormatSymbols(Locale.US);
    private Locale locale;
    private DecimalFormatSymbols symbols;
    private Object[] arguments;
    private int effectiveIndex;
    private int ordinaryIndex;
    private boolean effectiveIndexComputed;
    private String specifier;
    private int explicitIndex;
    private String flags;
    private int width;
    private int precision;
    private String conversion;
    private String format;
    private int position;

    protected FormatContext(Locale locale) {
        this.locale = locale;
    }

    public abstract void append(char var1);

    public abstract void append(String var1);

    public abstract void append(String var1, int var2, int var3);

    public abstract boolean writeFormattable();

    public void printf(String format, Object[] args) {
        int index;
        this.format = format;
        this.arguments = args;
        this.effectiveIndex = 0;
        this.ordinaryIndex = 0;
        this.position = 0;
        while ((index = format.indexOf(37, this.position)) >= 0) {
            this.append(format, this.position, index);
            this.scanOptions(index);
            this.effectiveIndexComputed = false;
            this.specifier = format.substring(index, this.position);
            Conversion instance = Conversion.getInstance(this.conversion);
            if (instance == null) {
                throw new UnknownFormatConversionException_(this.conversion);
            }
            instance.format(this);
        }
        this.append(format, this.position, format.length());
    }

    private void scanOptions(int index) {
        this.position = index + 1;
        try {
            this.scanExplicitIndex();
            this.scanFlags();
            this.scanWidth();
            this.scanPrecision();
            this.scanConversion();
        }
        catch (IndexOutOfBoundsException e) {
            throw new UnknownFormatConversionException_(this.format.substring(index));
        }
    }

    private void scanExplicitIndex() {
        int index = FormatContext.skipDigits(this.format, this.position);
        if (index > this.position && this.format.charAt(index) == '$') {
            this.explicitIndex = FormatContext.parse(this.format, this.position, index);
            this.position = index + 1;
        } else {
            this.explicitIndex = -1;
        }
    }

    private void scanFlags() {
        int index = FormatContext.skipFlags(this.format, this.position);
        if (index > this.position) {
            this.flags = this.format.substring(this.position, index);
            this.position = index;
        } else {
            this.flags = "";
        }
    }

    private void scanWidth() {
        int index = FormatContext.skipDigits(this.format, this.position);
        if (index > this.position) {
            this.width = FormatContext.parse(this.format, this.position, index);
            this.position = index;
        } else {
            this.width = -1;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void scanPrecision() {
        if (this.format.charAt(this.position) == '.') {
            ++this.position;
            int index = FormatContext.skipDigits(this.format, this.position);
            if (index <= this.position) throw new IndexOutOfBoundsException();
            this.precision = FormatContext.parse(this.format, this.position, index);
            this.position = index;
            return;
        } else {
            this.precision = -1;
        }
    }

    private void scanConversion() {
        char c = this.format.charAt(this.position);
        int endIndex = c == 't' || c == 'T' ? this.position + 2 : this.position + 1;
        this.conversion = this.format.substring(this.position, endIndex);
        this.position = endIndex;
    }

    private static int skipDigits(String s, int index) {
        char c = s.charAt(index);
        while (c >= '0' && c <= '9') {
            c = s.charAt(++index);
        }
        return index;
    }

    private static int skipFlags(String s, int index) {
        char c = s.charAt(index);
        while (c == '-' || c == '#' || c == '+' || c == ' ' || c == '0' || c == ',' || c == '(' || c == '<') {
            c = s.charAt(++index);
        }
        return index;
    }

    private static Integer parse(String format, int beginIndex, int endIndex) {
        return Integer.valueOf(format.substring(beginIndex, endIndex));
    }

    private char getConversionType() {
        return this.conversion.charAt(0);
    }

    public int getWidth() {
        return this.width;
    }

    public int getPrecision() {
        return this.precision;
    }

    public int getNumberPrecision() {
        return this.precision >= 0 ? this.precision : 6;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public DecimalFormatSymbols getSymbols(boolean localized) {
        if (localized && this.locale != null) {
            if (this.symbols == null) {
                this.symbols = new DecimalFormatSymbols(this.locale);
            }
            return this.symbols;
        }
        return US_SYMBOLS;
    }

    public IllegalFormatConversionException_ getConversionException() {
        return new IllegalFormatConversionException_(this.getConversionType(), this.getArgument().getClass());
    }

    public boolean isUpperCase() {
        return Character.isUpperCase(this.getConversionType());
    }

    public boolean isFlag(char c) {
        return this.flags.indexOf(c) >= 0;
    }

    public Object getArgument() {
        if (!this.effectiveIndexComputed) {
            this.computeEffectiveIndex();
            this.effectiveIndexComputed = true;
        }
        return this.arguments[this.effectiveIndex - 1];
    }

    private void computeEffectiveIndex() {
        if (this.flags.indexOf(60) < 0) {
            int n = this.effectiveIndex = this.explicitIndex != -1 ? this.explicitIndex : (this.ordinaryIndex = this.ordinaryIndex + 1);
        }
        if (this.arguments == null || this.effectiveIndex == 0 || this.effectiveIndex > this.arguments.length) {
            throw new MissingFormatArgumentException_(this.specifier);
        }
    }

    public void writeRestricted(String s) {
        this.writePadded(this.precision != -1 && this.precision < s.length() ? s.substring(0, this.precision) : s);
    }

    public void writePadded(String s) {
        if (this.isFlag('-')) {
            this.writeCaseSensitive(s);
            this.writePadding(s);
        } else {
            this.writePadding(s);
            this.writeCaseSensitive(s);
        }
    }

    private void writePadding(String s) {
        for (int i = this.width - s.length(); i > 0; --i) {
            this.append(' ');
        }
    }

    private void writeCaseSensitive(String s) {
        if (this.isUpperCase()) {
            this.append(s.toUpperCase());
        } else {
            this.append(s);
        }
    }

    public void assertNoFlag(char flag) {
        if (this.isFlag(flag)) {
            throw new FormatFlagsConversionMismatchException_(this.flags, this.getConversionType());
        }
    }

    public void assertNoPrecision() {
        if (this.precision != -1) {
            throw new IllegalFormatPrecisionException_(this.precision);
        }
    }

    public void assertNoWidth() {
        if (this.width != -1) {
            throw new IllegalFormatWidthException_(this.width);
        }
    }

    public void checkWidth() {
        if ((this.isFlag('-') || this.isFlag('0')) && this.width == -1) {
            throw new MissingFormatWidthException_(this.specifier);
        }
    }

    public void checkFlags() {
        if (this.isFlag('+') && this.isFlag(' ') || this.isFlag('-') && this.isFlag('0')) {
            throw new IllegalFormatFlagsException_(this.flags);
        }
    }
}

