#!/bin/sh
export PATH='/usr/lib/distcc/bin:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: shake
version: 0.15.5
id: shake-0.15.5-47395b809e3caeda7a5f7c268b02d6bc
key: shake_1SB55l08Kut4j6TyxgsabX
license: BSD3
copyright: Neil Mitchell 2011-2015
maintainer: Neil Mitchell <ndmitchell@gmail.com>
homepage: http://shakebuild.com
synopsis: Build system library, like Make, but more accurate dependencies.
description:
    Shake is a Haskell library for writing build systems - designed as a
    replacement for @make@. See "Development.Shake" for an introduction,
    including an example. Further examples are included in the Cabal tarball,
    under the @Examples@ directory. The homepage contains links to a user
    manual, an academic paper and further information:
    <http://shakebuild.com>
    .
    To use Shake the user writes a Haskell program
    that imports "Development.Shake", defines some build rules, and calls
    the '\''Development.Shake.shakeArgs'\'' function. Thanks to do notation and infix
    operators, a simple Shake build system
    is not too dissimilar from a simple Makefile. However, as build systems
    get more complex, Shake is able to take advantage of the excellent
    abstraction facilities offered by Haskell and easily support much larger
    projects. The Shake library provides all the standard features available in other
    build systems, including automatic parallelism and minimal rebuilds.
    Shake also provides more accurate dependency tracking, including seamless
    support for generated files, and dependencies on system information
    (e.g. compiler version).
category: Development, Shake
author: Neil Mitchell <ndmitchell@gmail.com>
exposed: True
exposed-modules:
    Development.Shake Development.Shake.Classes
    Development.Shake.Command Development.Shake.Config
    Development.Shake.FilePath Development.Shake.Rule
    Development.Shake.Util
hidden-modules: Development.Ninja.Env Development.Ninja.Lexer
                Development.Ninja.Parse Development.Ninja.Type
                Development.Shake.Args Development.Shake.ByteString
                Development.Shake.Core Development.Shake.Database
                Development.Shake.Demo Development.Shake.Derived
                Development.Shake.Errors Development.Shake.FileInfo
                Development.Shake.FilePattern Development.Shake.Monad
                Development.Shake.Pool Development.Shake.Profile
                Development.Shake.Progress Development.Shake.Resource
                Development.Shake.Rules.Directory Development.Shake.Rules.File
                Development.Shake.Rules.Files Development.Shake.Rules.Oracle
                Development.Shake.Rules.OrderOnly Development.Shake.Rules.Rerun
                Development.Shake.Shake Development.Shake.Special
                Development.Shake.Storage Development.Shake.Types
                Development.Shake.Value General.Bilist General.Binary
                General.Cleanup General.Concurrent General.Extra General.Intern
                General.Process General.String General.Template General.Timing
                Paths_shake
trusted: False
import-dirs: /usr/lib/ghc-7.10.3/site-local/shake-0.15.5
library-dirs: /usr/lib/ghc-7.10.3/site-local/shake-0.15.5
data-dir: /usr/share/arm-linux-ghc-7.10.3/shake-0.15.5
hs-libraries: HSshake-0.15.5-1SB55l08Kut4j6TyxgsabX
depends:
    base-4.8.2.0-2f1f71a7fcf013cd47fd21f489064f9a
    binary-0.7.5.0-29f7044fa0b12dc5c2dcec897db5c464
    bytestring-0.10.6.0-3b51e35daa3fe2a56ecd3687fb389cdc
    deepseq-1.4.1.1-3975618f889b45239daa47b7443eaeee
    directory-1.2.2.0-17b2023f9d7e8036d19e6b52b4f75c98
    extra-1.4.3-ab419342055a04bda9f8a7a264d348c1
    filepath-1.4.0.0-73e0bec80594160bf6dd6cb25217c6bf
    hashable-1.2.4.0-f83fcc5c92d0a1ea59927aca6baa3161
    js-flot-0.8.3-f4527abded51f454b66546bc733ec63f
    js-jquery-1.12.1-cb4fee5dc2f301f8b48d430c321cbb84
    old-time-1.1.0.3-91625432bd7c61d043f9b743fb82dcf7
    process-1.2.3.0-21d25f1d78aeea6e68f1c768841f9794
    random-1.1-41a0a7ecd483c665a5c3a093a5be2968
    time-1.5.0.1-cf94b0d806e26f6c4e356671290061b2
    transformers-0.4.2.0-252429dba576bc247c1932da496e0a3f
    unix-2.7.1.0-a583968f8d5891c6bf334fddb26b19a6
    unordered-containers-0.2.7.0-03f1d2fb96e30aca19bb1467e9476c22
    utf8-string-1.0.1.1-55be01444fdc59e978af349d80596373
haddock-interfaces: /usr/share/doc/haskell-shake/html/shake.haddock
haddock-html: /usr/share/doc/haskell-shake/html
' | '/usr/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-db' "$@"
