#!/bin/sh
export PATH='/usr/lib/distcc/bin:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: tls
version: 1.3.4
id: tls-1.3.4-c1ffd726a31a364e53d7dbf7360c4f21
key: tls_Fw43CpZSfHUFGOtrNagnxE
license: BSD3
copyright: Vincent Hanquez <vincent@snarc.org>
maintainer: Vincent Hanquez <vincent@snarc.org>
stability: experimental
homepage: http://github.com/vincenthz/hs-tls
synopsis: TLS/SSL protocol native implementation (Server and Client)
description:
    Native Haskell TLS and SSL protocol implementation for server and client.
    .
    This provides a high-level implementation of a sensitive security protocol,
    eliminating a common set of security issues through the use of the advanced
    type system, high level constructions and common Haskell features.
    .
    Currently implement the SSL3.0, TLS1.0, TLS1.1 and TLS1.2 protocol,
    and support RSA and Ephemeral (Elliptic curve and regular) Diffie Hellman key exchanges,
    and many extensions.
    .
    Some debug tools linked with tls, are available through the
    <http://hackage.haskell.org/package/tls-debug/>.
category: Network
author: Vincent Hanquez <vincent@snarc.org>
exposed: True
exposed-modules:
    Network.TLS Network.TLS.Cipher Network.TLS.Compression
    Network.TLS.Internal Network.TLS.Extra Network.TLS.Extra.Cipher
hidden-modules: Network.TLS.Cap Network.TLS.Struct Network.TLS.Core
                Network.TLS.Context Network.TLS.Context.Internal
                Network.TLS.Credentials Network.TLS.Backend Network.TLS.Crypto
                Network.TLS.Crypto.DH Network.TLS.Crypto.ECDH Network.TLS.ErrT
                Network.TLS.Extension Network.TLS.Extension.EC
                Network.TLS.Handshake Network.TLS.Handshake.Common
                Network.TLS.Handshake.Certificate Network.TLS.Handshake.Key
                Network.TLS.Handshake.Client Network.TLS.Handshake.Server
                Network.TLS.Handshake.Process Network.TLS.Handshake.Signature
                Network.TLS.Handshake.State Network.TLS.Hooks Network.TLS.IO
                Network.TLS.MAC Network.TLS.Measurement Network.TLS.Packet
                Network.TLS.Parameters Network.TLS.Record Network.TLS.Record.Types
                Network.TLS.Record.Engage Network.TLS.Record.Disengage
                Network.TLS.Record.State Network.TLS.RNG Network.TLS.State
                Network.TLS.Session Network.TLS.Sending Network.TLS.Receiving
                Network.TLS.Util Network.TLS.Util.ASN1
                Network.TLS.Util.Serialization Network.TLS.Types Network.TLS.Wire
                Network.TLS.X509
trusted: False
import-dirs: /usr/lib/ghc-7.10.3/site-local/tls-1.3.4
library-dirs: /usr/lib/ghc-7.10.3/site-local/tls-1.3.4
data-dir: /usr/share/arm-linux-ghc-7.10.3/tls-1.3.4
hs-libraries: HStls-1.3.4-Fw43CpZSfHUFGOtrNagnxE
depends:
    asn1-encoding-0.9.3-973a6b8f38afc857f3a60ad311c8ee45
    asn1-types-0.3.2-3969820adc8283f126affe054010f830
    async-2.1.0-b35f12010d11213b63d33c4f0cc6089c
    base-4.8.2.0-2f1f71a7fcf013cd47fd21f489064f9a
    bytestring-0.10.6.0-3b51e35daa3fe2a56ecd3687fb389cdc
    cereal-0.5.1.0-2c7be146776a4abf674d1ac9e0ccfc13
    cryptonite-0.13-349d06636b05d6ecd7f57ca79abfe077
    data-default-class-0.0.1-fcbab95490d730dd2489b628499587cd
    memory-0.11-3a745e41fe78387f608c420e9b455d25
    mtl-2.2.1-c516313407bc17046965067cb7cbb6a0
    network-2.6.2.1-602ee4a12c5a174f6683a75303a065d3
    transformers-0.4.2.0-252429dba576bc247c1932da496e0a3f
    x509-1.6.3-9c5cbae50b7250847fc648c7f7d122e6
    x509-store-1.6.1-741461c55f7edc5697c99a37f0436ee6
    x509-validation-1.6.3-47849fe369535aae4a3b7e2d99568d36
haddock-interfaces: /usr/share/doc/haskell-tls/html/tls.haddock
haddock-html: /usr/share/doc/haskell-tls/html
' | '/usr/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-db' "$@"
