/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.renderbio;

import org.jmol.api.Interface;
import org.jmol.c.STR;
import org.jmol.modelsetbio.ProteinStructure;
import org.jmol.renderbio.NucleicRenderer;
import org.jmol.renderbio.RocketsRenderer;
import org.jmol.shapebio.BioShape;

public class CartoonRenderer
extends RocketsRenderer {
    private NucleicRenderer nucleicRenderer;

    @Override
    protected void renderBioShape(BioShape bioShape) {
        if (!this.setupRR(bioShape, false)) {
            return;
        }
        if (this.isNucleic || this.isPhosphorusOnly) {
            if (this.nucleicRenderer == null) {
                this.nucleicRenderer = (NucleicRenderer)Interface.getInterface("org.jmol.renderbio.NucleicRenderer", this.vwr, "render");
            }
            this.calcScreenControlPoints();
            this.nucleicRenderer.renderNucleic(this);
            return;
        }
        boolean bl = this.vwr.getBoolean(603979820);
        if (this.helixRockets != bl) {
            bioShape.falsifyMesh();
            this.helixRockets = bl;
        }
        this.ribbonTopScreens = this.calcScreens(0.5f, this.mads);
        this.ribbonBottomScreens = this.calcScreens(-0.5f, this.mads);
        this.calcRopeMidPoints();
        this.renderProtein();
        this.vwr.freeTempPoints(this.cordMidPoints);
        this.vwr.freeTempPoints(this.ribbonTopScreens);
        this.vwr.freeTempPoints(this.ribbonBottomScreens);
    }

    private void renderProtein() {
        boolean bl = false;
        boolean bl2 = false;
        ProteinStructure proteinStructure = null;
        boolean bl3 = this.helixRockets || !this.renderArrowHeads;
        boolean bl4 = false;
        int n = this.monomerCount;
        while (--n >= 0) {
            boolean bl5;
            ProteinStructure proteinStructure2;
            if (this.monomers[n].getStructure() != null && !(this.monomers[n].getStructure() instanceof ProteinStructure)) {
                System.out.println("BUG HERE IN CARTOONRENDERER");
            }
            if ((proteinStructure2 = (ProteinStructure)this.monomers[n].getStructure()) != proteinStructure) {
                bl = false;
            }
            proteinStructure = proteinStructure2;
            boolean bl6 = this.structureTypes[n] == STR.HELIX;
            boolean bl7 = bl5 = this.structureTypes[n] == STR.SHEET;
            if (this.bsVisible.get(n)) {
                if (bl6 && bl3) {
                    bl4 = true;
                } else if (bl5 || bl6) {
                    if (bl && bl5 || bl2 && bl6) {
                        this.renderHermiteRibbon(true, n, true);
                    } else {
                        this.renderHermiteArrowHead(n);
                    }
                } else {
                    this.renderHermiteConic(n, true, 7);
                }
            }
            bl = bl5;
            bl2 = bl6 && !this.helixRockets;
        }
        if (bl4) {
            this.renderRockets();
        }
    }
}

