/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.io;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javajs.api.GenericBinaryDocument;
import javajs.api.GenericPlatform;
import javajs.api.GenericZipTools;
import javajs.util.AU;
import javajs.util.Lst;
import javajs.util.OC;
import javajs.util.PT;
import javajs.util.Rdr;
import javajs.util.SB;
import org.jmol.adapter.smarter.AtomSetCollection;
import org.jmol.api.Interface;
import org.jmol.api.JmolAdapter;
import org.jmol.util.Logger;
import org.jmol.viewer.FileManager;
import org.jmol.viewer.Viewer;

public class JmolUtil {
    public Object getImage(Viewer viewer, Object object, String string, boolean bl) {
        Object object2 = null;
        Object[] objectArray = null;
        GenericPlatform genericPlatform = viewer.apiPlatform;
        boolean bl2 = false;
        String string2 = "" + object;
        if (object instanceof String) {
            boolean bl3 = string2.toUpperCase().endsWith("BMP");
            if (bl || string2.indexOf("|") > 0 || bl3) {
                Object object3 = viewer.fm.getFileAsBytes(string2, null);
                if (!AU.isAB(object3)) {
                    return "" + object3;
                }
                if (viewer.isJS) {
                    objectArray = new Object[]{string, object, object3};
                } else {
                    object2 = genericPlatform.createImage(object3);
                }
            } else if (OC.urlTypeIndex(string2) >= 0) {
                if (viewer.isJS) {
                    objectArray = new Object[]{string, object, null};
                } else {
                    try {
                        object2 = genericPlatform.createImage(new URL((URL)null, string2, null));
                    }
                    catch (Exception exception) {
                        return "bad URL: " + string2;
                    }
                }
            } else {
                bl2 = true;
            }
        } else if (viewer.isJS) {
            objectArray = new Object[]{string, Rdr.guessMimeTypeForBytes((byte[])object), object};
        } else {
            bl2 = true;
        }
        if (bl2) {
            object2 = genericPlatform.createImage("\u0001close".equals(object) ? "\u0001close" + string : object);
        } else if (objectArray != null) {
            object2 = genericPlatform.createImage(objectArray);
        }
        if (object2 == null) {
            return null;
        }
        try {
            if (!genericPlatform.waitForDisplay(objectArray, object2)) {
                return null;
            }
            return genericPlatform.getImageWidth(object2) < 1 ? "invalid or missing image " + string2 : object2;
        }
        catch (Exception exception) {
            return exception.toString() + " opening " + string2;
        }
    }

    public Object getAtomSetCollectionOrBufferedReaderFromZip(Viewer viewer, InputStream inputStream, String string, String[] stringArray, Map<String, Object> map, int n, boolean bl) {
        Object object;
        boolean bl2;
        boolean bl3;
        String string2;
        boolean bl4;
        String string3;
        JmolAdapter jmolAdapter = viewer.getModelAdapter();
        boolean bl5 = n == 1;
        map.put("zipSet", string);
        String[] stringArray2 = (String[])map.get("subFileList");
        if (stringArray2 == null) {
            stringArray2 = this.getSpartanSubfiles(stringArray);
        }
        String string4 = string3 = stringArray2 == null || n >= stringArray2.length ? null : stringArray2[n];
        if (string3 != null && (string3.startsWith("/") || string3.startsWith("\\"))) {
            string3 = string3.substring(1);
        }
        int n2 = 0;
        if (string3 == null && map.containsKey("modelNumber") && (n2 = ((Integer)map.get("modelNumber")).intValue()) > 0 && bl5) {
            map.remove("modelNumber");
        }
        boolean bl6 = bl4 = (string2 = (String)map.get("manifest")) == null;
        if (bl4) {
            string2 = stringArray.length > 0 ? stringArray[0] : "";
        }
        boolean bl7 = bl3 = string2.length() > 0;
        if (bl3 && Logger.debugging) {
            Logger.debug("manifest for  " + string + ":\n" + string2);
        }
        boolean bl8 = string2.indexOf("IGNORE_ERRORS") >= 0;
        boolean bl9 = string2.indexOf("IGNORE_MANIFEST") >= 0;
        boolean bl10 = bl2 = string2.indexOf("EXCEPT_FILES") >= 0;
        if (bl9 || string3 != null) {
            bl3 = false;
        }
        if (bl4 && bl3 && (object = FileManager.getManifestScriptPath(string2)) != null) {
            return "NOTE: file recognized as a script file: " + string + (String)object + "\n";
        }
        object = new Lst();
        Hashtable<String[], Object> hashtable = bl3 ? new Hashtable<String[], Object>() : null;
        boolean bl11 = false;
        try {
            Object object2;
            Object object3;
            ZipEntry zipEntry;
            SB sB = this.isSpartanZip(stringArray) ? viewer.fm.getJmb().getSpartanData(inputStream, stringArray) : null;
            GenericZipTools genericZipTools = viewer.getJzt();
            if (sB != null) {
                BufferedReader bufferedReader = Rdr.getBR(sB.toString());
                if (bl) {
                    return bufferedReader;
                }
                Object object4 = jmolAdapter.getAtomSetCollectionFromReader(string, bufferedReader, map);
                if (object4 instanceof String) {
                    return object4;
                }
                if (object4 instanceof AtomSetCollection) {
                    AtomSetCollection atomSetCollection = (AtomSetCollection)object4;
                    if (atomSetCollection.errorMessage != null) {
                        if (bl8) {
                            return null;
                        }
                        return atomSetCollection.errorMessage;
                    }
                    return atomSetCollection;
                }
                if (bl8) {
                    return null;
                }
                return "unknown reader error";
            }
            if (inputStream instanceof BufferedInputStream) {
                inputStream = Rdr.getPngZipStream((BufferedInputStream)inputStream, true);
            }
            ZipInputStream zipInputStream = (ZipInputStream)((Object)genericZipTools.newZipInputStream(inputStream));
            if (bl3) {
                string2 = '|' + string2.replace('\r', '|').replace('\n', '|') + '|';
            }
            while ((zipEntry = zipInputStream.getNextEntry()) != null && (n2 <= 0 || ((ArrayList)object).size() < n2)) {
                Object object5;
                Object object6;
                if (zipEntry.isDirectory()) continue;
                object3 = zipEntry.getName();
                if (string3 != null && !object3.equals(string3)) continue;
                if (string3 != null) {
                    map.put("subFileName", string3);
                }
                if (object3.startsWith("JmolManifest") || bl3 && bl2 == string2.indexOf("|" + (String)object3 + "|") >= 0) continue;
                byte[] byArray = Rdr.getLimitedStreamBytes(zipInputStream, zipEntry.getSize());
                if (Rdr.isGzipB(byArray)) {
                    byArray = Rdr.getLimitedStreamBytes(genericZipTools.getUnGzippedInputStream(byArray), -1L);
                }
                if (Rdr.isZipB(byArray) || Rdr.isPngZipB(byArray)) {
                    object2 = Rdr.getBIS(byArray);
                    object6 = genericZipTools.getZipDirectoryAndClose((BufferedInputStream)object2, "JmolManifest");
                    object2 = Rdr.getBIS(byArray);
                    object5 = this.getAtomSetCollectionOrBufferedReaderFromZip(viewer, (InputStream)object2, string + "|" + (String)object3, (String[])object6, map, ++n, bl);
                    if (object5 instanceof String) {
                        if (bl8) continue;
                        return object5;
                    }
                    if (object5 instanceof AtomSetCollection || object5 instanceof Lst) {
                        if (bl3 && !bl2) {
                            hashtable.put((String[])object3, object5);
                            continue;
                        }
                        ((Lst)object).addLast(object5);
                        continue;
                    }
                    if (object5 instanceof BufferedReader) {
                        if (bl5) {
                            zipInputStream.close();
                        }
                        return object5;
                    }
                    if (bl8) continue;
                    zipInputStream.close();
                    return "unknown zip reader error";
                }
                if (Rdr.isPickleB(byArray)) {
                    object2 = Rdr.getBIS(byArray);
                    if (bl5) {
                        zipInputStream.close();
                    }
                    return object2;
                }
                if (Rdr.isCompoundDocumentB(byArray)) {
                    object6 = (GenericBinaryDocument)Interface.getInterface("javajs.util.CompoundDocument", viewer, "file");
                    object6.setStream(genericZipTools, Rdr.getBIS(byArray), true);
                    object2 = object6.getAllDataFiles("Molecule", "Input").toString();
                } else {
                    object2 = Rdr.fixUTF(byArray);
                }
                object6 = Rdr.getBR((String)object2);
                if (bl) {
                    if (bl5) {
                        zipInputStream.close();
                    }
                    return object6;
                }
                object5 = string + "|" + zipEntry.getName();
                Object object7 = jmolAdapter.getAtomSetCollectionFromReader((String)object5, object6, map);
                if (!(object7 instanceof AtomSetCollection)) {
                    if (bl8) continue;
                    zipInputStream.close();
                    return "" + object7;
                }
                if (bl3 && !bl2) {
                    hashtable.put((String[])object3, object7);
                } else {
                    ((Lst)object).addLast(object7);
                }
                AtomSetCollection atomSetCollection = (AtomSetCollection)object7;
                if (atomSetCollection.errorMessage == null || bl8) continue;
                zipInputStream.close();
                return atomSetCollection.errorMessage;
            }
            if (bl5) {
                zipInputStream.close();
            }
            if (bl3 && !bl2) {
                object3 = PT.split(string2, "|");
                for (int i = 0; i < ((String[])object3).length; ++i) {
                    object2 = object3[i];
                    if (((String)object2).length() == 0 || ((String)object2).indexOf("#") == 0) continue;
                    if (hashtable.containsKey(object2)) {
                        ((Lst)object).addLast(hashtable.get(object2));
                        continue;
                    }
                    if (!Logger.debugging) continue;
                    Logger.debug("manifested file " + (String)object2 + " was not found in " + string);
                }
            }
            if (!bl5) {
                return object;
            }
            Object object8 = object3 = ((ArrayList)object).size() == 1 && ((ArrayList)object).get(0) instanceof AtomSetCollection ? (AtomSetCollection)((ArrayList)object).get(0) : new AtomSetCollection("Array", null, null, (Lst<?>)object);
            if (object3.errorMessage != null) {
                if (bl8) {
                    return null;
                }
                return object3.errorMessage;
            }
            if (bl11) {
                n2 = 1;
            }
            if (n2 > 0 && n2 <= ((ArrayList)object).size()) {
                return ((ArrayList)object).get(n2 - 1);
            }
            return object3;
        }
        catch (Exception exception) {
            if (bl8) {
                return null;
            }
            Logger.error("" + exception);
            return "" + exception;
        }
        catch (Error error) {
            Logger.errorEx(null, error);
            return "" + error;
        }
    }

    public byte[] getCachedPngjBytes(FileManager fileManager, String string) {
        boolean bl;
        if (string.startsWith("file:///")) {
            string = "file:" + string.substring(7);
        }
        Logger.info("JmolUtil checking PNGJ cache for " + string);
        String string2 = this.shortSceneFilename(string);
        if (fileManager.pngjCache == null && !this.clearAndCachePngjFile(fileManager, new String[]{string, null})) {
            return null;
        }
        Map<String, Object> map = fileManager.pngjCache;
        boolean bl2 = bl = string.indexOf(".min.") >= 0;
        if (!bl) {
            String string3 = fileManager.getCanonicalName(Rdr.getZipRoot(string));
            if (!map.containsKey(string3) && !this.clearAndCachePngjFile(fileManager, new String[]{string, null})) {
                return null;
            }
            if (string.indexOf("|") < 0) {
                string2 = string3;
            }
        }
        if (map.containsKey(string2)) {
            Logger.info("FileManager using memory cache " + string2);
            return (byte[])fileManager.pngjCache.get(string2);
        }
        if (!bl || !this.clearAndCachePngjFile(fileManager, new String[]{string, null})) {
            return null;
        }
        Logger.info("FileManager using memory cache " + string2);
        return (byte[])map.get(string2);
    }

    private boolean clearAndCachePngjFile(FileManager fileManager, String[] stringArray) {
        fileManager.pngjCache = new Hashtable<String, Object>();
        if (stringArray == null || stringArray[0] == null) {
            return false;
        }
        stringArray[0] = Rdr.getZipRoot(stringArray[0]);
        String string = this.shortSceneFilename(stringArray[0]);
        Map<String, Object> map = fileManager.pngjCache;
        try {
            stringArray[1] = fileManager.vwr.getJzt().cacheZipContents(Rdr.getPngZipStream((BufferedInputStream)fileManager.getBufferedInputStreamOrErrorMessageFromName(stringArray[0], null, false, false, null, false, true), true), string, map, false);
        }
        catch (Exception exception) {
            return false;
        }
        if (stringArray[1] == null) {
            return false;
        }
        byte[] byArray = stringArray[1].getBytes();
        map.put(fileManager.getCanonicalName(stringArray[0]), byArray);
        if (string.indexOf("_scene_") >= 0) {
            map.put(this.shortSceneFilename(stringArray[0]), byArray);
            byArray = (byte[])map.remove(string + "|state.spt");
            if (byArray != null) {
                map.put(this.shortSceneFilename(stringArray[0] + "|state.spt"), byArray);
            }
        }
        return true;
    }

    private String shortSceneFilename(String string) {
        int n;
        int n2 = string.indexOf("_scene_") + 7;
        if (n2 < 7) {
            return string;
        }
        String string2 = "";
        if (string.endsWith("|state.spt")) {
            n = string.indexOf(46, n2);
            if (n < 0) {
                return string;
            }
            string2 = string.substring(n2, n);
        }
        n = string.lastIndexOf("|");
        return string.substring(0, n2) + string2 + (n > 0 ? string.substring(n) : "");
    }

    private String[] getSpartanSubfiles(String[] stringArray) {
        String[] stringArray2;
        String string;
        String string2 = string = stringArray.length < 2 ? null : stringArray[1];
        if (string == null || stringArray.length != 2 || !string.endsWith(".spardir/")) {
            stringArray2 = null;
        } else {
            String[] stringArray3 = new String[2];
            stringArray3[0] = "";
            stringArray2 = stringArray3;
            stringArray3[1] = PT.trim(string, "/");
        }
        return stringArray2;
    }

    private boolean isSpartanZip(String[] stringArray) {
        for (int i = 1; i < stringArray.length; ++i) {
            if (!stringArray[i].endsWith(".spardir/") && stringArray[i].indexOf("_spartandir") < 0) continue;
            return true;
        }
        return false;
    }
}

