/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.stdmenus;

import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.JMenuItem;
import org.parosproxy.paros.extension.ExtensionPopupMenuItem;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.model.Session;
import org.parosproxy.paros.view.View;
import org.zaproxy.zap.model.Context;
import org.zaproxy.zap.view.messagecontainer.MessageContainer;
import org.zaproxy.zap.view.popup.ExtensionPopupMenuMessageContainer;

public abstract class PopupContextMenuItemHolder
extends ExtensionPopupMenuMessageContainer {
    private static final long serialVersionUID = 2976582263073602339L;
    private String parentName;
    private List<ExtensionPopupMenuItem> subMenuItems = null;
    private boolean visibleItself;

    public PopupContextMenuItemHolder(String string, String string2) {
        super(string);
        this.parentName = string2;
        this.visibleItself = true;
    }

    public PopupContextMenuItemHolder(String string) {
        super("ContexMenuItemHolder");
        this.parentName = string;
        this.visibleItself = false;
    }

    @Override
    public String getParentMenuName() {
        return this.parentName;
    }

    @Override
    public int getParentMenuIndex() {
        return 0;
    }

    @Override
    public boolean isSubMenu() {
        return true;
    }

    private List<ExtensionPopupMenuItem> getSubmenuItems() {
        if (this.subMenuItems == null) {
            this.subMenuItems = new ArrayList<ExtensionPopupMenuItem>();
        }
        return this.subMenuItems;
    }

    @Override
    public boolean isEnableForMessageContainer(MessageContainer<?> messageContainer) {
        this.resetMenu();
        if (this.visibleItself) {
            return super.isEnableForMessageContainer(messageContainer);
        }
        return false;
    }

    private void resetMenu() {
        Vector<JMenuItem> vector = View.getSingleton().getPopupList();
        if (this.visibleItself) {
            this.removeAll();
        } else {
            for (ExtensionPopupMenuItem object2 : this.getSubmenuItems()) {
                vector.remove(object2);
            }
            this.subMenuItems.clear();
        }
        Session session = Model.getSingleton().getSession();
        List<Context> list = session.getContexts();
        for (Context context : list) {
            ExtensionPopupMenuItem extensionPopupMenuItem;
            if (this.visibleItself) {
                extensionPopupMenuItem = this.getPopupContextMenu(context, this.getText());
                this.add(extensionPopupMenuItem);
                continue;
            }
            extensionPopupMenuItem = this.getPopupContextMenu(context, this.parentName);
            extensionPopupMenuItem.setMenuIndex(this.getMenuIndex());
            vector.add(extensionPopupMenuItem);
            this.subMenuItems.add(extensionPopupMenuItem);
        }
    }

    public abstract ExtensionPopupMenuItem getPopupContextMenu(Context var1, String var2);
}

