/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.users;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.zaproxy.zap.extension.users.UsersTableModel;
import org.zaproxy.zap.users.User;

public class ContextUserAuthManager {
    private int contextId;
    private List<User> users;

    public ContextUserAuthManager(int n) {
        this.contextId = n;
        this.users = new ArrayList<User>();
    }

    public UsersTableModel getUsersModel() {
        return new UsersTableModel(this.users);
    }

    public int getContextId() {
        return this.contextId;
    }

    public List<User> getUsers() {
        return Collections.unmodifiableList(this.users);
    }

    public void setUsers(List<User> list) {
        this.users = new ArrayList<User>(list);
    }

    public void addUser(User user) {
        this.users.add(user);
    }

    public void removeUser(User user) {
        this.users.remove(user);
    }

    public User getUserById(int n) {
        for (User user : this.users) {
            if (user.getId() != n) continue;
            return user;
        }
        return null;
    }

    public boolean removeUserById(int n) {
        Iterator<User> iterator = this.users.iterator();
        while (iterator.hasNext()) {
            if (iterator.next().getId() != n) continue;
            iterator.remove();
            return true;
        }
        return false;
    }

    public void removeAllUsers() {
        this.users.clear();
    }
}

