/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.hsqldb.Database;
import org.hsqldb.HsqlException;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.Session;
import org.hsqldb.Statement;
import org.hsqldb.Table;
import org.hsqldb.error.Error;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.HashMappedList;
import org.hsqldb.lib.LineGroupReader;
import org.hsqldb.navigator.RowSetNavigator;
import org.hsqldb.persist.LobStore;
import org.hsqldb.persist.LobStoreInJar;
import org.hsqldb.persist.LobStoreMem;
import org.hsqldb.persist.LobStoreRAFile;
import org.hsqldb.result.Result;
import org.hsqldb.result.ResultLob;
import org.hsqldb.result.ResultMetaData;
import org.hsqldb.store.ValuePool;
import org.hsqldb.types.BinaryData;
import org.hsqldb.types.BlobData;
import org.hsqldb.types.BlobDataID;
import org.hsqldb.types.ClobData;
import org.hsqldb.types.ClobDataID;
import org.hsqldb.types.Collation;

public class LobManager {
    static final String resourceFileName = "/org/hsqldb/resources/lob-schema.sql";
    static final String[] starters = new String[]{"/*"};
    Database database;
    LobStore lobStore;
    Session sysLobSession;
    volatile boolean storeModified;
    byte[] byteBuffer;
    int lobBlockSize;
    int totalBlockLimitCount = Integer.MAX_VALUE;
    Statement getLob;
    Statement getLobPart;
    Statement deleteLobCall;
    Statement deleteLobPartCall;
    Statement divideLobPartCall;
    Statement createLob;
    Statement createLobPartCall;
    Statement updateLobLength;
    Statement updateLobUsage;
    Statement getNextLobId;
    Statement deleteUnusedLobs;
    Statement getLobCount;
    boolean usageCountChanged;
    ReadWriteLock lock = new ReentrantReadWriteLock();
    Lock writeLock = this.lock.writeLock();
    private static final String existsBlocksSQL = "SELECT * FROM SYSTEM_LOBS.BLOCKS LIMIT 1";
    private static final String initialiseBlocksSQL = "INSERT INTO SYSTEM_LOBS.BLOCKS VALUES(?,?,?)";
    private static final String getLobSQL = "SELECT * FROM SYSTEM_LOBS.LOB_IDS WHERE LOB_ID = ?";
    private static final String getLobPartSQL = "SELECT * FROM SYSTEM_LOBS.LOBS WHERE LOB_ID = ? AND BLOCK_OFFSET + BLOCK_COUNT > ? AND BLOCK_OFFSET < ? ORDER BY BLOCK_OFFSET";
    private static final String deleteLobPartCallSQL = "CALL SYSTEM_LOBS.DELETE_BLOCKS(?,?,?,?)";
    private static final String createLobSQL = "INSERT INTO SYSTEM_LOBS.LOB_IDS VALUES(?, ?, ?, ?)";
    private static final String updateLobLengthSQL = "UPDATE SYSTEM_LOBS.LOB_IDS SET LOB_LENGTH = ? WHERE LOB_ID = ?";
    private static final String createLobPartCallSQL = "CALL SYSTEM_LOBS.ALLOC_BLOCKS(?, ?, ?)";
    private static final String divideLobPartCallSQL = "CALL SYSTEM_LOBS.DIVIDE_BLOCK(?, ?)";
    private static final String getSpanningBlockSQL = "SELECT * FROM SYSTEM_LOBS.LOBS WHERE LOB_ID = ? AND ? > BLOCK_OFFSET AND ? < BLOCK_OFFSET + BLOCK_COUNT";
    private static final String updateLobUsageSQL = "UPDATE SYSTEM_LOBS.LOB_IDS SET LOB_USAGE_COUNT = (CASE LOB_USAGE_COUNT WHEN 2147483647 THEN 0 ELSE LOB_USAGE_COUNT END) + ? WHERE LOB_ID = ?";
    private static final String getNextLobIdSQL = "VALUES NEXT VALUE FOR SYSTEM_LOBS.LOB_ID";
    private static final String deleteLobCallSQL = "CALL SYSTEM_LOBS.DELETE_LOB(?, ?)";
    private static final String deleteUnusedCallSQL = "CALL SYSTEM_LOBS.DELETE_UNUSED_LOBS(?)";
    private static final String getLobCountSQL = "SELECT COUNT(*) FROM SYSTEM_LOBS.LOB_IDS";

    public LobManager(Database database) {
        this.database = database;
    }

    public void lock() {
        this.writeLock.lock();
    }

    public void unlock() {
        this.writeLock.unlock();
    }

    public void createSchema() {
        this.sysLobSession = this.database.sessionManager.getSysLobSession();
        InputStream inputStream = (InputStream)AccessController.doPrivileged(new PrivilegedAction(){

            public InputStream run() {
                return this.getClass().getResourceAsStream(LobManager.resourceFileName);
            }
        });
        InputStreamReader inputStreamReader = null;
        try {
            inputStreamReader = new InputStreamReader(inputStream, "ISO-8859-1");
        }
        catch (Exception exception) {
            // empty catch block
        }
        LineNumberReader lineNumberReader = new LineNumberReader(inputStreamReader);
        LineGroupReader lineGroupReader = new LineGroupReader(lineNumberReader, starters);
        HashMappedList hashMappedList = lineGroupReader.getAsMap();
        lineGroupReader.close();
        String string = (String)hashMappedList.get("/*lob_schema_definition*/");
        Statement statement = this.sysLobSession.compileStatement(string);
        Result result = statement.execute(this.sysLobSession);
        if (result.isError()) {
            throw result.getException();
        }
        HsqlNameManager.HsqlName hsqlName = this.database.schemaManager.getSchemaHsqlName("SYSTEM_LOBS");
        Table table = this.database.schemaManager.getTable(this.sysLobSession, "BLOCKS", "SYSTEM_LOBS");
        this.compileStatements();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void compileStatements() {
        this.writeLock.lock();
        try {
            this.getLob = this.sysLobSession.compileStatement(getLobSQL);
            this.getLobPart = this.sysLobSession.compileStatement(getLobPartSQL);
            this.createLob = this.sysLobSession.compileStatement(createLobSQL);
            this.createLobPartCall = this.sysLobSession.compileStatement(createLobPartCallSQL);
            this.divideLobPartCall = this.sysLobSession.compileStatement(divideLobPartCallSQL);
            this.deleteLobCall = this.sysLobSession.compileStatement(deleteLobCallSQL);
            this.deleteLobPartCall = this.sysLobSession.compileStatement(deleteLobPartCallSQL);
            this.updateLobLength = this.sysLobSession.compileStatement(updateLobLengthSQL);
            this.updateLobUsage = this.sysLobSession.compileStatement(updateLobUsageSQL);
            this.getNextLobId = this.sysLobSession.compileStatement(getNextLobIdSQL);
            this.deleteUnusedLobs = this.sysLobSession.compileStatement(deleteUnusedCallSQL);
            this.getLobCount = this.sysLobSession.compileStatement(getLobCountSQL);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void initialiseLobSpace() {
        Statement statement = this.sysLobSession.compileStatement(existsBlocksSQL);
        Result result = statement.execute(this.sysLobSession);
        RowSetNavigator rowSetNavigator = result.getNavigator();
        int n = rowSetNavigator.getSize();
        if (n > 0) {
            return;
        }
        statement = this.sysLobSession.compileStatement(initialiseBlocksSQL);
        Object[] objectArray = new Object[]{ValuePool.INTEGER_0, ValuePool.getInt(this.totalBlockLimitCount), ValuePool.getLong(0L)};
        this.sysLobSession.executeCompiledStatement(statement, objectArray);
    }

    public void open() {
        this.lobBlockSize = this.database.logger.getLobBlockSize();
        if (this.database.getType() == "res:") {
            this.lobStore = new LobStoreInJar(this.database, this.lobBlockSize);
        } else if (this.database.getType() == "file:") {
            this.lobStore = new LobStoreRAFile(this.database, this.lobBlockSize);
            this.byteBuffer = new byte[this.lobBlockSize];
            if (!this.database.isFilesReadOnly()) {
                this.initialiseLobSpace();
            }
        } else {
            this.lobStore = new LobStoreMem(this.lobBlockSize);
            this.byteBuffer = new byte[this.lobBlockSize];
            this.initialiseLobSpace();
        }
    }

    public void close() {
        if (this.lobStore != null) {
            this.lobStore.close();
        }
        this.lobStore = null;
    }

    public LobStore getLobStore() {
        if (this.lobStore == null) {
            this.open();
        }
        return this.lobStore;
    }

    private long getNewLobID() {
        Result result = this.getNextLobId.execute(this.sysLobSession);
        if (result.isError()) {
            return 0L;
        }
        RowSetNavigator rowSetNavigator = result.getNavigator();
        boolean bl = rowSetNavigator.next();
        if (!bl) {
            rowSetNavigator.release();
            return 0L;
        }
        Object[] objectArray = rowSetNavigator.getCurrent();
        return (Long)objectArray[0];
    }

    private Object[] getLobHeader(long l) {
        ResultMetaData resultMetaData = this.getLob.getParametersMetaData();
        Object[] objectArray = new Object[resultMetaData.getColumnCount()];
        objectArray[0] = ValuePool.getLong(l);
        this.sysLobSession.sessionContext.pushDynamicArguments(objectArray);
        Result result = this.getLob.execute(this.sysLobSession);
        this.sysLobSession.sessionContext.pop();
        if (result.isError()) {
            return null;
        }
        RowSetNavigator rowSetNavigator = result.getNavigator();
        boolean bl = rowSetNavigator.next();
        if (!bl) {
            rowSetNavigator.release();
            return null;
        }
        Object[] objectArray2 = rowSetNavigator.getCurrent();
        return objectArray2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BlobData getBlob(long l) {
        this.writeLock.lock();
        try {
            BlobDataID blobDataID;
            Object[] objectArray = this.getLobHeader(l);
            if (objectArray == null) {
                BlobData blobData = null;
                return blobData;
            }
            BlobDataID blobDataID2 = blobDataID = new BlobDataID(l);
            return blobDataID2;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClobData getClob(long l) {
        this.writeLock.lock();
        try {
            ClobDataID clobDataID;
            Object[] objectArray = this.getLobHeader(l);
            if (objectArray == null) {
                ClobData clobData = null;
                return clobData;
            }
            ClobDataID clobDataID2 = clobDataID = new ClobDataID(l);
            return clobDataID2;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long createBlob(Session session, long l) {
        this.writeLock.lock();
        try {
            long l2 = this.getNewLobID();
            ResultMetaData resultMetaData = this.createLob.getParametersMetaData();
            Object[] objectArray = new Object[resultMetaData.getColumnCount()];
            objectArray[0] = ValuePool.getLong(l2);
            objectArray[1] = ValuePool.getLong(l);
            objectArray[2] = ValuePool.INTEGER_0;
            objectArray[3] = ValuePool.getInt(30);
            Result result = this.sysLobSession.executeCompiledStatement(this.createLob, objectArray);
            this.usageCountChanged = true;
            long l3 = l2;
            return l3;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long createClob(Session session, long l) {
        this.writeLock.lock();
        try {
            long l2 = this.getNewLobID();
            ResultMetaData resultMetaData = this.createLob.getParametersMetaData();
            Object[] objectArray = new Object[resultMetaData.getColumnCount()];
            objectArray[0] = ValuePool.getLong(l2);
            objectArray[1] = ValuePool.getLong(l);
            objectArray[2] = ValuePool.INTEGER_0;
            objectArray[3] = ValuePool.getInt(40);
            Result result = this.sysLobSession.executeCompiledStatement(this.createLob, objectArray);
            this.usageCountChanged = true;
            long l3 = l2;
            return l3;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result deleteLob(long l) {
        this.writeLock.lock();
        try {
            ResultMetaData resultMetaData = this.deleteLobCall.getParametersMetaData();
            Object[] objectArray = new Object[resultMetaData.getColumnCount()];
            objectArray[0] = ValuePool.getLong(l);
            objectArray[1] = ValuePool.getLong(0L);
            Result result = this.sysLobSession.executeCompiledStatement(this.deleteLobCall, objectArray);
            this.usageCountChanged = true;
            Result result2 = result;
            return result2;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result deleteUnusedLobs() {
        this.writeLock.lock();
        try {
            if (!this.usageCountChanged) {
                Result result = Result.updateZeroResult;
                return result;
            }
            Session[] sessionArray = this.database.sessionManager.getAllSessions();
            long l = Long.MAX_VALUE;
            for (int i = 0; i < sessionArray.length; ++i) {
                long l2;
                if (sessionArray[i].isClosed() || (l2 = sessionArray[i].sessionData.getFirstLobID()) == 0L || l2 >= l) continue;
                l = l2;
            }
            Object[] objectArray = new Object[]{new Long(l)};
            Result result = this.sysLobSession.executeCompiledStatement(this.deleteUnusedLobs, objectArray);
            this.usageCountChanged = false;
            Result result2 = result;
            return result2;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result getLength(long l) {
        this.writeLock.lock();
        try {
            Object[] objectArray = this.getLobHeader(l);
            if (objectArray == null) {
                throw Error.error(3474);
            }
            long l2 = (Long)objectArray[1];
            int n = (Integer)objectArray[3];
            ResultLob resultLob = ResultLob.newLobSetResponse(l, l2);
            return resultLob;
        }
        catch (HsqlException hsqlException) {
            Result result = Result.newErrorResult(hsqlException);
            return result;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int compare(BlobData blobData, byte[] byArray) {
        this.writeLock.lock();
        try {
            int n;
            Object[] objectArray = this.getLobHeader(blobData.getId());
            long l = (Long)objectArray[1];
            int[][] nArray = this.getBlockAddresses(blobData.getId(), 0, Integer.MAX_VALUE);
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            if (l == 0L) {
                int n5 = byArray.length == 0 ? 0 : -1;
                return n5;
            }
            if (byArray.length == 0) {
                int n6 = 1;
                return n6;
            }
            do {
                n = nArray[n2][0] + n4;
                byte[] byArray2 = this.getLobStore().getBlockBytes(n, 1);
                for (int i = 0; i < byArray2.length; ++i) {
                    if (n3 + i >= byArray.length) {
                        if (l == (long)byArray.length) {
                            int n7 = 0;
                            return n7;
                        }
                        int n8 = 1;
                        return n8;
                    }
                    if (byArray2[i] == byArray[n3 + i]) continue;
                    int n9 = (byArray2[i] & 0xFF) > (byArray[n3 + i] & 0xFF) ? 1 : -1;
                    return n9;
                }
                n3 += this.lobBlockSize;
                if (++n4 != nArray[n2][1]) continue;
                n4 = 0;
                ++n2;
            } while (n2 != nArray.length && n3 < byArray.length);
            if (l == (long)byArray.length) {
                n = 0;
                return n;
            }
            n = l > (long)byArray.length ? 1 : -1;
            return n;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int compare(BlobData blobData, BlobData blobData2) {
        if (blobData.getId() == blobData2.getId()) {
            return 0;
        }
        this.writeLock.lock();
        try {
            int n = this.compareBytes(blobData.getId(), blobData2.getId());
            return n;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int compare(Collation collation, ClobData clobData, String string) {
        this.writeLock.lock();
        try {
            int n;
            Object[] objectArray = this.getLobHeader(clobData.getId());
            long l = (Long)objectArray[1];
            int[][] nArray = this.getBlockAddresses(clobData.getId(), 0, Integer.MAX_VALUE);
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            if (l == 0L) {
                int n5 = string.length() == 0 ? 0 : -1;
                return n5;
            }
            if (string.length() == 0) {
                int n6 = 1;
                return n6;
            }
            do {
                String string2;
                int n7;
                n = nArray[n2][0] + n4;
                byte[] byArray = this.getLobStore().getBlockBytes(n, 1);
                long l2 = l - ((long)nArray[n2][2] + (long)n4) * (long)this.lobBlockSize / 2L;
                if (l2 > (long)(this.lobBlockSize / 2)) {
                    l2 = this.lobBlockSize / 2;
                }
                String string3 = new String(ArrayUtil.byteArrayToChars(byArray), 0, (int)l2);
                int n8 = string.length() - n3;
                if (n8 > this.lobBlockSize / 2) {
                    n8 = this.lobBlockSize / 2;
                }
                if ((n7 = collation.compare(string3, string2 = string.substring(n3, n3 + n8))) != 0) {
                    int n9 = n7;
                    return n9;
                }
                n3 += this.lobBlockSize / 2;
                if (++n4 != nArray[n2][1]) continue;
                n4 = 0;
                ++n2;
            } while (n2 != nArray.length && n3 < string.length());
            if (l == (long)string.length()) {
                n = 0;
                return n;
            }
            n = l > (long)string.length() ? 1 : -1;
            return n;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public int compare(Collation collation, ClobData clobData, ClobData clobData2) {
        if (clobData.getId() == clobData2.getId()) {
            return 0;
        }
        return this.compareText(collation, clobData.getId(), clobData2.getId());
    }

    private int compareBytes(long l, long l2) {
        Object[] objectArray = this.getLobHeader(l);
        long l3 = (Long)objectArray[1];
        objectArray = this.getLobHeader(l2);
        long l4 = (Long)objectArray[1];
        int[][] nArray = this.getBlockAddresses(l, 0, Integer.MAX_VALUE);
        int[][] nArray2 = this.getBlockAddresses(l2, 0, Integer.MAX_VALUE);
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        if (l3 == 0L) {
            return l4 == 0L ? 0 : -1;
        }
        if (l4 == 0L) {
            return 1;
        }
        do {
            int n5 = nArray[n][0] + n3;
            int n6 = nArray2[n2][0] + n4;
            byte[] byArray = this.getLobStore().getBlockBytes(n5, 1);
            byte[] byArray2 = this.getLobStore().getBlockBytes(n6, 1);
            for (int i = 0; i < byArray.length; ++i) {
                if (byArray[i] == byArray2[i]) continue;
                return (byArray[i] & 0xFF) > (byArray2[i] & 0xFF) ? 1 : -1;
            }
            ++n4;
            if (++n3 == nArray[n][1]) {
                n3 = 0;
                ++n;
            }
            if (n4 != nArray2[n2][1]) continue;
            n4 = 0;
            ++n2;
        } while (n != nArray.length && n2 != nArray2.length);
        if (l3 == l4) {
            return 0;
        }
        return l3 > l4 ? 1 : -1;
    }

    private int compareText(Collation collation, long l, long l2) {
        Object[] objectArray = this.getLobHeader(l);
        long l3 = (Long)objectArray[1];
        objectArray = this.getLobHeader(l2);
        long l4 = (Long)objectArray[1];
        int[][] nArray = this.getBlockAddresses(l, 0, Integer.MAX_VALUE);
        int[][] nArray2 = this.getBlockAddresses(l2, 0, Integer.MAX_VALUE);
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        if (l3 == 0L) {
            return l4 == 0L ? 0 : -1;
        }
        if (l4 == 0L) {
            return 1;
        }
        do {
            String string;
            String string2;
            int n5;
            long l5;
            int n6 = nArray[n][0] + n3;
            int n7 = nArray2[n2][0] + n4;
            byte[] byArray = this.getLobStore().getBlockBytes(n6, 1);
            byte[] byArray2 = this.getLobStore().getBlockBytes(n7, 1);
            long l6 = l3 - ((long)nArray[n][2] + (long)n3) * (long)this.lobBlockSize / 2L;
            if (l6 > (long)(this.lobBlockSize / 2)) {
                l6 = this.lobBlockSize / 2;
            }
            if ((l5 = l4 - ((long)nArray2[n2][2] + (long)n4) * (long)this.lobBlockSize / 2L) > (long)(this.lobBlockSize / 2)) {
                l5 = this.lobBlockSize / 2;
            }
            if ((n5 = collation.compare(string2 = new String(ArrayUtil.byteArrayToChars(byArray), 0, (int)l6), string = new String(ArrayUtil.byteArrayToChars(byArray2), 0, (int)l5))) != 0) {
                return n5;
            }
            ++n4;
            if (++n3 == nArray[n][1]) {
                n3 = 0;
                ++n;
            }
            if (n4 != nArray2[n2][1]) continue;
            n4 = 0;
            ++n2;
        } while (n != nArray.length && n2 != nArray2.length);
        if (l3 == l4) {
            return 0;
        }
        return l3 > l4 ? 1 : -1;
    }

    public Result getLob(long l, long l2, long l3) {
        if (l2 == 0L) {
            return this.createDuplicateLob(l, l3, false);
        }
        throw Error.runtimeError(201, "LobManager");
    }

    public Result createDuplicateLob(long l) {
        Result result = this.getLength(l);
        if (result.isError()) {
            return result;
        }
        return this.createDuplicateLob(l, ((ResultLob)result).getBlockLength(), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result createDuplicateLob(long l, long l2, boolean bl) {
        this.writeLock.lock();
        try {
            Object object;
            Object[] objectArray = this.getLobHeader(l);
            if (objectArray == null) {
                Result result = Result.newErrorResult(Error.error(3474));
                return result;
            }
            long l3 = (Long)objectArray[1];
            if (!bl && l3 <= l2) {
                ResultLob resultLob = ResultLob.newLobCreateBlobResponse(l);
                return resultLob;
            }
            long l4 = this.getNewLobID();
            Object[] objectArray2 = new Object[objectArray.length];
            objectArray2[0] = ValuePool.getLong(l4);
            objectArray2[1] = objectArray[1];
            objectArray2[2] = objectArray[2];
            objectArray2[3] = objectArray[3];
            Result result = this.sysLobSession.executeCompiledStatement(this.createLob, objectArray2);
            if (result.isError()) {
                Result result2 = result;
                return result2;
            }
            this.usageCountChanged = true;
            if (l2 == 0L) {
                ResultLob resultLob = ResultLob.newLobSetResponse(l4, l2);
                return resultLob;
            }
            long l5 = l2;
            int n = (Integer)objectArray[3];
            if (n == 40) {
                l5 *= 2L;
            }
            int n2 = (int)(l5 / (long)this.lobBlockSize);
            if (l5 % (long)this.lobBlockSize != 0L) {
                ++n2;
            }
            this.createBlockAddresses(l4, 0, n2);
            int[][] nArray = this.getBlockAddresses(l, 0, Integer.MAX_VALUE);
            int[][] nArray2 = this.getBlockAddresses(l4, 0, Integer.MAX_VALUE);
            try {
                this.copyBlockSet(nArray, nArray2);
            }
            catch (HsqlException hsqlException) {
                Result result3 = Result.newErrorResult(hsqlException);
                this.writeLock.unlock();
                return result3;
            }
            int n3 = (int)(l5 % (long)this.lobBlockSize);
            if (n3 != 0) {
                object = nArray2[nArray2.length - 1];
                reference var21_22 = object[0] + object[1] - true;
                byte[] byArray = this.getLobStore().getBlockBytes((int)var21_22, 1);
                ArrayUtil.fillArray(byArray, n3, (byte)0);
                this.getLobStore().setBlockBytes(byArray, (int)var21_22, 1);
            }
            object = ResultLob.newLobSetResponse(l4, l2);
            return object;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result getTruncateLength(long l) {
        this.writeLock.lock();
        try {
            Object[] objectArray = this.getLobHeader(l);
            if (objectArray == null) {
                throw Error.error(3474);
            }
            long l2 = (Long)objectArray[1];
            int n = (Integer)objectArray[3];
            ResultLob resultLob = ResultLob.newLobSetResponse(l, l2);
            return resultLob;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private void copyBlockSet(int[][] nArray, int[][] nArray2) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        do {
            byte[] byArray = this.getLobStore().getBlockBytes(nArray[n][0] + n3, 1);
            this.getLobStore().setBlockBytes(byArray, nArray2[n2][0] + n4, 1);
            ++n4;
            if (++n3 == nArray[n][1]) {
                n3 = 0;
                ++n;
            }
            if (n4 != nArray2[n2][1]) continue;
            n4 = 0;
            ++n2;
        } while (n != nArray.length && n2 != nArray2.length);
        this.storeModified = true;
    }

    public Result getChars(long l, long l2, int n) {
        Result result = this.getBytes(l, l2 * 2L, n * 2);
        if (result.isError()) {
            return result;
        }
        byte[] byArray = ((ResultLob)result).getByteArray();
        char[] cArray = ArrayUtil.byteArrayToChars(byArray);
        return ResultLob.newLobGetCharsResponse(l, l2, cArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result getBytes(long l, long l2, int n) {
        this.writeLock.lock();
        try {
            byte[] byArray;
            int n2 = (int)(l2 / (long)this.lobBlockSize);
            int n3 = (int)(l2 % (long)this.lobBlockSize);
            int n4 = (int)((l2 + (long)n) / (long)this.lobBlockSize);
            int n5 = (int)((l2 + (long)n) % (long)this.lobBlockSize);
            if (n5 == 0) {
                n5 = this.lobBlockSize;
            } else {
                ++n4;
            }
            if (n == 0) {
                ResultLob resultLob = ResultLob.newLobGetBytesResponse(l, l2, BinaryData.zeroLengthBytes);
                return resultLob;
            }
            int n6 = 0;
            byte[] byArray2 = new byte[n];
            int[][] nArray = this.getBlockAddresses(l, n2, n4);
            if (nArray.length == 0) {
                Result result = Result.newErrorResult(Error.error(3474));
                return result;
            }
            int n7 = 0;
            int n8 = nArray[n7][1] + nArray[n7][2] - n2;
            if (nArray[n7][1] + nArray[n7][2] > n4) {
                n8 -= nArray[n7][1] + nArray[n7][2] - n4;
            }
            try {
                byArray = this.getLobStore().getBlockBytes(nArray[n7][0] - nArray[n7][2] + n2, n8);
            }
            catch (HsqlException hsqlException) {
                Result result = Result.newErrorResult(hsqlException);
                this.writeLock.unlock();
                return result;
            }
            int n9 = this.lobBlockSize * n8 - n3;
            if (n9 > n) {
                n9 = n;
            }
            System.arraycopy(byArray, n3, byArray2, n6, n9);
            n6 += n9;
            ++n7;
            while (n7 < nArray.length && n6 < n) {
                n8 = nArray[n7][1];
                if (nArray[n7][1] + nArray[n7][2] > n4) {
                    n8 -= nArray[n7][1] + nArray[n7][2] - n4;
                }
                try {
                    byArray = this.getLobStore().getBlockBytes(nArray[n7][0], n8);
                }
                catch (HsqlException hsqlException) {
                    Result result = Result.newErrorResult(hsqlException);
                    this.writeLock.unlock();
                    return result;
                }
                n9 = this.lobBlockSize * n8;
                if (n9 > n - n6) {
                    n9 = n - n6;
                }
                System.arraycopy(byArray, 0, byArray2, n6, n9);
                n6 += n9;
                ++n7;
            }
            ResultLob resultLob = ResultLob.newLobGetBytesResponse(l, l2, byArray2);
            return resultLob;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Result setBytesBA(long l, long l2, byte[] byArray, int n) {
        if (n == 0) {
            return ResultLob.newLobSetResponse(l, 0L);
        }
        this.writeLock.lock();
        try {
            boolean bl = false;
            int n2 = (int)(l2 / (long)this.lobBlockSize);
            int n3 = (int)(l2 % (long)this.lobBlockSize);
            int n4 = (int)((l2 + (long)n) / (long)this.lobBlockSize);
            int n5 = (int)((l2 + (long)n) % (long)this.lobBlockSize);
            if (n5 == 0) {
                n5 = this.lobBlockSize;
            } else {
                ++n4;
            }
            int[][] nArray = this.getBlockAddresses(l, n2, n4);
            int n6 = n2;
            if (nArray.length > 0) {
                n6 = nArray[nArray.length - 1][2] + nArray[nArray.length - 1][1];
            }
            if (n6 < n4) {
                this.createBlockAddresses(l, n6, n4 - n6);
                nArray = this.getBlockAddresses(l, n2, n4);
                bl = true;
            }
            int n7 = 0;
            int n8 = n;
            try {
                for (int i = 0; i < nArray.length; ++i) {
                    long l3 = (long)nArray[i][2] * (long)this.lobBlockSize;
                    long l4 = (long)nArray[i][1] * (long)this.lobBlockSize;
                    long l5 = (long)nArray[i][0] * (long)this.lobBlockSize;
                    int n9 = 0;
                    if (l2 > l3) {
                        l4 -= l2 - l3;
                        l5 += l2 - l3;
                    }
                    if ((long)n8 < l4) {
                        if (bl) {
                            n9 = (int)((l4 - (long)n8) % (long)this.lobBlockSize);
                        }
                        l4 = n8;
                    }
                    this.getLobStore().setBlockBytes(byArray, l5, n7, (int)l4);
                    if (n9 != 0) {
                        ArrayUtil.fillArray(this.byteBuffer, 0, (byte)0);
                        this.getLobStore().setBlockBytes(this.byteBuffer, l5 + l4, 0, n9);
                    }
                    n7 = (int)((long)n7 + l4);
                    n8 = (int)((long)n8 - l4);
                }
            }
            catch (HsqlException hsqlException) {
                Result result = Result.newErrorResult(hsqlException);
                this.writeLock.unlock();
                return result;
            }
            this.storeModified = true;
            ResultLob resultLob = ResultLob.newLobSetResponse(l, 0L);
            return resultLob;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Result setBytesIS(long l, InputStream inputStream, long l2, boolean bl) {
        long l3 = 0L;
        int n = (int)(l2 / (long)this.lobBlockSize);
        int n2 = (int)(l2 % (long)this.lobBlockSize);
        if (n2 == 0) {
            n2 = this.lobBlockSize;
        } else {
            ++n;
        }
        this.createBlockAddresses(l, 0, n);
        int[][] nArray = this.getBlockAddresses(l, 0, n);
        for (int i = 0; i < nArray.length; ++i) {
            for (int j = 0; j < nArray[i][1]; ++j) {
                int n3 = this.lobBlockSize;
                ArrayUtil.fillArray(this.byteBuffer, 0, (byte)0);
                if (i == nArray.length - 1 && j == nArray[i][1] - 1) {
                    n3 = n2;
                }
                try {
                    int n4 = 0;
                    while (n3 > 0) {
                        int n5 = inputStream.read(this.byteBuffer, n4, n3);
                        if (n5 == -1) {
                            if (!bl) return Result.newErrorResult(new EOFException());
                            n5 = n3;
                        } else {
                            l3 += (long)n5;
                        }
                        n3 -= n5;
                        n4 += n5;
                    }
                }
                catch (IOException iOException) {
                    return Result.newErrorResult(iOException);
                }
                try {
                    this.getLobStore().setBlockBytes(this.byteBuffer, nArray[i][0] + j, 1);
                    continue;
                }
                catch (HsqlException hsqlException) {
                    return Result.newErrorResult(hsqlException);
                }
            }
        }
        this.storeModified = true;
        return ResultLob.newLobSetResponse(l, l3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result setBytes(long l, long l2, byte[] byArray, int n) {
        if (n == 0) {
            return ResultLob.newLobSetResponse(l, 0L);
        }
        this.writeLock.lock();
        try {
            Object[] objectArray = this.getLobHeader(l);
            if (objectArray == null) {
                Result result = Result.newErrorResult(Error.error(3474));
                return result;
            }
            long l3 = (Long)objectArray[1];
            Result result = this.setBytesBA(l, l2, byArray, n);
            if (result.isError()) {
                Result result2 = result;
                return result2;
            }
            if (l2 + (long)n > l3 && (result = this.setLength(l, l3 = l2 + (long)n)).isError()) {
                Result result3 = result;
                return result3;
            }
            ResultLob resultLob = ResultLob.newLobSetResponse(l, l3);
            return resultLob;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result setBytesForNewBlob(long l, InputStream inputStream, long l2) {
        if (l2 == 0L) {
            return ResultLob.newLobSetResponse(l, 0L);
        }
        this.writeLock.lock();
        try {
            Result result;
            Result result2 = result = this.setBytesIS(l, inputStream, l2, false);
            return result2;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result setChars(long l, long l2, char[] cArray) {
        if (cArray.length == 0) {
            return ResultLob.newLobSetResponse(l, 0L);
        }
        this.writeLock.lock();
        try {
            Object[] objectArray = this.getLobHeader(l);
            if (objectArray == null) {
                Result result = Result.newErrorResult(Error.error(3474));
                return result;
            }
            long l3 = (Long)objectArray[1];
            byte[] byArray = ArrayUtil.charArrayToBytes(cArray);
            Result result = this.setBytesBA(l, l2 * 2L, byArray, cArray.length * 2);
            if (result.isError()) {
                Result result2 = result;
                return result2;
            }
            if (l2 + (long)cArray.length > l3 && (result = this.setLength(l, l3 = l2 + (long)cArray.length)).isError()) {
                Result result3 = result;
                return result3;
            }
            ResultLob resultLob = ResultLob.newLobSetResponse(l, l3);
            return resultLob;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result setCharsForNewClob(long l, InputStream inputStream, long l2, boolean bl) {
        if (l2 == 0L) {
            return ResultLob.newLobSetResponse(l, 0L);
        }
        this.writeLock.lock();
        try {
            Result result;
            Result result2 = this.setBytesIS(l, inputStream, l2 * 2L, bl);
            if (result2.isError()) {
                Result result3 = result2;
                return result3;
            }
            long l3 = ((ResultLob)result2).getBlockLength();
            if (l3 < l2) {
                result = this.truncate(l, l3);
            }
            result = result2;
            return result;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result truncate(long l, long l2) {
        this.writeLock.lock();
        try {
            Object[] objectArray = this.getLobHeader(l);
            if (objectArray == null) {
                Result result = Result.newErrorResult(Error.error(3474));
                return result;
            }
            long l3 = (Long)objectArray[1];
            long l4 = l2;
            if ((Integer)objectArray[3] == 40) {
                l4 *= 2L;
            }
            int n = (int)((l4 + (long)this.lobBlockSize - 1L) / (long)this.lobBlockSize);
            ResultMetaData resultMetaData = this.deleteLobPartCall.getParametersMetaData();
            Object[] objectArray2 = new Object[resultMetaData.getColumnCount()];
            objectArray2[0] = ValuePool.getLong(l);
            objectArray2[1] = new Integer(n);
            objectArray2[2] = ValuePool.INTEGER_MAX;
            objectArray2[3] = ValuePool.getLong(this.sysLobSession.getTransactionTimestamp());
            Result result = this.sysLobSession.executeCompiledStatement(this.deleteLobPartCall, objectArray2);
            this.setLength(l, l2);
            ResultLob resultLob = ResultLob.newLobTruncateResponse(l, l2);
            return resultLob;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private Result setLength(long l, long l2) {
        ResultMetaData resultMetaData = this.updateLobLength.getParametersMetaData();
        Object[] objectArray = new Object[resultMetaData.getColumnCount()];
        objectArray[0] = ValuePool.getLong(l2);
        objectArray[1] = ValuePool.getLong(l);
        Result result = this.sysLobSession.executeCompiledStatement(this.updateLobLength, objectArray);
        return result;
    }

    public Result adjustUsageCount(Session session, long l, int n) {
        ResultMetaData resultMetaData = this.updateLobUsage.getParametersMetaData();
        Object[] objectArray = new Object[resultMetaData.getColumnCount()];
        objectArray[0] = ValuePool.getInt(n);
        objectArray[1] = ValuePool.getLong(l);
        session.sessionContext.pushDynamicArguments(objectArray);
        Result result = this.updateLobUsage.execute(session);
        session.sessionContext.pop();
        return result;
    }

    private int[][] getBlockAddresses(long l, int n, int n2) {
        ResultMetaData resultMetaData = this.getLobPart.getParametersMetaData();
        Object[] objectArray = new Object[resultMetaData.getColumnCount()];
        objectArray[0] = ValuePool.getLong(l);
        objectArray[1] = ValuePool.getInt(n);
        objectArray[2] = ValuePool.getInt(n2);
        this.sysLobSession.sessionContext.pushDynamicArguments(objectArray);
        Result result = this.getLobPart.execute(this.sysLobSession);
        this.sysLobSession.sessionContext.pop();
        RowSetNavigator rowSetNavigator = result.getNavigator();
        int n3 = rowSetNavigator.getSize();
        int[][] nArray = new int[n3][3];
        for (int i = 0; i < n3; ++i) {
            rowSetNavigator.absolute(i);
            Object[] objectArray2 = rowSetNavigator.getCurrent();
            nArray[i][0] = (Integer)objectArray2[0];
            nArray[i][1] = (Integer)objectArray2[1];
            nArray[i][2] = (Integer)objectArray2[2];
        }
        rowSetNavigator.release();
        return nArray;
    }

    private void deleteBlockAddresses(long l, int n, int n2) {
        ResultMetaData resultMetaData = this.deleteLobPartCall.getParametersMetaData();
        Object[] objectArray = new Object[resultMetaData.getColumnCount()];
        objectArray[0] = ValuePool.getLong(l);
        objectArray[1] = ValuePool.getInt(n);
        objectArray[2] = ValuePool.getInt(n2);
        objectArray[3] = ValuePool.getLong(this.sysLobSession.getTransactionTimestamp());
        Result result = this.sysLobSession.executeCompiledStatement(this.deleteLobPartCall, objectArray);
    }

    private void divideBlockAddresses(long l, int n) {
        ResultMetaData resultMetaData = this.divideLobPartCall.getParametersMetaData();
        Object[] objectArray = new Object[resultMetaData.getColumnCount()];
        objectArray[0] = ValuePool.getInt(n);
        objectArray[1] = ValuePool.getLong(l);
        Result result = this.sysLobSession.executeCompiledStatement(this.divideLobPartCall, objectArray);
    }

    private void createBlockAddresses(long l, int n, int n2) {
        ResultMetaData resultMetaData = this.createLobPartCall.getParametersMetaData();
        Object[] objectArray = new Object[resultMetaData.getColumnCount()];
        objectArray[0] = ValuePool.getInt(n2);
        objectArray[1] = ValuePool.getInt(n);
        objectArray[2] = ValuePool.getLong(l);
        Result result = this.sysLobSession.executeCompiledStatement(this.createLobPartCall, objectArray);
    }

    private int getBlockAddress(int[][] nArray, int n) {
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i][2] + nArray[i][1] <= n) continue;
            return nArray[i][0] - nArray[i][2] + n;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLobCount() {
        this.writeLock.lock();
        try {
            this.sysLobSession.sessionContext.pushDynamicArguments(new Object[0]);
            Result result = this.getLobCount.execute(this.sysLobSession);
            this.sysLobSession.sessionContext.pop();
            RowSetNavigator rowSetNavigator = result.getNavigator();
            boolean bl = rowSetNavigator.next();
            if (!bl) {
                rowSetNavigator.release();
                int n = 0;
                return n;
            }
            Object[] objectArray = rowSetNavigator.getCurrent();
            int n = ((Number)objectArray[0]).intValue();
            return n;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void synch() {
        if (this.storeModified && this.lobStore != null) {
            this.writeLock.lock();
            try {
                this.lobStore.synch();
                this.storeModified = false;
            }
            finally {
                this.writeLock.unlock();
            }
        }
    }

    private static interface UPDATE_LENGTH {
        public static final int LOB_LENGTH = 0;
        public static final int LOB_ID = 1;
    }

    private static interface UPDATE_USAGE {
        public static final int BLOCK_COUNT = 0;
        public static final int LOB_ID = 1;
    }

    private static interface ALLOC_BLOCKS {
        public static final int BLOCK_COUNT = 0;
        public static final int BLOCK_OFFSET = 1;
        public static final int LOB_ID = 2;
    }

    private static interface DELETE_BLOCKS {
        public static final int LOB_ID = 0;
        public static final int BLOCK_OFFSET = 1;
        public static final int BLOCK_LIMIT = 2;
        public static final int TX_ID = 3;
    }

    private static interface DIVIDE_BLOCK {
        public static final int BLOCK_OFFSET = 0;
        public static final int LOB_ID = 1;
    }

    private static interface GET_LOB_PART {
        public static final int LOB_ID = 0;
        public static final int BLOCK_OFFSET = 1;
        public static final int BLOCK_LIMIT = 2;
    }

    private static interface LOB_IDS {
        public static final int LOB_ID = 0;
        public static final int LOB_LENGTH = 1;
        public static final int LOB_USAGE_COUNT = 2;
        public static final int LOB_TYPE = 3;
    }

    private static interface LOBS {
        public static final int BLOCK_ADDR = 0;
        public static final int BLOCK_COUNT = 1;
        public static final int BLOCK_OFFSET = 2;
        public static final int LOB_ID = 3;
    }
}

