/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import jnr.posix.util.Platform;
import org.jcodings.Encoding;
import org.jruby.Ruby;
import org.jruby.RubyString;
import org.jruby.util.ByteList;
import org.jruby.util.SafePropertyAccessor;

public class OSEnvironment {
    public static Map<RubyString, RubyString> environmentVariableMap(Ruby runtime) {
        Map<String, String> env = runtime.getInstanceConfig().getEnvironment();
        if (env != null) {
            return OSEnvironment.asMapOfRubyStrings(runtime, env);
        }
        if (Ruby.isSecurityRestricted()) {
            return Collections.emptyMap();
        }
        return OSEnvironment.asMapOfRubyStrings(runtime, System.getenv());
    }

    public Map<RubyString, RubyString> getEnvironmentVariableMap(Ruby runtime) {
        HashMap envMap = OSEnvironment.environmentVariableMap(runtime);
        return envMap == Collections.EMPTY_MAP ? new HashMap(4) : envMap;
    }

    public static Map<String, String> propertiesToStringMap(Properties properties) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            if (!(entry.getKey() instanceof String) || !(entry.getValue() instanceof String)) continue;
            map.put((String)entry.getKey(), (String)entry.getValue());
        }
        return map;
    }

    public static Map<RubyString, RubyString> systemPropertiesMap(Ruby runtime) {
        if (Ruby.isSecurityRestricted()) {
            return Collections.emptyMap();
        }
        return OSEnvironment.asMapOfRubyStrings(runtime, (Properties)System.getProperties().clone());
    }

    public Map<RubyString, RubyString> getSystemPropertiesMap(Ruby runtime) {
        HashMap sysMap = OSEnvironment.systemPropertiesMap(runtime);
        return sysMap == Collections.EMPTY_MAP ? new HashMap(4) : sysMap;
    }

    private static Map<RubyString, RubyString> asMapOfRubyStrings(Ruby runtime, Map<?, ?> map) {
        HashMap<RubyString, RubyString> rubyMap = new HashMap<RubyString, RubyString>(map.size() + 2);
        Encoding encoding2 = runtime.getEncodingService().getLocaleEncoding();
        if (Platform.IS_WINDOWS) {
            String home2 = SafePropertyAccessor.getProperty("user.home");
            String user = SafePropertyAccessor.getProperty("user.name");
            OSEnvironment.putRubyKeyValuePair(runtime, rubyMap, "HOME", home2 == null ? "/" : home2, encoding2);
            OSEnvironment.putRubyKeyValuePair(runtime, rubyMap, "USER", user == null ? "" : user, encoding2);
        }
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            Object val = entry.getKey();
            if (!(val instanceof String)) continue;
            String key2 = (String)val;
            if (Platform.IS_WINDOWS && key2.startsWith("=") || !((val = entry.getValue()) instanceof String)) continue;
            OSEnvironment.putRubyKeyValuePair(runtime, rubyMap, key2, (String)val, encoding2);
        }
        return rubyMap;
    }

    private static void putRubyKeyValuePair(Ruby runtime, Map<RubyString, RubyString> map, String key2, String value2, Encoding encoding2) {
        ByteList keyBytes = new ByteList(key2.getBytes(), encoding2);
        ByteList valueBytes = new ByteList(value2.getBytes(), encoding2);
        RubyString keyString = runtime.newString(keyBytes);
        RubyString valueString = runtime.newString(valueBytes);
        keyString.setFrozen(true);
        valueString.setFrozen(true);
        map.put(keyString, valueString);
    }
}

