/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.dsl.internal;

import com.oracle.truffle.api.dsl.internal.SpecializationNode;
import com.oracle.truffle.api.frame.Frame;

abstract class SlowPathEvent
implements CharSequence {
    protected final SpecializationNode source;
    protected final String reason;
    protected final Frame frame;
    private String message;

    SlowPathEvent(SpecializationNode source, String reason, Frame frame) {
        this.source = source;
        this.reason = reason;
        this.frame = frame;
    }

    @Override
    public int length() {
        return this.getMessage().length();
    }

    @Override
    public char charAt(int index) {
        return this.getMessage().charAt(index);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return this.getMessage().subSequence(start, end);
    }

    @Override
    public String toString() {
        return this.getMessage();
    }

    private String getMessage() {
        if (this.message == null) {
            this.message = this.createMessage();
        }
        return this.message;
    }

    private String createMessage() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.source);
        builder.append(" ");
        builder.append(this.reason);
        Object[] values = this.getValues();
        if (values.length > 0) {
            builder.append(" with parameters (");
            String sep = "";
            for (Object value : values) {
                builder.append(sep);
                if (value == null) {
                    builder.append("null");
                } else {
                    builder.append(value).append(" (").append(value.getClass().getSimpleName()).append(")");
                }
                sep = ", ";
            }
            builder.append(")");
        }
        return builder.toString();
    }

    public abstract Object[] getValues();

    static class SlowPathEventN
    extends SlowPathEvent {
        protected final Object[] args;

        public SlowPathEventN(SpecializationNode source, String reason, Frame frame, Object ... args) {
            super(source, reason, frame);
            this.args = args;
        }

        @Override
        public final Object[] getValues() {
            return this.args;
        }
    }

    static class SlowPathEvent5
    extends SlowPathEvent {
        protected final Object o1;
        protected final Object o2;
        protected final Object o3;
        protected final Object o4;
        protected final Object o5;

        public SlowPathEvent5(SpecializationNode source, String reason, Frame frame, Object o1, Object o2, Object o3, Object o4, Object o5) {
            super(source, reason, frame);
            this.o1 = o1;
            this.o2 = o2;
            this.o3 = o3;
            this.o4 = o4;
            this.o5 = o5;
        }

        @Override
        public final Object[] getValues() {
            return new Object[]{this.o1, this.o2, this.o3, this.o4, this.o5};
        }
    }

    static class SlowPathEvent4
    extends SlowPathEvent {
        protected final Object o1;
        protected final Object o2;
        protected final Object o3;
        protected final Object o4;

        public SlowPathEvent4(SpecializationNode source, String reason, Frame frame, Object o1, Object o2, Object o3, Object o4) {
            super(source, reason, frame);
            this.o1 = o1;
            this.o2 = o2;
            this.o3 = o3;
            this.o4 = o4;
        }

        @Override
        public final Object[] getValues() {
            return new Object[]{this.o1, this.o2, this.o3, this.o4};
        }
    }

    static class SlowPathEvent3
    extends SlowPathEvent {
        protected final Object o1;
        protected final Object o2;
        protected final Object o3;

        public SlowPathEvent3(SpecializationNode source, String reason, Frame frame, Object o1, Object o2, Object o3) {
            super(source, reason, frame);
            this.o1 = o1;
            this.o2 = o2;
            this.o3 = o3;
        }

        @Override
        public final Object[] getValues() {
            return new Object[]{this.o1, this.o2, this.o3};
        }
    }

    static class SlowPathEvent2
    extends SlowPathEvent {
        protected final Object o1;
        protected final Object o2;

        public SlowPathEvent2(SpecializationNode source, String reason, Frame frame, Object o1, Object o2) {
            super(source, reason, frame);
            this.o1 = o1;
            this.o2 = o2;
        }

        @Override
        public final Object[] getValues() {
            return new Object[]{this.o1, this.o2};
        }
    }

    static class SlowPathEvent1
    extends SlowPathEvent {
        protected final Object o1;

        public SlowPathEvent1(SpecializationNode source, String reason, Frame frame, Object o1) {
            super(source, reason, frame);
            this.o1 = o1;
        }

        @Override
        public final Object[] getValues() {
            return new Object[]{this.o1};
        }
    }

    static class SlowPathEvent0
    extends SlowPathEvent {
        private static final Object[] EMPTY = new Object[0];

        public SlowPathEvent0(SpecializationNode source, String reason, Frame frame) {
            super(source, reason, frame);
        }

        @Override
        public final Object[] getValues() {
            return EMPTY;
        }
    }
}

