/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.interop.java;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.ForeignAccess;
import com.oracle.truffle.api.interop.Message;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.java.JavaFunctionForeignAccess;
import com.oracle.truffle.api.interop.java.JavaObjectForeignAccess;
import com.oracle.truffle.api.interop.java.MethodMessage;
import com.oracle.truffle.api.interop.java.TruffleList;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class JavaInterop {
    static final Object[] EMPTY = new Object[0];

    private JavaInterop() {
    }

    public static <T> T asJavaObject(Class<T> type, TruffleObject foreignObject) {
        return JavaInterop.asJavaObject(type, null, foreignObject);
    }

    private static <T> T asJavaObject(Class<T> clazz, Type type, TruffleObject foreignObject) {
        List<Object> obj;
        if (clazz.isInstance(foreignObject)) {
            obj = foreignObject;
        } else {
            if (!clazz.isInterface()) {
                throw new IllegalArgumentException();
            }
            if (foreignObject == null) {
                return null;
            }
            if (clazz == List.class && Boolean.TRUE.equals(JavaInterop.message(Message.HAS_SIZE, foreignObject, new Object[0]))) {
                ParameterizedType parametrizedType;
                Type[] arr;
                Class elementType = Object.class;
                if (type instanceof ParameterizedType && (arr = (parametrizedType = (ParameterizedType)type).getActualTypeArguments()).length == 1 && arr[0] instanceof Class) {
                    elementType = (Class)arr[0];
                }
                obj = TruffleList.create(elementType, foreignObject);
            } else {
                obj = Proxy.newProxyInstance(clazz.getClassLoader(), new Class[]{clazz}, (InvocationHandler)new TruffleHandler(foreignObject));
            }
        }
        return clazz.cast(obj);
    }

    public static TruffleObject asTruffleObject(Object obj) {
        if (obj instanceof TruffleObject) {
            return (TruffleObject)obj;
        }
        if (obj instanceof Class) {
            return new JavaObject(null, (Class)obj);
        }
        if (obj == null) {
            return JavaObject.NULL;
        }
        return new JavaObject(obj, obj.getClass());
    }

    public static <T> T asJavaFunction(Class<T> functionalType, TruffleObject function) {
        Method[] arr = functionalType.getDeclaredMethods();
        if (!functionalType.isInterface() || arr.length != 1) {
            throw new IllegalArgumentException();
        }
        Object obj = Proxy.newProxyInstance(functionalType.getClassLoader(), new Class[]{functionalType}, (InvocationHandler)new SingleHandler(function));
        return functionalType.cast(obj);
    }

    public static <T> TruffleObject asTruffleFunction(Class<T> functionalType, T implementation) {
        Method[] arr = functionalType.getDeclaredMethods();
        if (!functionalType.isInterface() || arr.length != 1) {
            throw new IllegalArgumentException();
        }
        return new JavaFunctionObject(arr[0], implementation);
    }

    static Message findMessage(MethodMessage mm) {
        if (mm == null) {
            return null;
        }
        return Message.valueOf(mm.message());
    }

    static Object toJava(Object ret, Method method) {
        if (JavaInterop.isPrimitive(ret)) {
            return ret;
        }
        if (ret instanceof TruffleObject && Boolean.TRUE.equals(JavaInterop.message(Message.IS_NULL, ret, new Object[0]))) {
            return null;
        }
        Class<?> retType = method.getReturnType();
        if (retType.isInstance(ret)) {
            return ret;
        }
        if (ret instanceof TruffleObject) {
            TruffleObject truffleObject = (TruffleObject)ret;
            if (retType.isInterface()) {
                return JavaInterop.asJavaObject(retType, method.getGenericReturnType(), truffleObject);
            }
        }
        return ret;
    }

    static boolean isPrimitive(Object attr) {
        if (attr instanceof TruffleObject) {
            return false;
        }
        if (attr instanceof Number) {
            return true;
        }
        if (attr instanceof String) {
            return true;
        }
        if (attr instanceof Character) {
            return true;
        }
        return attr instanceof Boolean;
    }

    static Object message(Message m, Object receiver, Object ... arr) {
        Node n = m.createNode();
        RootCallTarget callTarget = Truffle.getRuntime().createCallTarget(new TemporaryRoot(TruffleLanguage.class, n, (TruffleObject)receiver));
        return callTarget.call(arr);
    }

    static final class JavaObject
    implements TruffleObject {
        static final JavaObject NULL = new JavaObject(null, Object.class);
        final Object obj;
        final Class<?> clazz;

        public JavaObject(Object obj, Class<?> clazz) {
            this.obj = obj;
            this.clazz = clazz;
        }

        @Override
        public ForeignAccess getForeignAccess() {
            return ForeignAccess.create(JavaObject.class, new JavaObjectForeignAccess());
        }

        public int hashCode() {
            return System.identityHashCode(this.obj);
        }

        public boolean equals(Object other) {
            if (other instanceof JavaObject) {
                return this.obj == ((JavaObject)other).obj && this.clazz == ((JavaObject)other).clazz;
            }
            return false;
        }
    }

    static final class JavaFunctionObject
    implements TruffleObject {
        final Method method;
        final Object obj;

        public JavaFunctionObject(Method method, Object obj) {
            this.method = method;
            this.obj = obj;
        }

        @Override
        public ForeignAccess getForeignAccess() {
            return ForeignAccess.create(JavaFunctionObject.class, new JavaFunctionForeignAccess());
        }
    }

    private static class TemporaryRoot
    extends RootNode {
        @Node.Child
        private Node foreignAccess;
        private final TruffleObject function;

        public TemporaryRoot(Class<? extends TruffleLanguage> lang, Node foreignAccess, TruffleObject function) {
            super(lang, null, null);
            this.foreignAccess = foreignAccess;
            this.function = function;
        }

        @Override
        public Object execute(VirtualFrame frame) {
            return ForeignAccess.execute(this.foreignAccess, frame, this.function, frame.getArguments());
        }
    }

    private static final class TruffleHandler
    implements InvocationHandler {
        private final TruffleObject obj;

        public TruffleHandler(TruffleObject obj) {
            this.obj = obj;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] arguments) throws Throwable {
            Object[] args = arguments == null ? EMPTY : arguments;
            for (int i = 0; i < args.length; ++i) {
                InvocationHandler h;
                if (args[i] == null || !Proxy.isProxyClass(args[i].getClass()) || !((h = Proxy.getInvocationHandler(args[i])) instanceof TruffleHandler)) continue;
                args[i] = ((TruffleHandler)h).obj;
            }
            if (Object.class == method.getDeclaringClass()) {
                return method.invoke((Object)this.obj, args);
            }
            String name = method.getName();
            Message message = JavaInterop.findMessage(method.getAnnotation(MethodMessage.class));
            if (message == Message.WRITE) {
                if (args.length != 1) {
                    throw new IllegalStateException("Method needs to have a single argument to handle WRITE message " + method);
                }
                JavaInterop.message(Message.WRITE, this.obj, name, args[0]);
                return null;
            }
            if (message == Message.HAS_SIZE || message == Message.IS_BOXED || message == Message.IS_EXECUTABLE || message == Message.IS_NULL || message == Message.GET_SIZE) {
                return JavaInterop.message(message, this.obj, new Object[0]);
            }
            if (message == Message.READ) {
                Object val = JavaInterop.message(Message.READ, this.obj, name);
                return JavaInterop.toJava(val, method);
            }
            if (message == Message.UNBOX) {
                Object val = JavaInterop.message(Message.UNBOX, this.obj, new Object[0]);
                return JavaInterop.toJava(val, method);
            }
            if (Message.createExecute(0).equals(message)) {
                ArrayList<Object> copy = new ArrayList<Object>(args.length);
                copy.addAll(Arrays.asList(args));
                message = Message.createExecute(copy.size());
                Object val = JavaInterop.message(message, this.obj, copy.toArray());
                return JavaInterop.toJava(val, method);
            }
            if (Message.createInvoke(0).equals(message)) {
                ArrayList<Object> copy = new ArrayList<Object>(args.length + 1);
                copy.add(name);
                copy.addAll(Arrays.asList(args));
                message = Message.createInvoke(args.length);
                Object val = JavaInterop.message(message, this.obj, copy.toArray());
                return JavaInterop.toJava(val, method);
            }
            if (Message.createNew(0).equals(message)) {
                message = Message.createNew(args.length);
                Object val = JavaInterop.message(message, this.obj, args);
                return JavaInterop.toJava(val, method);
            }
            if (message == null) {
                Object ret;
                try {
                    ArrayList<Object> callArgs = new ArrayList<Object>(args.length);
                    callArgs.add(name);
                    callArgs.addAll(Arrays.asList(args));
                    ret = JavaInterop.message(Message.createInvoke(args.length), this.obj, callArgs.toArray());
                }
                catch (IllegalArgumentException ex) {
                    Object val = JavaInterop.message(Message.READ, this.obj, name);
                    if (JavaInterop.isPrimitive(val)) {
                        return val;
                    }
                    TruffleObject attr = (TruffleObject)val;
                    if (Boolean.FALSE.equals(JavaInterop.message(Message.IS_EXECUTABLE, attr, new Object[0]))) {
                        if (args.length == 0) {
                            return JavaInterop.toJava(attr, method);
                        }
                        throw new IllegalArgumentException(attr + " cannot be invoked with " + args.length + " parameters");
                    }
                    ArrayList<Object> callArgs = new ArrayList<Object>(args.length);
                    callArgs.addAll(Arrays.asList(args));
                    ret = JavaInterop.message(Message.createExecute(callArgs.size()), attr, callArgs.toArray());
                }
                return JavaInterop.toJava(ret, method);
            }
            throw new IllegalArgumentException("Unknown message: " + message);
        }
    }

    private static final class SingleHandler
    implements InvocationHandler {
        private final TruffleObject symbol;
        private CallTarget target;

        public SingleHandler(TruffleObject obj) {
            this.symbol = obj;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] arguments) throws Throwable {
            Object[] args;
            Object[] objectArray = args = arguments == null ? EMPTY : arguments;
            if (this.target == null) {
                Node executeMain = Message.createExecute(args.length).createNode();
                TemporaryRoot symbolNode = new TemporaryRoot(TruffleLanguage.class, executeMain, this.symbol);
                this.target = Truffle.getRuntime().createCallTarget(symbolNode);
            }
            Object ret = this.target.call(args);
            return JavaInterop.toJava(ret, method);
        }
    }
}

