/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.runtime.backtrace;

import java.util.ArrayList;
import java.util.List;

public class BacktraceInterleaver {
    public static List<String> interleave(List<String> rubyBacktrace, StackTraceElement[] javaStacktrace) {
        ArrayList<String> interleaved = new ArrayList<String>();
        int javaIndex = 0;
        for (String rubyLine : rubyBacktrace) {
            if (javaIndex < javaStacktrace.length) {
                interleaved.add(BacktraceInterleaver.format(javaStacktrace[javaIndex]));
                ++javaIndex;
                while (javaIndex < javaStacktrace.length && !BacktraceInterleaver.isCallBoundary(javaStacktrace[javaIndex])) {
                    interleaved.add(BacktraceInterleaver.format(javaStacktrace[javaIndex]));
                    ++javaIndex;
                }
            }
            interleaved.add(rubyLine);
        }
        return interleaved;
    }

    private static boolean isCallBoundary(StackTraceElement element) {
        return element.toString().startsWith("com.oracle.graal.truffle.OptimizedCallTarget.callProxy") || element.toString().startsWith("com.oracle.truffle.api.impl.DefaultCallTarget.call");
    }

    private static String format(StackTraceElement element) {
        return String.format("\t\t%s", element);
    }
}

