/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.sambox.contentstream.operator;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.sejda.sambox.cos.COSDictionary;

public final class Operator {
    public static final String BI_OPERATOR = "BI";
    public static final String ID_OPERATOR = "ID";
    public static final String EI_OPERATOR = "EI";
    private final String theOperator;
    private byte[] imageData;
    private COSDictionary imageParameters;
    private static final ConcurrentMap<String, Operator> operators = new ConcurrentHashMap<String, Operator>();

    private Operator(String aOperator) {
        this.theOperator = aOperator;
        if (aOperator.startsWith("/")) {
            throw new RuntimeException("Operators are not allowed to start with / '" + aOperator + "'");
        }
    }

    public static Operator getOperator(String operator) {
        Operator operation;
        if (ID_OPERATOR.equals(operator) || BI_OPERATOR.equals(operator)) {
            operation = new Operator(operator);
        } else {
            operation = (Operator)operators.get(operator);
            if (operation == null && (operation = operators.putIfAbsent(operator, new Operator(operator))) == null) {
                operation = (Operator)operators.get(operator);
            }
        }
        return operation;
    }

    public String getName() {
        return this.theOperator;
    }

    public String toString() {
        return "PDFOperator{" + this.theOperator + "}";
    }

    public byte[] getImageData() {
        return this.imageData;
    }

    public void setImageData(byte[] imageDataArray) {
        this.imageData = imageDataArray;
    }

    public COSDictionary getImageParameters() {
        return this.imageParameters;
    }

    public void setImageParameters(COSDictionary params) {
        this.imageParameters = params;
    }
}

