/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.sambox.util;

public final class CharUtils {
    public static final byte ASCII_LINE_FEED = 10;
    public static final byte ASCII_FORM_FEED = 12;
    public static final byte ASCII_CARRIAGE_RETURN = 13;
    public static final byte ASCII_BACKSPACE = 8;
    public static final byte ASCII_HORIZONTAL_TAB = 9;
    private static final byte ASCII_ZERO = 48;
    private static final byte ASCII_SEVEN = 55;
    private static final byte ASCII_NINE = 57;
    public static final byte ASCII_NULL = 0;
    public static final byte ASCII_SPACE = 32;
    private static final byte ASCII_UPPERCASE_A = 65;
    private static final byte ASCII_UPPERCASE_Z = 90;
    private static final byte ASCII_LOWERCASE_A = 97;
    private static final byte ASCII_LOWERCASE_Z = 122;

    private CharUtils() {
    }

    public static boolean isEndOfName(int ch) {
        return CharUtils.isSpace(ch) || CharUtils.isEOL(ch) || ch == 9 || ch == 62 || ch == 60 || ch == 91 || ch == 93 || ch == 47 || ch == 41 || ch == 40;
    }

    public static boolean isEOF(int c) {
        return c == -1;
    }

    public static boolean isEOL(int c) {
        return CharUtils.isCarriageReturn(c) || CharUtils.isLineFeed(c);
    }

    public static boolean isLineFeed(int c) {
        return 10 == c;
    }

    public static boolean isCarriageReturn(int c) {
        return 13 == c;
    }

    public static boolean isWhitespace(int c) {
        return c == 0 || c == 9 || c == 12 || CharUtils.isEOL(c) || CharUtils.isSpace(c);
    }

    public static boolean isSpace(int c) {
        return 32 == c;
    }

    public static boolean isDigit(int c) {
        return c >= 48 && c <= 57;
    }

    public static boolean isLetter(int c) {
        return c >= 65 && c <= 90 || c >= 97 && c <= 122;
    }

    public static boolean isOctalDigit(int c) {
        return c >= 48 && c <= 55;
    }

    public static boolean isHexDigit(int c) {
        return CharUtils.isDigit(c) || c >= 97 && c <= 102 || c >= 65 && c <= 70;
    }
}

