/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.conversion;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.sejda.conversion.AbstractPdfInputFilesSource;
import org.sejda.conversion.exception.ConversionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CsvFileSourceListParser
extends AbstractPdfInputFilesSource {
    private static final Logger LOG = LoggerFactory.getLogger(CsvFileSourceListParser.class);

    CsvFileSourceListParser() {
    }

    @Override
    protected List<String> parseFileNames(File file) {
        try {
            return this.doParseFileNames(file);
        }
        catch (Exception e) {
            LOG.error("Can't extract filesnames", e);
            throw new ConversionException("Can't extract filenames from '" + file.getName() + "'. Reason:" + e.getMessage(), e);
        }
    }

    protected List<String> doParseFileNames(File file) throws IOException {
        ArrayList<String> resultingFileNames = new ArrayList<String>();
        List<String> lines = IOUtils.readLines(new FileInputStream(file));
        for (String eachLine : lines) {
            String[] splitLine = StringUtils.split(eachLine.toString(), ",");
            resultingFileNames.addAll(Arrays.asList(splitLine));
        }
        return resultingFileNames;
    }
}

