/*
 * Decompiled with CFR 0.152.
 */
package com.baselet.standalone;

import com.baselet.control.Main;
import com.baselet.control.config.Config;
import com.baselet.control.config.handler.ConfigHandler;
import com.baselet.control.enums.Program;
import com.baselet.control.enums.RuntimeType;
import com.baselet.control.util.Path;
import com.baselet.control.util.RunningFileChecker;
import com.baselet.diagram.DiagramHandler;
import com.baselet.diagram.UpdateCheckTimerTask;
import com.baselet.standalone.gui.StandaloneGUI;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import javax.imageio.ImageIO;
import org.apache.commons.io.filefilter.WildcardFileFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MainStandalone {
    private static final Logger log = LoggerFactory.getLogger(MainStandalone.class);

    public static void main(String[] args) {
        if (args.length != 0) {
            String action = null;
            String format = null;
            String filename = null;
            String output = null;
            for (String arg : args) {
                if (arg.startsWith("-action=")) {
                    action = arg.substring(8);
                    continue;
                }
                if (arg.startsWith("-format=")) {
                    format = arg.substring(8);
                    continue;
                }
                if (arg.startsWith("-filename=")) {
                    filename = arg.substring(10);
                    continue;
                }
                if (!arg.startsWith("-output=")) continue;
                output = arg.substring(8);
            }
            if (action == null && format == null && (filename != null || args.length == 1)) {
                if (filename == null) {
                    filename = args[0];
                }
                MainStandalone.initAll(RuntimeType.STANDALONE);
                if (!MainStandalone.alreadyRunningChecker(false) || !MainStandalone.sendFileNameToRunningApplication(filename)) {
                    MainStandalone.startStandalone(filename);
                }
            } else if (action != null && format != null && filename != null) {
                if (action.equals("convert")) {
                    WildcardFileFilter fileFilter;
                    File[] files;
                    MainStandalone.initAll(RuntimeType.BATCH);
                    String[] splitFilename = filename.split("(/|\\\\)");
                    String localName = splitFilename[splitFilename.length - 1];
                    String dir = filename.substring(0, filename.length() - localName.length());
                    if (dir.isEmpty()) {
                        dir = ".";
                    }
                    if ((files = new File(dir).listFiles((FileFilter)(fileFilter = new WildcardFileFilter(localName)))) != null) {
                        for (File file : files) {
                            log.info("Converting file " + file.getAbsolutePath());
                            MainStandalone.doConvert(file, format, output);
                        }
                    }
                } else {
                    MainStandalone.printUsage();
                }
            } else {
                MainStandalone.printUsage();
            }
        } else {
            MainStandalone.initAll(RuntimeType.STANDALONE);
            MainStandalone.alreadyRunningChecker(true);
            MainStandalone.startStandalone(null);
        }
    }

    private static void initAll(RuntimeType runtime) {
        MainStandalone.readBuildInfoAndInitVersion(runtime);
        MainStandalone.initHomeProgramPath();
        ConfigHandler.loadConfig();
    }

    private static void startStandalone(String filenameToOpen) {
        if (Config.getInstance().isCheckForUpdates()) {
            new Timer("Update Checker", true).schedule((TimerTask)UpdateCheckTimerTask.getInstance(), 0L);
        }
        Main.getInstance().init(new StandaloneGUI(Main.getInstance(), MainStandalone.tmpFile()));
        if (filenameToOpen == null) {
            Main.getInstance().doNew();
        } else {
            Main.getInstance().doOpen(filenameToOpen);
        }
    }

    static void doConvert(File inputFile, String outputFormat, String outputParam) {
        if (!inputFile.exists()) {
            MainStandalone.printToConsole("File '" + inputFile.getAbsolutePath() + "' not found.");
            return;
        }
        DiagramHandler handler = new DiagramHandler(inputFile);
        String outputFileName = MainStandalone.determineOutputName(inputFile, outputFormat, outputParam);
        try {
            handler.getFileHandler().doExportAs(outputFormat, new File(outputFileName));
            MainStandalone.printToConsole("Conversion finished: \"" + inputFile.getAbsolutePath() + "\" to \"" + outputFileName + "\"");
        }
        catch (Exception e) {
            MainStandalone.printToConsole(e.getMessage());
        }
    }

    private static void printToConsole(String text) {
        System.out.println(text);
    }

    private static String determineOutputName(File inputFile, String outputFormat, String outputParam) {
        String outputFileName = outputParam == null ? inputFile.getAbsolutePath() : (new File(outputParam).isDirectory() ? outputParam + File.separator + inputFile.getName() : outputParam);
        return MainStandalone.createBatchOutputName(outputFormat, outputFileName);
    }

    private static String createBatchOutputName(String extension, String fileName) {
        if (fileName.endsWith(extension)) {
            return fileName;
        }
        return fileName + "." + extension;
    }

    private static void initHomeProgramPath() {
        String tempPath = Path.executable();
        tempPath = tempPath.substring(0, tempPath.length() - 1);
        if ((tempPath = tempPath.substring(0, tempPath.lastIndexOf(47) + 1)).endsWith("/lib/")) {
            tempPath = tempPath.substring(0, tempPath.length() - "lib/".length());
        }
        String realPath = new File(tempPath).getAbsolutePath() + "/";
        Path.setHomeProgram(realPath);
    }

    private static boolean sendFileNameToRunningApplication(String filename) {
        File f1 = MainStandalone.tmpFile();
        try {
            PrintWriter writer = new PrintWriter(f1);
            writer.println(filename);
            writer.close();
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    private static boolean alreadyRunningChecker(boolean force) {
        try {
            File f = MainStandalone.tmpFile();
            if (f.exists() && !force) {
                return true;
            }
            Path.safeCreateFile(f, false);
            new Timer("alreadyRunningChecker", true).schedule((TimerTask)new RunningFileChecker(MainStandalone.tmpFile(), Main.getInstance()), 0L, 1000L);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return true;
        }
        return false;
    }

    private static File tmpFile() {
        return new File(Path.temp() + Program.getInstance().getProgramName().toLowerCase() + ".tmp");
    }

    private static void readBuildInfoAndInitVersion(RuntimeType runtime) {
        InputStream stream = MainStandalone.class.getResourceAsStream("/BuildInfo.properties");
        if (stream == null) {
            throw new RuntimeException("Cannot load BuildInfo.properties");
        }
        Properties prop = new Properties();
        try {
            prop.load(stream);
            Program.init(prop.getProperty("version"), runtime);
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot load properties from file BuildInfo.properties", e);
        }
    }

    private static void printUsage() {
        StringBuilder formatBuilder = new StringBuilder("pdf|svg|eps");
        for (String format : ImageIO.getWriterFileSuffixes()) {
            formatBuilder.append("|").append(format);
        }
        MainStandalone.printToConsole("USAGE: -action=convert -format=(" + formatBuilder.toString() + ") -filename=inputfile." + Program.getInstance().getExtension() + " [-output=outputfile[.extension]]");
    }
}

