(function() {
    var connectors = {};
    [   "buttonPress", 
        "buttonRelease",  
        "closeTab",
        "contextMenu", 
        "documentLoaded", 
        "download", 
        "error", 
        "followHint", 
        "frameCreated", 
        "frameStatus", 
        "keyPress", 
        "keyRelease", 
        "loadCommitted",
        "loadFinished", 
        "loadStatus",
        "mimeType",
        "mouseMove", 
        "navigation", 
        "resource", 
        "scroll", 
        "tabButtonPress", 
        "tabFocus"
    ].forEach(function(sig) {
        var upper = sig[0].toUpperCase() + sig.slice(1);
        connectors["on" + upper] = {
            set : function(callback) {
                var self = this;
                Signal.connect(sig, function() {
                    callback.apply(this, arguments);
                }, function(w) { return w === self; });
            }
        };
        connectors["once" + upper] = {
            set : function(callback) {
                var self = this;
                Signal.once(sig, function() {
                    callback.apply(this, arguments);
                }, function(w) { return w === self; });
            }
        };
    });
    Object.defineProperties(WebKitWebView.prototype, connectors);

    Object.defineProperties(WebKitWebView.prototype, {
            loadString : 
            {
                value : function()
                {
                    return this.mainFrame.loadString.apply(this.mainFrame, arguments);
                }
            }
    });
})();
