/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.geo3d;

import org.apache.lucene.geo3d.Bounds;
import org.apache.lucene.geo3d.DistanceStyle;
import org.apache.lucene.geo3d.GeoBaseCircle;
import org.apache.lucene.geo3d.GeoPoint;
import org.apache.lucene.geo3d.Membership;
import org.apache.lucene.geo3d.Plane;
import org.apache.lucene.geo3d.PlanetModel;
import org.apache.lucene.geo3d.SidedPlane;

public class GeoStandardCircle
extends GeoBaseCircle {
    protected final GeoPoint center;
    protected final double cutoffAngle;
    protected final SidedPlane circlePlane;
    protected final GeoPoint[] edgePoints;
    protected static final GeoPoint[] circlePoints = new GeoPoint[0];

    public GeoStandardCircle(PlanetModel planetModel, double lat, double lon, double cutoffAngle) {
        super(planetModel);
        if (lat < -1.5707963267948966 || lat > 1.5707963267948966) {
            throw new IllegalArgumentException("Latitude out of bounds");
        }
        if (lon < -Math.PI || lon > Math.PI) {
            throw new IllegalArgumentException("Longitude out of bounds");
        }
        if (cutoffAngle < 0.0 || cutoffAngle > Math.PI) {
            throw new IllegalArgumentException("Cutoff angle out of bounds");
        }
        if (cutoffAngle < 1.0E-12) {
            throw new IllegalArgumentException("Cutoff angle cannot be effectively zero");
        }
        this.center = new GeoPoint(planetModel, lat, lon);
        this.cutoffAngle = cutoffAngle;
        double upperLat = lat + cutoffAngle;
        double upperLon = lon;
        if (upperLat > 1.5707963267948966) {
            if ((upperLon += Math.PI) > Math.PI) {
                upperLon -= Math.PI * 2;
            }
            upperLat = Math.PI - upperLat;
        }
        double lowerLat = lat - cutoffAngle;
        double lowerLon = lon;
        if (lowerLat < -1.5707963267948966) {
            if ((lowerLon += Math.PI) > Math.PI) {
                lowerLon -= Math.PI * 2;
            }
            lowerLat = -Math.PI - lowerLat;
        }
        GeoPoint upperPoint = new GeoPoint(planetModel, upperLat, upperLon);
        GeoPoint lowerPoint = new GeoPoint(planetModel, lowerLat, lowerLon);
        if (Math.abs(cutoffAngle - Math.PI) < 1.0E-12) {
            this.circlePlane = null;
            this.edgePoints = new GeoPoint[0];
        } else {
            Plane normalPlane = Plane.constructNormalizedZPlane(upperPoint, lowerPoint, this.center);
            this.circlePlane = SidedPlane.constructNormalizedPerpendicularSidedPlane(this.center, normalPlane, upperPoint, lowerPoint);
            if (this.circlePlane == null) {
                throw new IllegalArgumentException("Couldn't construct circle plane, probably too small?  Cutoff angle = " + cutoffAngle + "; upperPoint = " + upperPoint + "; lowerPoint = " + lowerPoint);
            }
            GeoPoint recomputedIntersectionPoint = this.circlePlane.getSampleIntersectionPoint(planetModel, normalPlane);
            if (recomputedIntersectionPoint == null) {
                throw new IllegalArgumentException("Couldn't construct intersection point, probably circle too small?  Plane = " + this.circlePlane);
            }
            this.edgePoints = new GeoPoint[]{recomputedIntersectionPoint};
        }
    }

    @Override
    public double getRadius() {
        return this.cutoffAngle;
    }

    @Override
    public GeoPoint getCenter() {
        return this.center;
    }

    @Override
    protected double distance(DistanceStyle distanceStyle, double x, double y, double z) {
        return distanceStyle.computeDistance(this.center, x, y, z);
    }

    @Override
    protected double outsideDistance(DistanceStyle distanceStyle, double x, double y, double z) {
        return distanceStyle.computeDistance(this.planetModel, (Plane)this.circlePlane, x, y, z, new Membership[0]);
    }

    @Override
    public boolean isWithin(double x, double y, double z) {
        if (this.circlePlane == null) {
            return true;
        }
        return this.circlePlane.isWithin(x, y, z);
    }

    @Override
    public GeoPoint[] getEdgePoints() {
        return this.edgePoints;
    }

    @Override
    public boolean intersects(Plane p, GeoPoint[] notablePoints, Membership ... bounds) {
        if (this.circlePlane == null) {
            return false;
        }
        return this.circlePlane.intersects(this.planetModel, p, notablePoints, circlePoints, bounds, new Membership[0]);
    }

    @Override
    public void getBounds(Bounds bounds) {
        super.getBounds(bounds);
        if (this.circlePlane == null) {
            return;
        }
        bounds.addPoint(this.center);
        bounds.addPlane(this.planetModel, this.circlePlane, new Membership[0]);
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof GeoStandardCircle)) {
            return false;
        }
        GeoStandardCircle other = (GeoStandardCircle)o;
        return super.equals(other) && other.center.equals(this.center) && other.cutoffAngle == this.cutoffAngle;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.center.hashCode();
        long temp = Double.doubleToLongBits(this.cutoffAngle);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public String toString() {
        return "GeoStandardCircle: {planetmodel=" + this.planetModel + ", center=" + this.center + ", radius=" + this.cutoffAngle + "(" + this.cutoffAngle * 180.0 / Math.PI + ")}";
    }
}

