/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util;

import java.io.IOException;
import java.util.regex.Pattern;
import org.jruby.ir.IRClassBody;
import org.jruby.ir.IRClosure;
import org.jruby.ir.IRMetaClassBody;
import org.jruby.ir.IRMethod;
import org.jruby.ir.IRModuleBody;
import org.jruby.ir.IRScope;
import org.jruby.ir.IRScriptBody;
import org.jruby.platform.Platform;
import org.jruby.util.JRubyFile;

public class JavaNameMangler {
    public static final Pattern PATH_SPLIT = Pattern.compile("[/\\\\]");
    private static final String DANGEROUS_CHARS = "\\/.;:$[]<>";
    private static final String REPLACEMENT_CHARS = "-|,?!%{}^_";
    private static final char ESCAPE_C = '\\';
    private static final char NULL_ESCAPE_C = '=';
    private static final String NULL_ESCAPE = "\\=";

    public static String mangledFilenameForStartupClasspath(String filename2) {
        if (filename2.length() == 2 && filename2.charAt(0) == '-' && filename2.charAt(1) == 'e') {
            return "ruby/__dash_e__";
        }
        return JavaNameMangler.mangleFilenameForClasspath(filename2, null, "", false, false);
    }

    public static String mangleFilenameForClasspath(String filename2) {
        return JavaNameMangler.mangleFilenameForClasspath(filename2, null, "ruby");
    }

    public static String mangleFilenameForClasspath(String filename2, String parent, String prefix) {
        return JavaNameMangler.mangleFilenameForClasspath(filename2, parent, prefix, true, false);
    }

    public static String mangleFilenameForClasspath(String filename2, String parent, String prefix, boolean canonicalize, boolean preserveIdentifiers) {
        String classPath;
        int idx = filename2.indexOf(33);
        if (idx != -1) {
            String before = filename2.substring(6, idx);
            try {
                if (canonicalize) {
                    classPath = new JRubyFile(before + filename2.substring(idx + 1)).getCanonicalPath();
                }
                classPath = new JRubyFile(before + filename2.substring(idx + 1)).toString();
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
        } else {
            try {
                classPath = canonicalize ? new JRubyFile(filename2).getCanonicalPath() : new JRubyFile(filename2).toString();
            }
            catch (IOException ioe) {
                classPath = filename2;
            }
        }
        if (parent != null && parent.length() > 0) {
            String parentPath;
            try {
                parentPath = canonicalize ? new JRubyFile(parent).getCanonicalPath() : new JRubyFile(parent).toString();
            }
            catch (IOException ioe) {
                parentPath = parent;
            }
            if (!classPath.startsWith(parentPath)) {
                throw new RuntimeException("File path " + classPath + " does not start with parent path " + parentPath);
            }
            int parentLength = parentPath.length();
            classPath = classPath.substring(parentLength);
        }
        String[] pathElements = PATH_SPLIT.split(classPath);
        StringBuilder newPath = new StringBuilder(classPath.length() + 16).append(prefix);
        for (String element : pathElements) {
            if (element.length() <= 0) continue;
            if (newPath.length() > 0) {
                newPath.append('/');
            }
            if (!Character.isJavaIdentifierStart(element.charAt(0))) {
                newPath.append('$');
            }
            if (!preserveIdentifiers) {
                JavaNameMangler.mangleStringForCleanJavaIdentifier(newPath, element);
                continue;
            }
            newPath.append(element);
        }
        int dotRbIndex = newPath.indexOf("_dot_rb");
        if (dotRbIndex != -1 && dotRbIndex == newPath.length() - 7) {
            newPath.delete(dotRbIndex, dotRbIndex + 7);
        }
        return newPath.toString();
    }

    public static String mangleStringForCleanJavaIdentifier(String name2) {
        StringBuilder cleanBuffer = new StringBuilder(name2.length() * 3);
        JavaNameMangler.mangleStringForCleanJavaIdentifier(cleanBuffer, name2);
        return cleanBuffer.toString();
    }

    private static void mangleStringForCleanJavaIdentifier(StringBuilder buffer, String name2) {
        char[] chars2 = name2.toCharArray();
        int len = chars2.length;
        buffer.ensureCapacity(buffer.length() + len * 2);
        boolean prevWasReplaced = false;
        block16: for (int i2 = 0; i2 < len; ++i2) {
            if (i2 == 0 && Character.isJavaIdentifierStart(chars2[i2]) || Character.isJavaIdentifierPart(chars2[i2])) {
                buffer.append(chars2[i2]);
                prevWasReplaced = false;
                continue;
            }
            if (!prevWasReplaced) {
                buffer.append('_');
            }
            prevWasReplaced = true;
            switch (chars2[i2]) {
                case '?': {
                    buffer.append("p_");
                    continue block16;
                }
                case '!': {
                    buffer.append("b_");
                    continue block16;
                }
                case '<': {
                    buffer.append("lt_");
                    continue block16;
                }
                case '>': {
                    buffer.append("gt_");
                    continue block16;
                }
                case '=': {
                    buffer.append("equal_");
                    continue block16;
                }
                case '[': {
                    if (i2 + 1 < len && chars2[i2 + 1] == ']') {
                        buffer.append("aref_");
                        ++i2;
                        continue block16;
                    }
                    buffer.append("lbracket_");
                    continue block16;
                }
                case ']': {
                    buffer.append("rbracket_");
                    continue block16;
                }
                case '+': {
                    buffer.append("plus_");
                    continue block16;
                }
                case '-': {
                    buffer.append("minus_");
                    continue block16;
                }
                case '*': {
                    buffer.append("times_");
                    continue block16;
                }
                case '/': {
                    buffer.append("div_");
                    continue block16;
                }
                case '&': {
                    buffer.append("and_");
                    continue block16;
                }
                case '.': {
                    buffer.append("dot_");
                    continue block16;
                }
                case '@': {
                    buffer.append("at_");
                }
                default: {
                    buffer.append(Integer.toHexString(chars2[i2])).append('_');
                }
            }
        }
    }

    public static String mangleMethodName(String name2) {
        StringBuilder builder = null;
        for (int i2 = 0; i2 < name2.length(); ++i2) {
            char candidate = name2.charAt(i2);
            int escape = JavaNameMangler.escapeChar(candidate);
            if (escape != -1) {
                if (builder == null) {
                    builder = new StringBuilder();
                    builder.append(NULL_ESCAPE);
                    builder.append(name2.substring(0, i2));
                }
                builder.append('\\').append((char)escape);
                continue;
            }
            if (builder == null) continue;
            builder.append(candidate);
        }
        if (builder != null) {
            return builder.toString();
        }
        return name2;
    }

    public static String demangleMethodName(String name2) {
        if (!name2.startsWith(NULL_ESCAPE)) {
            return name2;
        }
        int len = name2.length();
        StringBuilder builder = new StringBuilder(len);
        for (int i2 = 2; i2 < len; ++i2) {
            char candidate = name2.charAt(i2);
            if (candidate == '\\') {
                char escaped = name2.charAt(++i2);
                char unescape = JavaNameMangler.unescapeChar(escaped);
                builder.append(unescape);
                continue;
            }
            builder.append(candidate);
        }
        return builder.toString();
    }

    public static boolean willMethodMangleOk(String name2) {
        if (Platform.IS_IBM) {
            for (char c : name2.toCharArray()) {
                if (Character.isJavaIdentifierPart(c)) continue;
                return false;
            }
        }
        return true;
    }

    private static int escapeChar(char character) {
        int index2 = DANGEROUS_CHARS.indexOf(character);
        if (index2 == -1) {
            return -1;
        }
        return REPLACEMENT_CHARS.charAt(index2);
    }

    private static char unescapeChar(char character) {
        return DANGEROUS_CHARS.charAt(REPLACEMENT_CHARS.indexOf(character));
    }

    public static String encodeScopeForBacktrace(IRScope scope) {
        if (scope instanceof IRMethod) {
            return "RUBY$method$" + JavaNameMangler.mangleMethodName(scope.getName());
        }
        if (scope instanceof IRClosure) {
            return "RUBY$block$" + JavaNameMangler.mangleMethodName(scope.getNearestTopLocalVariableScope().getName());
        }
        if (scope instanceof IRMetaClassBody) {
            return "RUBY$metaclass";
        }
        if (scope instanceof IRClassBody) {
            return "RUBY$class$" + JavaNameMangler.mangleMethodName(scope.getName());
        }
        if (scope instanceof IRModuleBody) {
            return "RUBY$module$" + JavaNameMangler.mangleMethodName(scope.getName());
        }
        if (scope instanceof IRScriptBody) {
            return "RUBY$script";
        }
        throw new RuntimeException("unknown scope type for backtrace encoding: " + scope.getClass());
    }

    public static String decodeMethodForBacktrace(String methodName) {
        String type2;
        if (!methodName.startsWith("RUBY$")) {
            return null;
        }
        String[] elts = methodName.split("\\$");
        switch (type2 = elts[1]) {
            case "script": {
                return "<top>";
            }
            case "metaclass": {
                return "singleton class";
            }
        }
        String name2 = JavaNameMangler.demangleMethodName(elts[2]);
        switch (type2) {
            case "method": {
                return name2;
            }
            case "block": {
                return "block in " + name2;
            }
            case "class": 
            case "module": {
                return "<" + type2 + ":" + name2 + ">";
            }
        }
        throw new RuntimeException("unknown encoded method type '" + type2 + "' from '" + methodName);
    }
}

