/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.ui.news;

import de.jensd.fx.glyphs.GlyphsDude;
import de.jensd.fx.glyphs.materialdesignicons.MaterialDesignIcon;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.scene.text.Text;
import javafx.scene.text.TextAlignment;
import javafx.scene.text.TextFlow;
import org.apache.commons.lang3.StringUtils;
import org.pdfsam.news.NewsData;
import org.pdfsam.ui.commons.UrlButton;

public class News
extends VBox {
    private static final DateTimeFormatter FORMATTER = DateTimeFormatter.ofLocalizedDate(FormatStyle.MEDIUM);

    News(NewsData data) {
        this.getStyleClass().add((Object)"news-box");
        Text titleText = new Text(data.getTitle() + System.lineSeparator());
        titleText.getStyleClass().add((Object)"news-box-title");
        Text contentText = new Text(data.getContent());
        contentText.setTextAlignment(TextAlignment.JUSTIFY);
        contentText.getStyleClass().add((Object)"news-content");
        TextFlow flow = new TextFlow(new Node[]{titleText, contentText});
        flow.setTextAlignment(TextAlignment.JUSTIFY);
        Label labelDate = new Label(FORMATTER.format(data.getDate()), (Node)GlyphsDude.createIcon(MaterialDesignIcon.CLOCK));
        labelDate.setPrefWidth(2.147483647E9);
        HBox.setHgrow((Node)labelDate, (Priority)Priority.ALWAYS);
        HBox bottom = new HBox(new Node[]{labelDate});
        bottom.setAlignment(Pos.CENTER_LEFT);
        bottom.getStyleClass().add((Object)"news-box-footer");
        if (StringUtils.isNotBlank(data.getLink())) {
            UrlButton link = UrlButton.urlButton(null, data.getLink(), MaterialDesignIcon.DOTS_HORIZONTAL, "pdfsam-toolbar-button");
            bottom.getChildren().add((Object)link);
        }
        this.getChildren().addAll((Object[])new Node[]{flow, bottom});
    }
}

