/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.ui.notification;

import java.util.UUID;
import javafx.animation.FadeTransition;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.BorderPane;
import javafx.util.Duration;
import org.pdfsam.support.RequireUtils;
import org.pdfsam.ui.notification.RemoveNotificationRequestEvent;
import org.sejda.eventstudio.StaticStudio;

class Notification
extends BorderPane {
    private FadeTransition fade = new FadeTransition(Duration.millis((double)500.0), (Node)this);

    Notification(String title, Node content) {
        RequireUtils.requireNotNull(content, "Notification content cannot be blank");
        this.getStyleClass().add((Object)"notification");
        this.setId(UUID.randomUUID().toString());
        Label titleLabel = new Label(title);
        titleLabel.getStyleClass().add((Object)"notification-title");
        BorderPane.setAlignment((Node)content, (Pos)Pos.CENTER_LEFT);
        this.setTop((Node)titleLabel);
        this.setCenter(content);
        this.setOpacity(0.0);
        this.setOnMouseEntered(e -> {
            this.fade.stop();
            this.setOpacity(1.0);
        });
        this.setOnMouseClicked(e -> {
            this.setOnMouseEntered(null);
            this.setOnMouseExited(null);
            this.fade.stop();
            StaticStudio.eventStudio().broadcast(new RemoveNotificationRequestEvent(this.getId()));
        });
        this.setOnMouseExited(e -> this.fadeAway(Duration.millis((double)2500.0)));
        this.fade.setFromValue(1.0);
        this.fade.setToValue(0.0);
    }

    void onFade(EventHandler<ActionEvent> onFaded) {
        this.fade.setOnFinished(onFaded);
    }

    void fadeAway(Duration delay) {
        this.fade.stop();
        this.fade.setDelay(delay);
        this.fade.jumpTo(Duration.ZERO);
        this.fade.play();
    }

    void fadeAway() {
        this.fadeAway(Duration.ZERO);
    }
}

