/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.testkit.runner.internal;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.gradle.testkit.jarjar.org.apache.commons.io.output.TeeOutputStream;
import org.gradle.testkit.jarjar.org.gradle.internal.SystemProperties;
import org.gradle.testkit.jarjar.org.gradle.util.CollectionUtils;
import org.gradle.testkit.jarjar.org.gradle.util.GradleVersion;
import org.gradle.testkit.jarjar.org.gradle.wrapper.GradleUserHomeLookup;
import org.gradle.testkit.runner.BuildTask;
import org.gradle.testkit.runner.InvalidRunnerConfigurationException;
import org.gradle.testkit.runner.TaskOutcome;
import org.gradle.testkit.runner.internal.BuildOperationParameters;
import org.gradle.testkit.runner.internal.DefaultBuildTask;
import org.gradle.testkit.runner.internal.GradleExecutionParameters;
import org.gradle.testkit.runner.internal.GradleExecutionResult;
import org.gradle.testkit.runner.internal.GradleExecutor;
import org.gradle.testkit.runner.internal.dist.GradleDistribution;
import org.gradle.testkit.runner.internal.dist.InstalledGradleDistribution;
import org.gradle.testkit.runner.internal.dist.URILocatedGradleDistribution;
import org.gradle.testkit.runner.internal.dist.VersionBasedGradleDistribution;
import org.gradle.testkit.runner.internal.io.NoCloseOutputStream;
import org.gradle.testkit.runner.internal.io.SynchronizedOutputStream;
import org.gradle.tooling.BuildException;
import org.gradle.tooling.GradleConnectionException;
import org.gradle.tooling.GradleConnector;
import org.gradle.tooling.ProjectConnection;
import org.gradle.tooling.UnsupportedVersionException;
import org.gradle.tooling.events.ProgressEvent;
import org.gradle.tooling.events.ProgressListener;
import org.gradle.tooling.events.task.TaskFailureResult;
import org.gradle.tooling.events.task.TaskFinishEvent;
import org.gradle.tooling.events.task.TaskOperationResult;
import org.gradle.tooling.events.task.TaskSkippedResult;
import org.gradle.tooling.events.task.TaskStartEvent;
import org.gradle.tooling.events.task.TaskSuccessResult;
import org.gradle.tooling.internal.consumer.DefaultBuildLauncher;
import org.gradle.tooling.internal.consumer.DefaultGradleConnector;
import org.gradle.tooling.model.build.BuildEnvironment;

public class ToolingApiGradleExecutor
implements GradleExecutor {
    public static final String TEST_KIT_DAEMON_DIR_NAME = "test-kit-daemon";
    private static final String CLEANUP_THREAD_NAME = "gradle-runner-cleanup";
    private static final AtomicBoolean SHUTDOWN_REGISTERED = new AtomicBoolean();

    private static void maybeRegisterCleanup() {
        if (SHUTDOWN_REGISTERED.compareAndSet(false, true)) {
            Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

                public void run() {
                    DefaultGradleConnector.close();
                }
            }, CLEANUP_THREAD_NAME));
        }
    }

    public GradleExecutionResult run(GradleExecutionParameters parameters) {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        SynchronizedOutputStream syncOutput = new SynchronizedOutputStream(output);
        ArrayList<BuildTask> tasks = new ArrayList<BuildTask>();
        ToolingApiGradleExecutor.maybeRegisterCleanup();
        GradleConnector gradleConnector = this.buildConnector(parameters.getGradleUserHome(), parameters.getProjectDir(), parameters.isEmbedded(), parameters.getGradleDistribution());
        ProjectConnection connection = null;
        GradleVersion targetGradleVersion = null;
        try {
            connection = gradleConnector.connect();
            targetGradleVersion = this.determineTargetGradleVersion(connection);
            DefaultBuildLauncher launcher = (DefaultBuildLauncher)connection.newBuild();
            launcher.setStandardOutput(new NoCloseOutputStream(ToolingApiGradleExecutor.teeOutput(syncOutput, parameters.getStandardOutput())));
            launcher.setStandardError(new NoCloseOutputStream(ToolingApiGradleExecutor.teeOutput(syncOutput, parameters.getStandardError())));
            launcher.addProgressListener(new TaskExecutionProgressListener(tasks));
            launcher.withArguments(parameters.getBuildArgs().toArray(new String[parameters.getBuildArgs().size()]));
            launcher.setJvmArguments(parameters.getJvmArgs().toArray(new String[parameters.getJvmArgs().size()]));
            launcher.withInjectedClassPath(parameters.getInjectedClassPath());
            launcher.run();
        }
        catch (UnsupportedVersionException e) {
            throw new InvalidRunnerConfigurationException("The build could not be executed due to a feature not being supported by the target Gradle version", e);
        }
        catch (BuildException t) {
            GradleExecutionResult gradleExecutionResult = new GradleExecutionResult(new BuildOperationParameters(targetGradleVersion, parameters.isEmbedded()), output.toString(), tasks, t);
            return gradleExecutionResult;
        }
        catch (GradleConnectionException t) {
            StringBuilder message = new StringBuilder("An error occurred executing build with ");
            if (parameters.getBuildArgs().isEmpty()) {
                message.append("no args");
            } else {
                message.append("args '");
                message.append(CollectionUtils.join(" ", parameters.getBuildArgs()));
                message.append("'");
            }
            message.append(" in directory '").append(parameters.getProjectDir().getAbsolutePath()).append("'");
            String capturedOutput = output.toString();
            if (!capturedOutput.isEmpty()) {
                message.append(". Output before error:").append(SystemProperties.getInstance().getLineSeparator()).append(capturedOutput);
            }
            throw new IllegalStateException(message.toString(), t);
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
        return new GradleExecutionResult(new BuildOperationParameters(targetGradleVersion, parameters.isEmbedded()), output.toString(), tasks);
    }

    private GradleVersion determineTargetGradleVersion(ProjectConnection connection) {
        BuildEnvironment buildEnvironment = connection.getModel(BuildEnvironment.class);
        return GradleVersion.version(buildEnvironment.getGradle().getGradleVersion());
    }

    private static OutputStream teeOutput(OutputStream capture, OutputStream user) {
        if (user == null) {
            return capture;
        }
        return new TeeOutputStream(capture, user);
    }

    private GradleConnector buildConnector(File gradleUserHome, File projectDir, boolean embedded, GradleDistribution gradleDistribution) {
        DefaultGradleConnector gradleConnector = (DefaultGradleConnector)GradleConnector.newConnector();
        this.useGradleDistribution(gradleConnector, gradleDistribution);
        gradleConnector.useGradleUserHomeDir(gradleUserHome);
        gradleConnector.daemonBaseDir(new File(gradleUserHome, TEST_KIT_DAEMON_DIR_NAME));
        gradleConnector.forProjectDirectory(projectDir);
        gradleConnector.searchUpwards(false);
        gradleConnector.daemonMaxIdleTime(120, TimeUnit.SECONDS);
        gradleConnector.embedded(embedded);
        return gradleConnector;
    }

    private void useGradleDistribution(DefaultGradleConnector gradleConnector, GradleDistribution gradleDistribution) {
        gradleConnector.useDistributionBaseDir(GradleUserHomeLookup.gradleUserHome());
        if (gradleDistribution instanceof InstalledGradleDistribution) {
            gradleConnector.useInstallation(((InstalledGradleDistribution)gradleDistribution).getGradleHome());
        } else if (gradleDistribution instanceof URILocatedGradleDistribution) {
            gradleConnector.useDistribution(((URILocatedGradleDistribution)gradleDistribution).getLocation());
        } else if (gradleDistribution instanceof VersionBasedGradleDistribution) {
            gradleConnector.useGradleVersion(((VersionBasedGradleDistribution)gradleDistribution).getGradleVersion());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TaskExecutionProgressListener
    implements ProgressListener {
        private final List<BuildTask> tasks;
        private final Map<String, Integer> order = new HashMap<String, Integer>();

        public TaskExecutionProgressListener(List<BuildTask> tasks) {
            this.tasks = tasks;
        }

        @Override
        public void statusChanged(ProgressEvent event) {
            if (event instanceof TaskStartEvent) {
                TaskStartEvent taskStartEvent = (TaskStartEvent)event;
                this.order.put(taskStartEvent.getDescriptor().getTaskPath(), this.tasks.size());
                this.tasks.add(null);
            }
            if (event instanceof TaskFinishEvent) {
                TaskFinishEvent taskFinishEvent = (TaskFinishEvent)event;
                String taskPath = taskFinishEvent.getDescriptor().getTaskPath();
                TaskOperationResult result = taskFinishEvent.getResult();
                Integer index = this.order.get(taskPath);
                if (index == null) {
                    throw new IllegalStateException("Received task finish event for task " + taskPath + " without first receiving task start event");
                }
                this.tasks.set(index, this.determineBuildTask(result, taskPath));
            }
        }

        private BuildTask determineBuildTask(TaskOperationResult result, String taskPath) {
            if (this.isFailed(result)) {
                return this.createBuildTask(taskPath, TaskOutcome.FAILED);
            }
            if (this.isSkipped(result)) {
                return this.createBuildTask(taskPath, TaskOutcome.SKIPPED);
            }
            if (this.isUpToDate(result)) {
                return this.createBuildTask(taskPath, TaskOutcome.UP_TO_DATE);
            }
            return this.createBuildTask(taskPath, TaskOutcome.SUCCESS);
        }

        private BuildTask createBuildTask(String taskPath, TaskOutcome outcome) {
            return new DefaultBuildTask(taskPath, outcome);
        }

        private boolean isFailed(TaskOperationResult result) {
            return result instanceof TaskFailureResult;
        }

        private boolean isSkipped(TaskOperationResult result) {
            return result instanceof TaskSkippedResult;
        }

        private boolean isUpToDate(TaskOperationResult result) {
            return result instanceof TaskSuccessResult && ((TaskSuccessResult)result).isUpToDate();
        }
    }
}

