/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.core;

import com.google.common.base.Optional;
import java.util.Collections;
import org.gradle.api.Nullable;
import org.gradle.internal.Cast;
import org.gradle.internal.reflect.DirectInstantiator;
import org.gradle.model.internal.core.ChildNodeInitializerStrategy;
import org.gradle.model.internal.core.ChildNodeInitializerStrategyAccessor;
import org.gradle.model.internal.core.DefaultModelViewState;
import org.gradle.model.internal.core.InstanceModelView;
import org.gradle.model.internal.core.ModelProjection;
import org.gradle.model.internal.core.ModelView;
import org.gradle.model.internal.core.MutableModelNode;
import org.gradle.model.internal.core.rule.describe.ModelRuleDescriptor;
import org.gradle.model.internal.manage.instance.ManagedInstance;
import org.gradle.model.internal.type.ModelType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpecializedModelMapProjection<P, E>
implements ModelProjection {
    private static final ModelType<ManagedInstance> MANAGED_INSTANCE_TYPE = ModelType.of(ManagedInstance.class);
    private final ModelType<P> publicType;
    private final ModelType<E> elementType;
    private final Class<? extends P> viewImpl;
    private final ChildNodeInitializerStrategyAccessor<? super E> creatorStrategyAccessor;

    public SpecializedModelMapProjection(ModelType<P> publicType, ModelType<E> elementType, Class<? extends P> viewImpl, ChildNodeInitializerStrategyAccessor<? super E> creatorStrategyAccessor) {
        this.publicType = publicType;
        this.elementType = elementType;
        this.viewImpl = viewImpl;
        this.creatorStrategyAccessor = creatorStrategyAccessor;
    }

    @Override
    public Iterable<String> getTypeDescriptions(MutableModelNode node) {
        return Collections.singleton(this.publicType.toString());
    }

    @Override
    @Nullable
    public <T> ModelView<? extends T> asImmutable(ModelType<T> type, MutableModelNode node, @Nullable ModelRuleDescriptor ruleDescriptor) {
        if (this.canBeViewedAs(type)) {
            return (ModelView)Cast.uncheckedCast(this.toView(node, ruleDescriptor, false));
        }
        return null;
    }

    @Override
    @Nullable
    public <T> ModelView<? extends T> asMutable(ModelType<T> type, MutableModelNode node, ModelRuleDescriptor ruleDescriptor) {
        if (this.canBeViewedAs(type)) {
            return (ModelView)Cast.uncheckedCast(this.toView(node, ruleDescriptor, true));
        }
        return null;
    }

    private ModelView<P> toView(MutableModelNode modelNode, ModelRuleDescriptor ruleDescriptor, boolean mutable) {
        ChildNodeInitializerStrategy<? super E> creatorStrategy = this.creatorStrategyAccessor.getStrategy(modelNode);
        DefaultModelViewState state = new DefaultModelViewState(this.publicType, ruleDescriptor, mutable, true);
        String description = this.publicType.getDisplayName() + " '" + modelNode.getPath() + "'";
        Object instance = DirectInstantiator.instantiate(this.viewImpl, (Object[])new Object[]{description, this.elementType, ruleDescriptor, modelNode, state, creatorStrategy});
        return InstanceModelView.of(modelNode.getPath(), this.publicType, instance, state.closer());
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SpecializedModelMapProjection that = (SpecializedModelMapProjection)o;
        return this.publicType.equals(that.publicType) && this.viewImpl.equals(that.viewImpl);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.publicType.hashCode();
        result = 31 * result + this.viewImpl.hashCode();
        return result;
    }

    @Override
    public <T> boolean canBeViewedAs(ModelType<T> targetType) {
        return targetType.equals(this.publicType) || targetType.equals(ModelType.UNTYPED) || targetType.equals(MANAGED_INSTANCE_TYPE);
    }

    @Override
    public Optional<String> getValueDescription(MutableModelNode modelNodeInternal) {
        return Optional.absent();
    }
}

