/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.inspect;

import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.List;
import org.gradle.api.Nullable;
import org.gradle.model.internal.core.ModelActionRole;
import org.gradle.model.internal.core.MutableModelNode;
import org.gradle.model.internal.inspect.AbstractAnnotationDrivenModelRuleExtractor;
import org.gradle.model.internal.inspect.ExtractedModelRule;
import org.gradle.model.internal.inspect.MethodBackedModelAction;
import org.gradle.model.internal.inspect.MethodModelRuleApplicationContext;
import org.gradle.model.internal.inspect.MethodModelRuleExtractionContext;
import org.gradle.model.internal.inspect.MethodRuleDefinition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMutationModelRuleExtractor<T extends Annotation>
extends AbstractAnnotationDrivenModelRuleExtractor<T> {
    @Override
    @Nullable
    public <R, S> ExtractedModelRule registration(MethodRuleDefinition<R, S> ruleDefinition, MethodModelRuleExtractionContext context) {
        this.validateIsVoidMethod(ruleDefinition, context);
        if (ruleDefinition.getReferences().isEmpty()) {
            context.add(ruleDefinition, "A method " + this.getDescription() + " must have at least one parameter");
        }
        if (context.hasProblems()) {
            return null;
        }
        return new ExtractedMutationRule<S>(this.getMutationType(), ruleDefinition);
    }

    protected abstract ModelActionRole getMutationType();

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ExtractedMutationRule<S>
    implements ExtractedModelRule {
        private final ModelActionRole mutationType;
        private final MethodRuleDefinition<?, S> ruleDefinition;

        public ExtractedMutationRule(ModelActionRole mutationType, MethodRuleDefinition<?, S> ruleDefinition) {
            this.mutationType = mutationType;
            this.ruleDefinition = ruleDefinition;
        }

        @Override
        public void apply(MethodModelRuleApplicationContext context, MutableModelNode target) {
            context.getRegistry().configure(this.mutationType, context.contextualize(this.ruleDefinition, new MethodBackedModelAction<S>(this.ruleDefinition.getDescriptor(), this.ruleDefinition.getSubjectReference(), this.ruleDefinition.getTailReferences())));
        }

        @Override
        public List<? extends Class<?>> getRuleDependencies() {
            return Collections.emptyList();
        }
    }
}

